/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Preconditions;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.TestUtils;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetWriterAppendBlocks {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public static final int FILE_SIZE = 10000;
    public static final Configuration CONF = new Configuration();
    public static final Map<String, String> EMPTY_METADATA = new HashMap<String, String>();
    public static final MessageType FILE_SCHEMA = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).named("id")).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string")).named("AppendTest");
    public static final SimpleGroupFactory GROUP_FACTORY = new SimpleGroupFactory(FILE_SCHEMA);
    private static final Path STATIC_FILE_1 = TestParquetWriterAppendBlocks.createPathFromCP("/test-append_1.parquet");
    private static final Path STATIC_FILE_2 = TestParquetWriterAppendBlocks.createPathFromCP("/test-append_2.parquet");
    public Path file1;
    public List<Group> file1content = new ArrayList<Group>();
    public Path file2;
    public List<Group> file2content = new ArrayList<Group>();

    private static Path createPathFromCP(String path) {
        try {
            return new Path(TestParquetWriterAppendBlocks.class.getResource(path).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void createSourceData() throws IOException {
        this.file1 = this.newTemp();
        this.file2 = this.newTemp();
        ParquetWriter writer1 = ExampleParquetWriter.builder((Path)this.file1).withType(FILE_SCHEMA).build();
        ParquetWriter writer2 = ExampleParquetWriter.builder((Path)this.file2).withType(FILE_SCHEMA).build();
        for (int i = 0; i < 10000; ++i) {
            Group group1 = GROUP_FACTORY.newGroup();
            group1.add("id", i);
            group1.add("string", UUID.randomUUID().toString());
            writer1.write((Object)group1);
            this.file1content.add(group1);
            Group group2 = GROUP_FACTORY.newGroup();
            group2.add("id", 10000 + i);
            group2.add("string", UUID.randomUUID().toString());
            writer2.write((Object)group2);
            this.file2content.add(group2);
        }
        writer1.close();
        writer2.close();
    }

    @Test
    public void testBasicBehavior() throws IOException {
        Group next;
        Path combinedFile = this.newTemp();
        ParquetFileWriter writer = new ParquetFileWriter(CONF, FILE_SCHEMA, combinedFile);
        writer.start();
        writer.appendFile(CONF, this.file1);
        writer.appendFile(CONF, this.file2);
        writer.end(EMPTY_METADATA);
        LinkedList<Group> expected = new LinkedList<Group>();
        expected.addAll(this.file1content);
        expected.addAll(this.file2content);
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)combinedFile).build();
        while ((next = (Group)reader.read()) != null) {
            Group expectedNext = (Group)expected.removeFirst();
            Assert.assertEquals((String)"Each id should match", (long)expectedNext.getInteger("id", 0), (long)next.getInteger("id", 0));
            Assert.assertEquals((String)"Each string should match", (Object)expectedNext.getString("string", 0), (Object)next.getString("string", 0));
        }
        Assert.assertEquals((String)"All records should be present", (long)0L, (long)expected.size());
    }

    @Test
    public void testBasicBehaviorWithStaticFiles() throws IOException {
        ArrayList<Group> expected = new ArrayList<Group>();
        this.readAll(STATIC_FILE_1, expected);
        this.readAll(STATIC_FILE_2, expected);
        Path combinedFile = this.newTemp();
        ParquetFileWriter writer = new ParquetFileWriter(CONF, FILE_SCHEMA, combinedFile);
        writer.start();
        writer.appendFile(CONF, STATIC_FILE_1);
        writer.appendFile(CONF, STATIC_FILE_2);
        writer.end(EMPTY_METADATA);
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)combinedFile).build();){
            for (Group expectedNext : expected) {
                Group next = (Group)reader.read();
                Assert.assertEquals((String)"Each id should match", (long)expectedNext.getInteger("id", 0), (long)next.getInteger("id", 0));
                Assert.assertEquals((String)"Each string should match", (Object)expectedNext.getString("string", 0), (Object)next.getString("string", 0));
            }
            Assert.assertNull((String)"No extra records should be present", (Object)reader.read());
        }
    }

    private void readAll(Path file, List<Group> values) throws IOException {
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).build();){
            Group g = (Group)reader.read();
            while (g != null) {
                values.add(g);
                g = (Group)reader.read();
            }
        }
    }

    @Test
    public void testMergedMetadata() throws IOException {
        Path combinedFile = this.newTemp();
        ParquetFileWriter writer = new ParquetFileWriter(CONF, FILE_SCHEMA, combinedFile);
        writer.start();
        writer.appendFile(CONF, this.file1);
        writer.appendFile(CONF, this.file2);
        writer.end(EMPTY_METADATA);
        ParquetMetadata combinedFooter = ParquetFileReader.readFooter((Configuration)CONF, (Path)combinedFile, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetMetadata f1Footer = ParquetFileReader.readFooter((Configuration)CONF, (Path)this.file1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetMetadata f2Footer = ParquetFileReader.readFooter((Configuration)CONF, (Path)this.file2, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        LinkedList expectedRowGroups = new LinkedList();
        expectedRowGroups.addAll(f1Footer.getBlocks());
        expectedRowGroups.addAll(f2Footer.getBlocks());
        Assert.assertEquals((String)"Combined should have the right number of row groups", (long)expectedRowGroups.size(), (long)combinedFooter.getBlocks().size());
        long nextStart = 4L;
        for (BlockMetaData rowGroup : combinedFooter.getBlocks()) {
            BlockMetaData expected = (BlockMetaData)expectedRowGroups.removeFirst();
            Assert.assertEquals((String)"Row count should match", (long)expected.getRowCount(), (long)rowGroup.getRowCount());
            Assert.assertEquals((String)"Compressed size should match", (long)expected.getCompressedSize(), (long)rowGroup.getCompressedSize());
            Assert.assertEquals((String)"Total size should match", (long)expected.getTotalByteSize(), (long)rowGroup.getTotalByteSize());
            Assert.assertEquals((String)"Start pos should be at the last row group's end", (long)nextStart, (long)rowGroup.getStartingPos());
            this.assertColumnsEquivalent(expected.getColumns(), rowGroup.getColumns());
            nextStart = rowGroup.getStartingPos() + rowGroup.getTotalByteSize();
        }
    }

    public void assertColumnsEquivalent(List<ColumnChunkMetaData> expected, List<ColumnChunkMetaData> actual) {
        Assert.assertEquals((String)"Should have the expected columns", (long)expected.size(), (long)actual.size());
        for (int i = 0; i < actual.size(); ++i) {
            ColumnChunkMetaData current = actual.get(i);
            if (i != 0) {
                ColumnChunkMetaData previous = actual.get(i - 1);
                long expectedStart = previous.getStartingPos() + previous.getTotalSize();
                Assert.assertEquals((String)"Should start after the previous column", (long)expectedStart, (long)current.getStartingPos());
            }
            this.assertColumnMetadataEquivalent(expected.get(i), current);
        }
    }

    public void assertColumnMetadataEquivalent(ColumnChunkMetaData expected, ColumnChunkMetaData actual) {
        Assert.assertEquals((String)"Should be the expected column", (Object)expected.getPath(), (Object)expected.getPath());
        Assert.assertEquals((String)"Primitive type should not change", (Object)expected.getType(), (Object)actual.getType());
        Assert.assertEquals((String)"Compression codec should not change", (Object)expected.getCodec(), (Object)actual.getCodec());
        Assert.assertEquals((String)"Data encodings should not change", (Object)expected.getEncodings(), (Object)actual.getEncodings());
        Assert.assertEquals((String)"Statistics should not change", (Object)expected.getStatistics(), (Object)actual.getStatistics());
        Assert.assertEquals((String)"Uncompressed size should not change", (long)expected.getTotalUncompressedSize(), (long)actual.getTotalUncompressedSize());
        Assert.assertEquals((String)"Compressed size should not change", (long)expected.getTotalSize(), (long)actual.getTotalSize());
        Assert.assertEquals((String)"Number of values should not change", (long)expected.getValueCount(), (long)actual.getValueCount());
    }

    @Test
    public void testAllowDroppingColumns() throws IOException {
        Group next;
        MessageType droppedColumnSchema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string")).named("AppendTest");
        Path droppedColumnFile = this.newTemp();
        ParquetFileWriter writer = new ParquetFileWriter(CONF, droppedColumnSchema, droppedColumnFile);
        writer.start();
        writer.appendFile(CONF, this.file1);
        writer.appendFile(CONF, this.file2);
        writer.end(EMPTY_METADATA);
        LinkedList<Group> expected = new LinkedList<Group>();
        expected.addAll(this.file1content);
        expected.addAll(this.file2content);
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)CONF, (Path)droppedColumnFile, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        for (BlockMetaData rowGroup : footer.getBlocks()) {
            Assert.assertEquals((String)"Should have only the string column", (long)1L, (long)rowGroup.getColumns().size());
        }
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)droppedColumnFile).build();
        while ((next = (Group)reader.read()) != null) {
            Group expectedNext = (Group)expected.removeFirst();
            Assert.assertEquals((String)"Each string should match", (Object)expectedNext.getString("string", 0), (Object)next.getString("string", 0));
        }
        Assert.assertEquals((String)"All records should be present", (long)0L, (long)expected.size());
    }

    @Test
    public void testFailDroppingColumns() throws IOException {
        MessageType droppedColumnSchema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string")).named("AppendTest");
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)CONF, (Path)this.file1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        FSDataInputStream incoming = this.file1.getFileSystem(CONF).open(this.file1);
        Path droppedColumnFile = this.newTemp();
        ParquetFileWriter writer = new ParquetFileWriter(CONF, droppedColumnSchema, droppedColumnFile);
        writer.start();
        TestUtils.assertThrows("Should complain that id column is dropped", IllegalArgumentException.class, () -> {
            writer.appendRowGroups(incoming, footer.getBlocks(), false);
            return null;
        });
    }

    @Test
    public void testFailMissingColumn() throws IOException {
        MessageType fileSchema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).named("id")).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("string")).required(PrimitiveType.PrimitiveTypeName.FLOAT).named("value")).named("AppendTest");
        Path missingColumnFile = this.newTemp();
        ParquetFileWriter writer = new ParquetFileWriter(CONF, fileSchema, missingColumnFile);
        writer.start();
        TestUtils.assertThrows("Should complain that value column is missing", IllegalArgumentException.class, () -> {
            writer.appendFile(CONF, this.file1);
            return null;
        });
    }

    private Path newTemp() throws IOException {
        File file = this.temp.newFile();
        Preconditions.checkArgument((boolean)file.delete(), (String)"Could not remove temp file");
        return new Path(file.toString());
    }
}

