/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.hadoop.codec.Lz4RawCodec;
import org.apache.parquet.hadoop.codec.NonBlockedDecompressorStream;
import org.apache.parquet.hadoop.codec.SnappyCodec;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCompressionCodec {
    @Test
    public void testLz4RawBlock() throws IOException {
        this.testBlock(CompressionCodecName.LZ4_RAW);
    }

    @Test
    public void testSnappyBlock() throws IOException {
        this.testBlock(CompressionCodecName.SNAPPY);
    }

    private void testBlock(CompressionCodecName codecName) throws IOException {
        CompressionCodec codec = this.getCodec(codecName, 4096);
        Compressor compressor = codec.createCompressor();
        Decompressor decompressor = codec.createDecompressor();
        this.testBlockCompression(compressor, decompressor, "");
        this.testBlockCompression(compressor, decompressor, "FooBar");
        this.testBlockCompression(compressor, decompressor, "FooBar1FooBar2");
        this.testBlockCompression(compressor, decompressor, "FooBar");
        this.testBlockCompression(compressor, decompressor, "ablahblahblahabcdef");
        this.testBlockCompression(compressor, decompressor, "");
        this.testBlockCompression(compressor, decompressor, "FooBar");
    }

    private void testBlockCompression(Compressor compressor, Decompressor decompressor, String data) throws IOException {
        compressor.reset();
        decompressor.reset();
        int uncompressedSize = data.length();
        byte[] uncompressedData = data.getBytes();
        assert (compressor.needsInput());
        compressor.setInput(uncompressedData, 0, uncompressedSize);
        assert (compressor.needsInput());
        compressor.finish();
        assert (!compressor.needsInput());
        assert (!compressor.finished() || uncompressedSize == 0);
        byte[] compressedData = new byte[1000];
        int compressedSize = compressor.compress(compressedData, 0, 1000);
        assert (compressor.finished());
        assert (!decompressor.finished());
        assert (decompressor.needsInput());
        decompressor.setInput(compressedData, 0, compressedSize);
        assert (!decompressor.finished());
        byte[] decompressedData = new byte[uncompressedSize];
        int decompressedSize = decompressor.decompress(decompressedData, 0, uncompressedSize);
        assert (decompressor.finished());
        Assert.assertEquals((long)uncompressedSize, (long)decompressedSize);
        Assert.assertArrayEquals((byte[])uncompressedData, (byte[])decompressedData);
    }

    @Test
    public void testLz4RawCodec() throws IOException {
        this.testCodec(CompressionCodecName.LZ4_RAW);
    }

    @Test
    public void testSnappyCodec() throws IOException {
        this.testCodec(CompressionCodecName.SNAPPY);
    }

    private void testCodec(CompressionCodecName codecName) throws IOException {
        int[] bufferSizes = new int[]{128, 1024, 4096, 16384, 131072, 0x100000};
        int[] dataSizes = new int[]{0, 1, 10, 128, 1024, 2048, 0x100000};
        for (int i = 0; i < bufferSizes.length; ++i) {
            CompressionCodec codec = this.getCodec(codecName, bufferSizes[i]);
            for (int j = 0; j < dataSizes.length; ++j) {
                this.testCodec(codec, dataSizes[j], dataSizes[j]);
                this.testCodec(codec, dataSizes[j], 128);
            }
        }
    }

    private void testCodec(CompressionCodec codec, int dataSize, int repeatSize) throws IOException {
        byte[] data = new byte[dataSize];
        if (repeatSize >= dataSize) {
            new Random().nextBytes(data);
        } else {
            byte[] repeat = new byte[repeatSize];
            new Random().nextBytes(repeat);
            for (int offset = 0; offset < dataSize; offset += repeatSize) {
                System.arraycopy(repeat, 0, data, offset, Math.min(repeatSize, dataSize - offset));
            }
        }
        BytesInput compressedData = this.compress(codec, BytesInput.from((byte[])data));
        byte[] decompressedData = this.decompress(codec, compressedData, data.length);
        Assert.assertArrayEquals((byte[])data, (byte[])decompressedData);
    }

    private BytesInput compress(CompressionCodec codec, BytesInput bytes) throws IOException {
        ByteArrayOutputStream compressedOutBuffer = new ByteArrayOutputStream((int)bytes.size());
        CompressionOutputStream cos = codec.createOutputStream((OutputStream)compressedOutBuffer);
        bytes.writeAllTo((OutputStream)cos);
        cos.close();
        return BytesInput.from((ByteArrayOutputStream)compressedOutBuffer);
    }

    private byte[] decompress(CompressionCodec codec, BytesInput bytes, int uncompressedSize) throws IOException {
        CompressionInputStream is = codec.createInputStream((InputStream)bytes.toInputStream());
        byte[] decompressed = BytesInput.from((InputStream)is, (int)uncompressedSize).toByteArray();
        is.close();
        return decompressed;
    }

    private CompressionCodec getCodec(CompressionCodecName codecName, int bufferSize) {
        switch (codecName) {
            case LZ4_RAW: {
                Configuration conf = new Configuration();
                conf.setInt("io.file.buffer.size", bufferSize);
                Lz4RawCodec codec = new Lz4RawCodec();
                codec.setConf(conf);
                return codec;
            }
            case SNAPPY: {
                Configuration conf = new Configuration();
                conf.setInt("io.file.buffer.size", bufferSize);
                SnappyCodec codec = new SnappyCodec();
                codec.setConf(conf);
                return codec;
            }
        }
        return null;
    }

    @Test
    public void TestDecompressorInvalidState() throws IOException {
        Decompressor mockDecompressor = (Decompressor)Mockito.mock(Decompressor.class);
        Mockito.when((Object)mockDecompressor.decompress((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)0);
        NonBlockedDecompressorStream decompressorStream = new NonBlockedDecompressorStream((InputStream)new ByteArrayInputStream(new byte[0]), mockDecompressor, 1024);
        Assert.assertThrows(IOException.class, () -> decompressorStream.read(new byte[1024], 0, 1024));
    }
}

