/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.statistics.Statistics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class TestUtils {
    public static void enforceEmptyDir(Configuration conf, Path path) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        if (fs.exists(path) && !fs.delete(path, true)) {
            throw new IOException("can not delete path " + path);
        }
        if (!fs.mkdirs(path)) {
            throw new IOException("can not create path " + path);
        }
    }

    public static void assertThrows(String message, Class<? extends Exception> expected, Callable callable) {
        try {
            callable.call();
            Assert.fail((String)("No exception was thrown (" + message + "), expected: " + expected.getName()));
        }
        catch (Exception actual) {
            try {
                Assert.assertEquals((String)message, expected, actual.getClass());
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).addSuppressed(actual);
                throw e;
            }
        }
    }

    public static void assertStatsValuesEqual(Statistics<?> stats1, Statistics<?> stats2) {
        TestUtils.assertStatsValuesEqual(null, stats1, stats2);
    }

    public static void assertStatsValuesEqual(String message, Statistics<?> expected, Statistics<?> actual) {
        if (expected == actual) {
            return;
        }
        if (expected == null || actual == null) {
            Assert.assertEquals(expected, actual);
        }
        Assert.assertThat(actual, (Matcher)CoreMatchers.instanceOf(expected.getClass()));
        Assert.assertArrayEquals((String)message, (byte[])expected.getMaxBytes(), (byte[])actual.getMaxBytes());
        Assert.assertArrayEquals((String)message, (byte[])expected.getMinBytes(), (byte[])actual.getMinBytes());
        Assert.assertEquals((String)message, (long)expected.getNumNulls(), (long)actual.getNumNulls());
    }
}

