/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ColumnMasker;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnMaskerTest {
    private Configuration conf = new Configuration();
    private Map<String, String> extraMeta = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
    private ColumnMasker columnMasker = new ColumnMasker();
    private Random rnd = new Random(5L);
    private final int numRecord = 1000;
    private String inputFile = null;
    private String outputFile = null;
    private TestDocs testDocs = null;

    @Before
    public void testSetup() throws Exception {
        this.testDocs = new TestDocs(1000);
        this.inputFile = this.createParquetFile(this.conf, this.extraMeta, 1000, "input", "GZIP", ParquetProperties.WriterVersion.PARQUET_1_0, 0x100000, this.testDocs);
        this.outputFile = this.createTempFile("test");
        this.nullifyColumns(this.conf, this.inputFile, this.outputFile);
    }

    @Test(expected=RuntimeException.class)
    public void testNullColumns() throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.outputFile)).withConf(this.conf).build();
        Group group = (Group)reader.read();
        group.getLong("DocId", 0);
        reader.close();
    }

    @Test(expected=RuntimeException.class)
    public void testNullNestedColumns() throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.outputFile)).withConf(this.conf).build();
        Group group = (Group)reader.read();
        Group subGroup = group.getGroup("Links", 0);
        subGroup.getBinary("Backward", 0).getBytes();
        reader.close();
    }

    @Test
    public void validateNonNuLLColumns() throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.outputFile)).withConf(this.conf).build();
        for (int i = 0; i < 1000; ++i) {
            Group group = (Group)reader.read();
            Assert.assertArrayEquals((byte[])group.getBinary("Name", 0).getBytes(), (byte[])this.testDocs.name[i].getBytes());
            Group subGroup = group.getGroup("Links", 0);
            Assert.assertArrayEquals((byte[])subGroup.getBinary("Forward", 0).getBytes(), (byte[])this.testDocs.linkForward[i].getBytes());
        }
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nullifyColumns(Configuration conf, String inputFile, String outputFile) throws IOException {
        Path inPath = new Path(inputFile);
        Path outPath = new Path(outputFile);
        ParquetMetadata metaData = ParquetFileReader.readFooter((Configuration)conf, (Path)inPath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = metaData.getFileMetaData().getSchema();
        ParquetFileWriter writer = new ParquetFileWriter(conf, schema, outPath, ParquetFileWriter.Mode.OVERWRITE);
        writer.start();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("DocId");
        paths.add("Gender");
        paths.add("Links.Backward");
        try (CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)inPath, (Configuration)conf), HadoopReadOptions.builder((Configuration)conf).build());){
            this.columnMasker.processBlocks(reader, writer, metaData, schema, paths, ColumnMasker.MaskMode.NULLIFY);
        }
        finally {
            writer.end(metaData.getFileMetaData().getKeyValueMetaData());
        }
    }

    private String createParquetFile(Configuration conf, Map<String, String> extraMeta, int numRecord, String prefix, String codec, ParquetProperties.WriterVersion writerVersion, int pageSize, TestDocs testDocs) throws IOException {
        MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
        conf.set("parquet.example.schema", schema.toString());
        String file = this.createTempFile(prefix);
        ExampleParquetWriter.Builder builder = (ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(file)).withConf(conf)).withWriterVersion(writerVersion)).withExtraMetaData(extraMeta).withDictionaryEncoding("DocId", true)).withDictionaryEncoding("Name", true)).withValidation(true)).enablePageWriteChecksum()).withPageSize(pageSize)).withCompressionCodec(CompressionCodecName.valueOf((String)codec));
        try (ParquetWriter writer = builder.build();){
            for (int i = 0; i < numRecord; ++i) {
                SimpleGroup g = new SimpleGroup((GroupType)schema);
                g.add("DocId", testDocs.docId[i]);
                g.add("Name", testDocs.name[i]);
                g.add("Gender", testDocs.gender[i]);
                Group links = g.addGroup("Links");
                links.add(0, testDocs.linkBackward[i]);
                links.add(1, testDocs.linkForward[i]);
                writer.write((Object)g);
            }
        }
        return file;
    }

    private static long getLong() {
        return ThreadLocalRandom.current().nextLong(1000L);
    }

    private String getString() {
        char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'x', 'z', 'y'};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            sb.append(chars[this.rnd.nextInt(10)]);
        }
        return sb.toString();
    }

    private String createTempFile(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toAbsolutePath().toString() + "/test.parquet";
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }

    private class TestDocs {
        public long[] docId;
        public String[] name;
        public String[] gender;
        public String[] linkBackward;
        public String[] linkForward;

        public TestDocs(int numRecord) {
            int i;
            this.docId = new long[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.docId[i] = ColumnMaskerTest.getLong();
            }
            this.name = new String[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.name[i] = ColumnMaskerTest.this.getString();
            }
            this.gender = new String[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.gender[i] = ColumnMaskerTest.this.getString();
            }
            this.linkBackward = new String[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.linkBackward[i] = ColumnMaskerTest.this.getString();
            }
            this.linkForward = new String[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.linkForward[i] = ColumnMaskerTest.this.getString();
            }
        }
    }
}

