/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.recordlevel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.recordlevel.TestRecordLevelFilters;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;

public class PhoneBookWriter {
    private static final String schemaString = "message user {\n  required int64 id;\n  optional binary name (UTF8);\n  optional group location {\n    optional double lon;\n    optional double lat;\n  }\n  optional group phoneNumbers {\n    repeated group phone {\n      required int64 number;\n      optional binary kind (UTF8);\n    }\n  }\n  optional group accounts (MAP) {\n    repeated group key_value {\n      required binary key;\n      required double value;\n    }\n  }\n}\n";
    private static final MessageType schema = PhoneBookWriter.getSchema();

    public static MessageType getSchema() {
        return MessageTypeParser.parseMessageType((String)schemaString);
    }

    public static SimpleGroup groupFromUser(User user) {
        SimpleGroup root = new SimpleGroup((GroupType)schema);
        root.append("id", user.getId());
        if (user.getName() != null) {
            root.append("name", user.getName());
        }
        if (user.getPhoneNumbers() != null) {
            Group phoneNumbers = root.addGroup("phoneNumbers");
            for (PhoneNumber phoneNumber : user.getPhoneNumbers()) {
                Group phone = phoneNumbers.addGroup("phone");
                phone.append("number", phoneNumber.getNumber());
                if (phoneNumber.getKind() == null) continue;
                phone.append("kind", phoneNumber.getKind());
            }
        }
        if (user.getLocation() != null) {
            Group location = root.addGroup("location");
            if (user.getLocation().getLon() != null) {
                location.append("lon", user.getLocation().getLon().doubleValue());
            }
            if (user.getLocation().getLat() != null) {
                location.append("lat", user.getLocation().getLat().doubleValue());
            }
        }
        if (user.getAccounts() != null) {
            Group accounts = root.addGroup("accounts");
            for (Map.Entry entry : user.getAccounts().entrySet()) {
                Group kv = accounts.addGroup("key_value");
                kv.append("key", (String)entry.getKey());
                kv.append("value", ((Double)entry.getValue()).doubleValue());
            }
        }
        return root;
    }

    private static User userFromGroup(Group root) {
        return new User(PhoneBookWriter.getLong(root, "id"), PhoneBookWriter.getString(root, "name"), PhoneBookWriter.getPhoneNumbers(PhoneBookWriter.getGroup(root, "phoneNumbers")), PhoneBookWriter.getLocation(PhoneBookWriter.getGroup(root, "location")), PhoneBookWriter.getAccounts(PhoneBookWriter.getGroup(root, "accounts")));
    }

    private static List<PhoneNumber> getPhoneNumbers(Group phoneNumbers) {
        if (phoneNumbers == null) {
            return null;
        }
        ArrayList<PhoneNumber> list = new ArrayList<PhoneNumber>();
        int n = phoneNumbers.getFieldRepetitionCount("phone");
        for (int i = 0; i < n; ++i) {
            Group phone = phoneNumbers.getGroup("phone", i);
            list.add(new PhoneNumber(PhoneBookWriter.getLong(phone, "number"), PhoneBookWriter.getString(phone, "kind")));
        }
        return list;
    }

    private static Location getLocation(Group location) {
        if (location == null) {
            return null;
        }
        return new Location(PhoneBookWriter.getDouble(location, "lon"), PhoneBookWriter.getDouble(location, "lat"));
    }

    private static Map<String, Double> getAccounts(Group accounts) {
        if (accounts == null) {
            return null;
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        int n = accounts.getFieldRepetitionCount("key_value");
        for (int i = 0; i < n; ++i) {
            Group kv = accounts.getGroup("key_value", i);
            map.put(PhoneBookWriter.getString(kv, "key"), PhoneBookWriter.getDouble(kv, "value"));
        }
        return map;
    }

    private static boolean isNull(Group group, String field) {
        if (!group.getType().containsField(field)) {
            return true;
        }
        int repetition = group.getFieldRepetitionCount(field);
        if (repetition == 0) {
            return true;
        }
        if (repetition == 1) {
            return false;
        }
        throw new AssertionError((Object)("Invalid repetitionCount " + repetition + " for field " + field + " in group " + group));
    }

    private static Long getLong(Group group, String field) {
        return PhoneBookWriter.isNull(group, field) ? null : Long.valueOf(group.getLong(field, 0));
    }

    private static String getString(Group group, String field) {
        return PhoneBookWriter.isNull(group, field) ? null : group.getString(field, 0);
    }

    private static Double getDouble(Group group, String field) {
        return PhoneBookWriter.isNull(group, field) ? null : Double.valueOf(group.getDouble(field, 0));
    }

    private static Group getGroup(Group group, String field) {
        return PhoneBookWriter.isNull(group, field) ? null : group.getGroup(field, 0);
    }

    public static File writeToFile(List<User> users) throws IOException {
        File f = File.createTempFile("phonebook", ".parquet");
        f.deleteOnExit();
        if (!f.delete()) {
            throw new IOException("couldn't delete tmp file" + f);
        }
        PhoneBookWriter.writeToFile(f, users);
        return f;
    }

    public static void writeToFile(File f, List<User> users) throws IOException {
        PhoneBookWriter.write(ExampleParquetWriter.builder((Path)new Path(f.getAbsolutePath())), users);
    }

    public static void write(ParquetWriter.Builder<Group, ?> builder, List<User> users) throws IOException {
        builder.config("parquet.example.schema", schema.toString());
        try (ParquetWriter writer = builder.build();){
            for (User u : users) {
                writer.write((Object)PhoneBookWriter.groupFromUser(u));
            }
        }
    }

    public static ParquetReader<Group> createReader(Path file, FilterCompat.Filter filter, ByteBufferAllocator allocator) throws IOException {
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        return ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(conf).withFilter(filter).withAllocator(allocator).useBloomFilter(false).useDictionaryFilter(false).useStatsFilter(false).useColumnIndexFilter(false).build();
    }

    /*
     * Exception decompiling
     */
    public static List<Group> readFile(File f, FilterCompat.Filter filter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<User> readUsers(ParquetReader.Builder<Group> builder) throws IOException {
        return PhoneBookWriter.readUsers(builder, false);
    }

    public static List<User> readUsers(ParquetReader.Builder<Group> builder, boolean validateRowIndexes) throws IOException {
        try (ParquetReader reader = builder.set("parquet.example.schema", schema.toString()).build();){
            ArrayList<User> users = new ArrayList<User>();
            Group group = (Group)reader.read();
            while (group != null) {
                User u = PhoneBookWriter.userFromGroup(group);
                users.add(u);
                if (validateRowIndexes) {
                    Assert.assertEquals((String)"Row index should be equal to User id", (long)u.id, (long)reader.getCurrentRowIndex());
                }
                group = (Group)reader.read();
            }
            ArrayList<User> arrayList = users;
            return arrayList;
        }
    }

    public static void main(String[] args) throws IOException {
        File f = new File(args[0]);
        PhoneBookWriter.writeToFile(f, TestRecordLevelFilters.makeUsers());
    }

    public static class User {
        private final long id;
        private final String name;
        private final List<PhoneNumber> phoneNumbers;
        private final Location location;
        private final Map<String, Double> accounts;

        public User(long id, String name, List<PhoneNumber> phoneNumbers, Location location) {
            this(id, name, phoneNumbers, location, null);
        }

        public User(long id, String name, List<PhoneNumber> phoneNumbers, Location location, Map<String, Double> accounts) {
            this.id = id;
            this.name = name;
            this.phoneNumbers = phoneNumbers;
            this.location = location;
            this.accounts = accounts;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<PhoneNumber> getPhoneNumbers() {
            return this.phoneNumbers;
        }

        public Location getLocation() {
            return this.location;
        }

        public Map<String, Double> getAccounts() {
            return this.accounts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            if (this.id != user.id) {
                return false;
            }
            if (this.location != null ? !this.location.equals(user.location) : user.location != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(user.name) : user.name != null) {
                return false;
            }
            if (this.phoneNumbers != null ? !this.phoneNumbers.equals(user.phoneNumbers) : user.phoneNumbers != null) {
                return false;
            }
            return !(this.accounts != null ? !this.accounts.equals(user.accounts) : user.accounts != null);
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.phoneNumbers != null ? this.phoneNumbers.hashCode() : 0);
            result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
            result = 31 * result + (this.accounts != null ? this.accounts.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "User [id=" + this.id + ", name=" + this.name + ", phoneNumbers=" + this.phoneNumbers + ", location=" + this.location + ", accounts=" + this.accounts + "]";
        }

        public User cloneWithName(String name) {
            return new User(this.id, name, this.phoneNumbers, this.location, this.accounts);
        }
    }

    public static class PhoneNumber {
        private final long number;
        private final String kind;

        public PhoneNumber(long number, String kind) {
            this.number = number;
            this.kind = kind;
        }

        public long getNumber() {
            return this.number;
        }

        public String getKind() {
            return this.kind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhoneNumber that = (PhoneNumber)o;
            if (this.number != that.number) {
                return false;
            }
            return !(this.kind != null ? !this.kind.equals(that.kind) : that.kind != null);
        }

        public int hashCode() {
            int result = (int)(this.number ^ this.number >>> 32);
            result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PhoneNumber [number=" + this.number + ", kind=" + this.kind + "]";
        }
    }

    public static class Location {
        private final Double lon;
        private final Double lat;

        public Location(Double lon, Double lat) {
            this.lon = lon;
            this.lat = lat;
        }

        public Double getLon() {
            return this.lon;
        }

        public Double getLat() {
            return this.lat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.lat != null ? !this.lat.equals(location.lat) : location.lat != null) {
                return false;
            }
            return !(this.lon != null ? !this.lon.equals(location.lon) : location.lon != null);
        }

        public int hashCode() {
            int result = this.lon != null ? this.lon.hashCode() : 0;
            result = 31 * result + (this.lat != null ? this.lat.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Location [lon=" + this.lon + ", lat=" + this.lat + "]";
        }
    }
}

