/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.bytes.TrackingByteBufferAllocator;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.crypto.ColumnEncryptionProperties;
import org.apache.parquet.crypto.DecryptionKeyRetriever;
import org.apache.parquet.crypto.DecryptionKeyRetrieverMock;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.LogicalInverter;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.Statistics;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.filter2.recordlevel.PhoneBookWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestColumnIndexFiltering {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestColumnIndexFiltering.class);
    private static final Random RANDOM = new Random(42L);
    private static final String[] PHONE_KINDS = new String[]{null, "mobile", "home", "work"};
    private static final List<PhoneBookWriter.User> DATA = Collections.unmodifiableList(TestColumnIndexFiltering.generateData(10000));
    private static final Path FILE_V1 = TestColumnIndexFiltering.createTempFile(false);
    private static final Path FILE_V2 = TestColumnIndexFiltering.createTempFile(false);
    private static final Path FILE_V1_E = TestColumnIndexFiltering.createTempFile(true);
    private static final Path FILE_V2_E = TestColumnIndexFiltering.createTempFile(true);
    private static final MessageType SCHEMA_WITHOUT_NAME = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).named("id")).optionalGroup().addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("lon"))).addField((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("lat"))).named("location")).optionalGroup().repeatedGroup().addField((Type)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("number"))).addField((Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("kind"))).named("phone")).named("phoneNumbers")).named("user_without_name");
    private static final byte[] FOOTER_ENCRYPTION_KEY = "0123456789012345".getBytes();
    private static final byte[] COLUMN_ENCRYPTION_KEY1 = "1234567890123450".getBytes();
    private static final byte[] COLUMN_ENCRYPTION_KEY2 = "1234567890123451".getBytes();
    private static final String FOOTER_ENCRYPTION_KEY_ID = "kf";
    private static final String COLUMN_ENCRYPTION_KEY1_ID = "kc1";
    private static final String COLUMN_ENCRYPTION_KEY2_ID = "kc2";
    private final Path file;
    private final boolean isEncrypted;
    private TrackingByteBufferAllocator allocator;

    @Parameterized.Parameters(name="Run {index}: isEncrypted={1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({FILE_V1, false}, {FILE_V2, false}, {FILE_V1_E, true}, {FILE_V2_E, true});
    }

    @Before
    public void initAllocator() {
        this.allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    @After
    public void closeAllocator() {
        this.allocator.close();
    }

    public TestColumnIndexFiltering(Path file, boolean isEncrypted) {
        this.file = file;
        this.isEncrypted = isEncrypted;
    }

    private static List<PhoneBookWriter.User> generateData(int rowCount) {
        ArrayList<PhoneBookWriter.User> users = new ArrayList<PhoneBookWriter.User>();
        List<String> names = TestColumnIndexFiltering.generateNames(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            users.add(new PhoneBookWriter.User(i, names.get(i), TestColumnIndexFiltering.generatePhoneNumbers(), TestColumnIndexFiltering.generateLocation(i, rowCount)));
        }
        return users;
    }

    private static List<String> generateNames(int rowCount) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        list.add("anderson");
        list.add("anderson");
        list.add("miller");
        list.add("miller");
        list.add("miller");
        list.add("thomas");
        list.add("thomas");
        list.add("williams");
        int nullCount = rowCount / 100;
        String alphabet = "aabcdeefghiijklmnoopqrstuuvwxyz";
        int maxLength = 8;
        for (i = rowCount - list.size() - nullCount; i >= 0; --i) {
            int l = RANDOM.nextInt(maxLength);
            StringBuilder builder = new StringBuilder(l);
            for (int j = 0; j < l; ++j) {
                builder.append(alphabet.charAt(RANDOM.nextInt(alphabet.length())));
            }
            list.add(builder.toString());
        }
        Collections.sort(list, (str1, str2) -> -str1.compareTo((String)str2));
        for (i = 0; i < nullCount; ++i) {
            list.add(RANDOM.nextInt(list.size()), null);
        }
        return list;
    }

    private static List<PhoneBookWriter.PhoneNumber> generatePhoneNumbers() {
        int length = RANDOM.nextInt(5) - 1;
        if (length < 0) {
            return null;
        }
        ArrayList<PhoneBookWriter.PhoneNumber> phoneNumbers = new ArrayList<PhoneBookWriter.PhoneNumber>(length);
        for (int i = 0; i < length; ++i) {
            long number = Math.abs(RANDOM.nextLong() % 900000L) + 100000L;
            phoneNumbers.add(new PhoneBookWriter.PhoneNumber(number, PHONE_KINDS[RANDOM.nextInt(PHONE_KINDS.length)]));
        }
        return phoneNumbers;
    }

    private static PhoneBookWriter.Location generateLocation(int id, int rowCount) {
        if (RANDOM.nextDouble() < 0.01) {
            return null;
        }
        double lat = RANDOM.nextDouble() * 90.0 - (id < rowCount / 2 ? 90.0 : 0.0);
        double lon = RANDOM.nextDouble() * 90.0 - (id < rowCount / 4 || id >= 3 * rowCount / 4 ? 90.0 : 0.0);
        return new PhoneBookWriter.Location(RANDOM.nextDouble() < 0.01 ? null : Double.valueOf(lat), RANDOM.nextDouble() < 0.01 ? null : Double.valueOf(lon));
    }

    private static Path createTempFile(boolean encrypted) {
        String suffix = encrypted ? ".parquet.encrypted" : ".parquet";
        try {
            return new Path(Files.createTempFile("test-ci_", suffix, new FileAttribute[0]).toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }

    private List<PhoneBookWriter.User> readUsers(FilterPredicate filter, boolean useOtherFiltering) throws IOException {
        return this.readUsers(FilterCompat.get((FilterPredicate)filter), useOtherFiltering, true);
    }

    private List<PhoneBookWriter.User> readUsers(FilterPredicate filter, boolean useOtherFiltering, boolean useColumnIndexFilter) throws IOException {
        return this.readUsers(FilterCompat.get((FilterPredicate)filter), useOtherFiltering, useColumnIndexFilter);
    }

    private List<PhoneBookWriter.User> readUsers(FilterCompat.Filter filter, boolean useOtherFiltering) throws IOException {
        return this.readUsers(filter, useOtherFiltering, true);
    }

    private List<PhoneBookWriter.User> readUsers(FilterCompat.Filter filter, boolean useOtherFiltering, boolean useColumnIndexFilter) throws IOException {
        FileDecryptionProperties decryptionProperties = this.getFileDecryptionProperties();
        return PhoneBookWriter.readUsers((ParquetReader.Builder<Group>)ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)this.file).withAllocator((ByteBufferAllocator)this.allocator).withFilter(filter).withDecryption(decryptionProperties).useDictionaryFilter(useOtherFiltering).useStatsFilter(useOtherFiltering).useRecordFilter(useOtherFiltering).useColumnIndexFilter(useColumnIndexFilter), true);
    }

    private List<PhoneBookWriter.User> readUsersWithProjection(FilterCompat.Filter filter, MessageType schema, boolean useOtherFiltering, boolean useColumnIndexFilter) throws IOException {
        FileDecryptionProperties decryptionProperties = this.getFileDecryptionProperties();
        return PhoneBookWriter.readUsers((ParquetReader.Builder<Group>)ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)this.file).withFilter(filter).withDecryption(decryptionProperties).useDictionaryFilter(useOtherFiltering).useStatsFilter(useOtherFiltering).useRecordFilter(useOtherFiltering).useColumnIndexFilter(useColumnIndexFilter).set("parquet.read.schema", schema.toString()), true);
    }

    private FileDecryptionProperties getFileDecryptionProperties() {
        FileDecryptionProperties decryptionProperties = null;
        if (this.isEncrypted) {
            DecryptionKeyRetrieverMock decryptionKeyRetrieverMock = new DecryptionKeyRetrieverMock().putKey(FOOTER_ENCRYPTION_KEY_ID, FOOTER_ENCRYPTION_KEY).putKey(COLUMN_ENCRYPTION_KEY1_ID, COLUMN_ENCRYPTION_KEY1).putKey(COLUMN_ENCRYPTION_KEY2_ID, COLUMN_ENCRYPTION_KEY2);
            decryptionProperties = FileDecryptionProperties.builder().withKeyRetriever((DecryptionKeyRetriever)decryptionKeyRetrieverMock).build();
        }
        return decryptionProperties;
    }

    private static void assertContains(Stream<PhoneBookWriter.User> expected, List<PhoneBookWriter.User> actual) {
        Iterator expIt = expected.iterator();
        if (!expIt.hasNext()) {
            return;
        }
        PhoneBookWriter.User exp = (PhoneBookWriter.User)expIt.next();
        for (PhoneBookWriter.User act : actual) {
            if (!act.equals(exp)) continue;
            if (!expIt.hasNext()) break;
            exp = (PhoneBookWriter.User)expIt.next();
        }
        Assert.assertFalse((String)("Not all expected elements are in the actual list. E.g.: " + exp), (boolean)expIt.hasNext());
    }

    private void assertCorrectFiltering(Predicate<PhoneBookWriter.User> expectedFilter, FilterPredicate actualFilter) throws IOException {
        List<PhoneBookWriter.User> result = this.readUsers(actualFilter, false);
        Assert.assertTrue((String)"Column-index filtering should drop some pages", (result.size() < DATA.size() ? 1 : 0) != 0);
        LOGGER.info("{}/{} records read; filtering ratio: {}%", new Object[]{result.size(), DATA.size(), 100 * result.size() / DATA.size()});
        TestColumnIndexFiltering.assertContains(DATA.stream().filter(expectedFilter), result);
        TestColumnIndexFiltering.assertContains(result.stream(), DATA);
        result = this.readUsers(actualFilter, true);
        Assert.assertEquals(DATA.stream().filter(expectedFilter).collect(Collectors.toList()), result);
    }

    @BeforeClass
    public static void createFiles() throws IOException {
        TestColumnIndexFiltering.writePhoneBookToFile(FILE_V1, ParquetProperties.WriterVersion.PARQUET_1_0, null);
        TestColumnIndexFiltering.writePhoneBookToFile(FILE_V2, ParquetProperties.WriterVersion.PARQUET_2_0, null);
        FileEncryptionProperties encryptionProperties = TestColumnIndexFiltering.getFileEncryptionProperties();
        TestColumnIndexFiltering.writePhoneBookToFile(FILE_V1_E, ParquetProperties.WriterVersion.PARQUET_1_0, encryptionProperties);
        TestColumnIndexFiltering.writePhoneBookToFile(FILE_V2_E, ParquetProperties.WriterVersion.PARQUET_2_0, encryptionProperties);
    }

    private static void writePhoneBookToFile(Path file, ParquetProperties.WriterVersion parquetVersion, FileEncryptionProperties encryptionProperties) throws IOException {
        int pageSize = DATA.size() / 10;
        int rowGroupSize = pageSize * 6 * 5;
        try (TrackingByteBufferAllocator allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new HeapByteBufferAllocator());){
            PhoneBookWriter.write(((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withAllocator((ByteBufferAllocator)allocator)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withEncryption(encryptionProperties)).withWriterVersion(parquetVersion), DATA);
        }
    }

    private static FileEncryptionProperties getFileEncryptionProperties() {
        ColumnEncryptionProperties columnProperties1 = ColumnEncryptionProperties.builder((String)"id").withKey(COLUMN_ENCRYPTION_KEY1).withKeyID(COLUMN_ENCRYPTION_KEY1_ID).build();
        ColumnEncryptionProperties columnProperties2 = ColumnEncryptionProperties.builder((String)"name").withKey(COLUMN_ENCRYPTION_KEY2).withKeyID(COLUMN_ENCRYPTION_KEY2_ID).build();
        HashMap<ColumnPath, ColumnEncryptionProperties> columnPropertiesMap = new HashMap<ColumnPath, ColumnEncryptionProperties>();
        columnPropertiesMap.put(columnProperties1.getPath(), columnProperties1);
        columnPropertiesMap.put(columnProperties2.getPath(), columnProperties2);
        FileEncryptionProperties encryptionProperties = FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withFooterKeyID(FOOTER_ENCRYPTION_KEY_ID).withEncryptedColumns(columnPropertiesMap).build();
        return encryptionProperties;
    }

    private static void deleteFile(Path file) throws IOException {
        file.getFileSystem(new Configuration()).delete(file, false);
    }

    @AfterClass
    public static void deleteFiles() throws IOException {
        TestColumnIndexFiltering.deleteFile(FILE_V1);
        TestColumnIndexFiltering.deleteFile(FILE_V2);
        TestColumnIndexFiltering.deleteFile(FILE_V1_E);
        TestColumnIndexFiltering.deleteFile(FILE_V2_E);
    }

    @Test
    public void testSimpleFiltering() throws IOException {
        this.assertCorrectFiltering(record -> record.getId() == 1234L, (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(1234L)));
        HashSet<Long> idSet = new HashSet<Long>();
        idSet.add(1234L);
        idSet.add(5678L);
        idSet.add(1357L);
        idSet.add(111L);
        idSet.add(6666L);
        idSet.add(2L);
        idSet.add(2468L);
        this.assertCorrectFiltering(record -> record.getId() == 1234L || record.getId() == 5678L || record.getId() == 1357L || record.getId() == 111L || record.getId() == 6666L || record.getId() == 2L || record.getId() == 2468L, (FilterPredicate)FilterApi.in((Operators.Column)FilterApi.longColumn((String)"id"), idSet));
        this.assertCorrectFiltering(record -> "miller".equals(record.getName()), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), (Comparable)Binary.fromString((String)"miller")));
        HashSet<Binary> nameSet = new HashSet<Binary>();
        nameSet.add(Binary.fromString((String)"anderson"));
        nameSet.add(Binary.fromString((String)"miller"));
        nameSet.add(Binary.fromString((String)"thomas"));
        nameSet.add(Binary.fromString((String)"williams"));
        this.assertCorrectFiltering(record -> "anderson".equals(record.getName()) || "miller".equals(record.getName()) || "thomas".equals(record.getName()) || "williams".equals(record.getName()), (FilterPredicate)FilterApi.in((Operators.Column)FilterApi.binaryColumn((String)"name"), nameSet));
        this.assertCorrectFiltering(record -> record.getName() == null, (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), null));
        HashSet<Object> nullSet = new HashSet<Object>();
        nullSet.add(null);
        this.assertCorrectFiltering(record -> record.getName() == null, (FilterPredicate)FilterApi.in((Operators.Column)FilterApi.binaryColumn((String)"name"), nullSet));
    }

    @Test
    public void testNoFiltering() throws IOException {
        Assert.assertEquals(DATA, this.readUsers(FilterCompat.NOOP, false));
        Assert.assertEquals(DATA, this.readUsers(FilterCompat.NOOP, true));
        Assert.assertEquals(DATA, this.readUsers((FilterCompat.Filter)null, false));
        Assert.assertEquals(DATA, this.readUsers((FilterCompat.Filter)null, true));
        Assert.assertEquals(DATA.stream().filter(user -> user.getId() == 1234L).collect(Collectors.toList()), this.readUsers((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(1234L)), true, false));
        Assert.assertEquals(DATA.stream().filter(user -> "miller".equals(user.getName())).collect(Collectors.toList()), this.readUsers((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), (Comparable)Binary.fromString((String)"miller")), true, false));
        Assert.assertEquals(DATA.stream().filter(user -> user.getName() == null).collect(Collectors.toList()), this.readUsers((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), null), true, false));
        Assert.assertEquals(DATA, this.readUsers((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(1234L)), false, false));
        Assert.assertEquals(DATA, this.readUsers((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), (Comparable)Binary.fromString((String)"miller")), false, false));
        Assert.assertEquals(DATA, this.readUsers((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), null), false, false));
    }

    @Test
    public void testComplexFiltering() throws IOException {
        this.assertCorrectFiltering(record -> {
            PhoneBookWriter.Location loc = record.getLocation();
            Double lat = loc == null ? null : loc.getLat();
            Double lon = loc == null ? null : loc.getLon();
            return lat != null && lon != null && 37.0 <= lat && lat <= 70.0 && -21.0 <= lon && lon <= 35.0;
        }, FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.doubleColumn((String)"location.lat"), (Comparable)Double.valueOf(37.0)), (FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.doubleColumn((String)"location.lat"), (Comparable)Double.valueOf(70.0))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.doubleColumn((String)"location.lon"), (Comparable)Double.valueOf(-21.0)), (FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.doubleColumn((String)"location.lon"), (Comparable)Double.valueOf(35.0)))));
        this.assertCorrectFiltering(record -> {
            PhoneBookWriter.Location loc = record.getLocation();
            return loc == null || loc.getLat() == null && loc.getLon() == null;
        }, FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)"location.lat"), null), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)"location.lon"), null)));
        this.assertCorrectFiltering(record -> {
            String name = record.getName();
            return name != null && name.compareTo("thomas") < 0 && record.getId() <= (long)(3 * DATA.size() / 4);
        }, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.binaryColumn((String)"name"), (Comparable)Binary.fromString((String)"thomas")), (FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(3L * (long)DATA.size() / 4L))));
    }

    @Test
    public void testUDF() throws IOException {
        this.assertCorrectFiltering(record -> NameStartsWithVowel.isStartingWithVowel(record.getName()) || record.getId() % 234L == 0L, FilterApi.or((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.binaryColumn((String)"name"), NameStartsWithVowel.class), (FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.longColumn((String)"id"), (UserDefinedPredicate)new IsDivisibleBy(234L))));
        this.assertCorrectFiltering(record -> !NameStartsWithVowel.isStartingWithVowel(record.getName()) && record.getId() % 234L != 0L, FilterApi.not((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.binaryColumn((String)"name"), NameStartsWithVowel.class), (FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.longColumn((String)"id"), (UserDefinedPredicate)new IsDivisibleBy(234L)))));
    }

    @Test
    public void testFilteringWithMissingColumns() throws IOException {
        Assert.assertEquals(DATA, this.readUsers((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"not-existing-binary"), (Comparable)Binary.EMPTY), true));
        this.assertCorrectFiltering(record -> record.getId() == 1234L, FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(1234L)), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"not-existing-long"), null)));
        this.assertCorrectFiltering(record -> "miller".equals(record.getName()), FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), (Comparable)Binary.fromString((String)"miller")), (FilterPredicate)LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.binaryColumn((String)"not-existing-binary"), NameStartsWithVowel.class))));
        Assert.assertEquals(Collections.emptyList(), this.readUsers((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"not-existing-long"), (Comparable)Long.valueOf(0L)), true));
        this.assertCorrectFiltering(record -> "miller".equals(record.getName()), FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), (Comparable)Binary.fromString((String)"miller")), (FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.binaryColumn((String)"not-existing-binary"), (Comparable)Binary.EMPTY)));
        this.assertCorrectFiltering(record -> record.getId() == 1234L, FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(1234L)), (FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.longColumn((String)"not-existing-long"), (UserDefinedPredicate)new IsDivisibleBy(1L))));
    }

    @Test
    public void testFilteringWithProjection() throws IOException {
        Assert.assertEquals(DATA.stream().map(user -> user.cloneWithName(null)).collect(Collectors.toList()), this.readUsersWithProjection(FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), null)), SCHEMA_WITHOUT_NAME, true, true));
        Assert.assertEquals(Collections.emptyList(), this.readUsersWithProjection(FilterCompat.get((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"name"), null)), SCHEMA_WITHOUT_NAME, false, true));
        Assert.assertEquals(Collections.emptyList(), this.readUsersWithProjection(FilterCompat.get((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.binaryColumn((String)"name"), NameStartsWithVowel.class)), SCHEMA_WITHOUT_NAME, false, true));
    }

    public static class IsDivisibleBy
    extends UserDefinedPredicate<Long>
    implements Serializable {
        private long divisor;

        IsDivisibleBy(long divisor) {
            this.divisor = divisor;
        }

        public boolean keep(Long value) {
            return value % this.divisor == 0L;
        }

        public boolean canDrop(Statistics<Long> statistics) {
            long min = (Long)statistics.getMin();
            long max = (Long)statistics.getMax();
            return min % this.divisor != 0L && max % this.divisor != 0L && min / this.divisor == max / this.divisor;
        }

        public boolean inverseCanDrop(Statistics<Long> statistics) {
            long max;
            long min = (Long)statistics.getMin();
            return min == (max = ((Long)statistics.getMax()).longValue()) && min % this.divisor == 0L;
        }
    }

    public static class NameStartsWithVowel
    extends UserDefinedPredicate<Binary> {
        private static final Binary A = Binary.fromString((String)"a");
        private static final Binary B = Binary.fromString((String)"b");
        private static final Binary E = Binary.fromString((String)"e");
        private static final Binary F = Binary.fromString((String)"f");
        private static final Binary I = Binary.fromString((String)"i");
        private static final Binary J = Binary.fromString((String)"j");
        private static final Binary O = Binary.fromString((String)"o");
        private static final Binary P = Binary.fromString((String)"p");
        private static final Binary U = Binary.fromString((String)"u");
        private static final Binary V = Binary.fromString((String)"v");

        private static boolean isStartingWithVowel(String str) {
            if (str == null || str.isEmpty()) {
                return false;
            }
            switch (str.charAt(0)) {
                case 'a': 
                case 'e': 
                case 'i': 
                case 'o': 
                case 'u': {
                    return true;
                }
            }
            return false;
        }

        public boolean keep(Binary value) {
            return value != null && NameStartsWithVowel.isStartingWithVowel(value.toStringUsingUTF8());
        }

        public boolean canDrop(Statistics<Binary> statistics) {
            Comparator cmp = statistics.getComparator();
            Binary min = (Binary)statistics.getMin();
            Binary max = (Binary)statistics.getMax();
            return cmp.compare(max, A) < 0 || cmp.compare(min, B) >= 0 && cmp.compare(max, E) < 0 || cmp.compare(min, F) >= 0 && cmp.compare(max, I) < 0 || cmp.compare(min, J) >= 0 && cmp.compare(max, O) < 0 || cmp.compare(min, P) >= 0 && cmp.compare(max, U) < 0 || cmp.compare(min, V) >= 0;
        }

        public boolean inverseCanDrop(Statistics<Binary> statistics) {
            Comparator cmp = statistics.getComparator();
            Binary min = (Binary)statistics.getMin();
            Binary max = (Binary)statistics.getMax();
            return cmp.compare(min, A) >= 0 && cmp.compare(max, B) < 0 || cmp.compare(min, E) >= 0 && cmp.compare(max, F) < 0 || cmp.compare(min, I) >= 0 && cmp.compare(max, J) < 0 || cmp.compare(min, O) >= 0 && cmp.compare(max, P) < 0 || cmp.compare(min, U) >= 0 && cmp.compare(max, V) < 0;
        }
    }
}

