/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.parquet.statistics.RandomValues;

public class SingleRow {
    private static final int RANDOM_SEED = 42;
    private static final int FIXED_LENGTH = 10;
    private static final Random RANDOM = new Random(42L);
    private static final RandomValues.IntGenerator intGenerator = new RandomValues.IntGenerator(42L);
    private static final RandomValues.FloatGenerator floatGenerator = new RandomValues.FloatGenerator(42L);
    private static final RandomValues.DoubleGenerator doubleGenerator = new RandomValues.DoubleGenerator(42L);
    private static final RandomValues.BinaryGenerator binaryGenerator = new RandomValues.BinaryGenerator(42L);
    private static final RandomValues.FixedGenerator fixedBinaryGenerator = new RandomValues.FixedGenerator(42L, 10);
    public static final String BOOLEAN_FIELD_NAME = "boolean_field";
    public static final String INT32_FIELD_NAME = "int32_field";
    public static final String FLOAT_FIELD_NAME = "float_field";
    public static final String DOUBLE_FIELD_NAME = "double_field";
    public static final String BINARY_FIELD_NAME = "ba_field";
    public static final String FIXED_LENGTH_BINARY_FIELD_NAME = "flba_field";
    public static final String PLAINTEXT_INT32_FIELD_NAME = "plain_int32_field";
    private static final MessageType SCHEMA = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BOOLEAN, "boolean_field"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "int32_field"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FLOAT, "float_field"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.DOUBLE, "double_field"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "ba_field"), (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(10)).named("flba_field"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "plain_int32_field")});
    public final boolean boolean_field;
    public final int int32_field;
    public final float float_field;
    public final double double_field;
    public final byte[] ba_field;
    public final byte[] flba_field;
    public final Integer plaintext_int32_field;

    public SingleRow(boolean boolean_field, int int32_field, float float_field, double double_field, byte[] ba_field, byte[] flba_field, Integer plaintext_int32_field) {
        this.boolean_field = boolean_field;
        this.int32_field = int32_field;
        this.float_field = float_field;
        this.double_field = double_field;
        this.ba_field = ba_field;
        this.flba_field = flba_field;
        this.plaintext_int32_field = plaintext_int32_field;
    }

    public static MessageType getSchema() {
        return SCHEMA;
    }

    public static List<SingleRow> generateRandomData(int rowCount) {
        ArrayList<SingleRow> dataList = new ArrayList<SingleRow>(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            SingleRow newRow = new SingleRow(RANDOM.nextBoolean(), intGenerator.nextValue(), floatGenerator.nextValue().floatValue(), doubleGenerator.nextValue(), binaryGenerator.nextValue().getBytes(), fixedBinaryGenerator.nextValue().getBytes(), intGenerator.nextValue());
            dataList.add(newRow);
        }
        return dataList;
    }

    public static List<SingleRow> generateLinearData(int rowCount) {
        ArrayList<SingleRow> dataList = new ArrayList<SingleRow>(rowCount);
        String baseStr = "parquet";
        for (int row = 0; row < rowCount; ++row) {
            boolean boolean_val = row % 2 == 0;
            float float_val = (float)row * 1.1f;
            double double_val = (double)row * 1.1111111;
            byte[] binary_val = null;
            if (row % 2 == 0) {
                char firstChar = (char)(48 + row / 100);
                char secondChar = (char)(48 + row / 10 % 10);
                char thirdChar = (char)(48 + row % 10);
                binary_val = (baseStr + firstChar + secondChar + thirdChar).getBytes(StandardCharsets.UTF_8);
            }
            char[] fixed = new char[10];
            char[] aChar = Character.toChars(row);
            Arrays.fill(fixed, aChar[0]);
            SingleRow newRow = new SingleRow(boolean_val, row, float_val, double_val, binary_val, new String(fixed).getBytes(StandardCharsets.UTF_8), null);
            dataList.add(newRow);
        }
        return dataList;
    }
}

