/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.bytes.TrackingByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.Page;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.codec.SnappyCompressor;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDataPageChecksums {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private TrackingByteBufferAllocator allocator;
    private static final Statistics<?> EMPTY_STATS_INT32 = Statistics.getBuilderForReading((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("a"))).build();
    private CRC32 crc = new CRC32();
    private static final int PAGE_SIZE = 0x100000;
    private static final MessageType schemaSimple = MessageTypeParser.parseMessageType((String)"message m {  required int32 a;  required int32 b;}");
    private static final ColumnDescriptor colADesc = (ColumnDescriptor)schemaSimple.getColumns().get(0);
    private static final ColumnDescriptor colBDesc = (ColumnDescriptor)schemaSimple.getColumns().get(1);
    private static final byte[] colAPage1Bytes = new byte[0x100000];
    private static final byte[] colAPage2Bytes = new byte[0x100000];
    private static final byte[] colBPage1Bytes = new byte[0x100000];
    private static final byte[] colBPage2Bytes = new byte[0x100000];
    private static final int numRecordsLargeFile = 524288;
    private static final MessageType schemaNestedWithNulls = MessageTypeParser.parseMessageType((String)"message m {  optional group c {    required int64 id;    required group d {      repeated int32 val;    }  }}");
    private static final ColumnDescriptor colCIdDesc = (ColumnDescriptor)schemaNestedWithNulls.getColumns().get(0);
    private static final ColumnDescriptor colDValDesc = (ColumnDescriptor)schemaNestedWithNulls.getColumns().get(1);
    private static final double nullRatio = 0.3;
    private static final int numRecordsNestedWithNullsFile = 2000;

    @Before
    public void initAllocator() {
        this.allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    @After
    public void closeAllocator() {
        this.allocator.close();
    }

    private Path writeSimpleParquetFile(Configuration conf, CompressionCodecName compression, ParquetProperties.WriterVersion version) throws IOException {
        File file = this.tempFolder.newFile();
        file.delete();
        Path path = new Path(file.toURI());
        for (int i = 0; i < 0x100000; ++i) {
            TestDataPageChecksums.colAPage1Bytes[i] = (byte)i;
            TestDataPageChecksums.colAPage2Bytes[i] = (byte)(-i);
            TestDataPageChecksums.colBPage1Bytes[i] = (byte)(i + 100);
            TestDataPageChecksums.colBPage2Bytes[i] = (byte)(i - 100);
        }
        ParquetFileWriter writer = new ParquetFileWriter(conf, schemaSimple, path, 0x8000000L, 0x800000, Integer.MAX_VALUE, (ByteBufferAllocator)this.allocator);
        writer.start();
        writer.startBlock(524288L);
        CodecFactory codecFactory = new CodecFactory(conf, 0x100000);
        CodecFactory.BytesCompressor compressor = codecFactory.getCompressor(compression);
        ColumnChunkPageWriteStore writeStore = new ColumnChunkPageWriteStore((CompressionCodecFactory.BytesInputCompressor)compressor, schemaSimple, (ByteBufferAllocator)new HeapByteBufferAllocator(), Integer.MAX_VALUE, ParquetOutputFormat.getPageWriteChecksumEnabled((Configuration)conf));
        if (version == ParquetProperties.WriterVersion.PARQUET_1_0) {
            PageWriter pageWriter = writeStore.getPageWriter(colADesc);
            pageWriter.writePage(BytesInput.from((byte[])colAPage1Bytes), 262144, 262144, EMPTY_STATS_INT32, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
            pageWriter.writePage(BytesInput.from((byte[])colAPage2Bytes), 262144, 262144, EMPTY_STATS_INT32, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
            pageWriter = writeStore.getPageWriter(colBDesc);
            pageWriter.writePage(BytesInput.from((byte[])colBPage1Bytes), 262144, 262144, EMPTY_STATS_INT32, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
            pageWriter.writePage(BytesInput.from((byte[])colBPage2Bytes), 262144, 262144, EMPTY_STATS_INT32, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
        } else if (version == ParquetProperties.WriterVersion.PARQUET_2_0) {
            PageWriter pageWriter = writeStore.getPageWriter(colADesc);
            pageWriter.writePageV2(262144, 0, 262144, BytesInput.from((byte[])colAPage1Bytes, (int)0, (int)262144), BytesInput.from((byte[])colAPage1Bytes, (int)262144, (int)262144), Encoding.PLAIN, BytesInput.from((byte[])colAPage1Bytes, (int)524288, (int)524288), EMPTY_STATS_INT32);
            pageWriter.writePageV2(262144, 0, 262144, BytesInput.from((byte[])colAPage2Bytes, (int)0, (int)262144), BytesInput.from((byte[])colAPage2Bytes, (int)262144, (int)262144), Encoding.PLAIN, BytesInput.from((byte[])colAPage2Bytes, (int)524288, (int)524288), EMPTY_STATS_INT32);
            pageWriter = writeStore.getPageWriter(colBDesc);
            pageWriter.writePageV2(262144, 0, 262144, BytesInput.from((byte[])colBPage1Bytes, (int)0, (int)262144), BytesInput.from((byte[])colBPage1Bytes, (int)262144, (int)262144), Encoding.PLAIN, BytesInput.from((byte[])colBPage1Bytes, (int)524288, (int)524288), EMPTY_STATS_INT32);
            pageWriter.writePageV2(262144, 0, 262144, BytesInput.from((byte[])colBPage2Bytes, (int)0, (int)262144), BytesInput.from((byte[])colBPage2Bytes, (int)262144, (int)262144), Encoding.PLAIN, BytesInput.from((byte[])colBPage2Bytes, (int)524288, (int)524288), EMPTY_STATS_INT32);
        } else {
            throw new IllegalArgumentException("Unknown writer version: " + version);
        }
        writeStore.flushToFileWriter(writer);
        writer.endBlock();
        writer.end(new HashMap());
        codecFactory.release();
        return path;
    }

    private Path writeNestedWithNullsSampleParquetFile(Configuration conf, boolean dictionaryEncoding, CompressionCodecName compression, ParquetProperties.WriterVersion version) throws IOException {
        File file = this.tempFolder.newFile();
        file.delete();
        Path path = new Path(file.toURI());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withConf(conf)).withAllocator((ByteBufferAllocator)this.allocator)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withCompressionCodec(compression)).withDictionaryEncoding(dictionaryEncoding)).withType(schemaNestedWithNulls).withPageWriteChecksumEnabled(ParquetOutputFormat.getPageWriteChecksumEnabled((Configuration)conf))).withWriterVersion(version)).build();){
            SimpleGroupFactory groupFactory = new SimpleGroupFactory(schemaNestedWithNulls);
            Random rand = new Random(42L);
            for (int i = 0; i < 2000; ++i) {
                Group group = groupFactory.newGroup();
                if (rand.nextDouble() > 0.3) {
                    if (rand.nextDouble() > 0.5) {
                        group.addGroup("c").append("id", (long)i).addGroup("d").append("val", rand.nextInt() % 10);
                    } else {
                        group.addGroup("c").append("id", (long)i).addGroup("d").append("val", rand.nextInt() % 10).append("val", rand.nextInt() % 10).append("val", rand.nextInt() % 10);
                    }
                }
                writer.write((Object)group);
            }
        }
        return path;
    }

    private void testWriteOnVerifyOff(ParquetProperties.WriterVersion version) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", true);
        conf.setBoolean("parquet.page.verify-checksum.enabled", false);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED, version);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            DataPage colAPage1 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage1, colAPage1Bytes);
            this.assertCorrectContent(this.getPageBytes(colAPage1), colAPage1Bytes);
            DataPage colAPage2 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage2, colAPage2Bytes);
            this.assertCorrectContent(this.getPageBytes(colAPage2), colAPage2Bytes);
            DataPage colBPage1 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage1, colBPage1Bytes);
            this.assertCorrectContent(this.getPageBytes(colBPage1), colBPage1Bytes);
            DataPage colBPage2 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage2, colBPage2Bytes);
            this.assertCorrectContent(this.getPageBytes(colBPage2), colBPage2Bytes);
        }
    }

    @Test
    public void testWriteOnVerifyOffV1() throws IOException {
        this.testWriteOnVerifyOff(ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testWriteOnVerifyOffV2() throws IOException {
        this.testWriteOnVerifyOff(ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    private void testWriteOffVerifyOff(ParquetProperties.WriterVersion version) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", false);
        conf.setBoolean("parquet.page.verify-checksum.enabled", false);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED, version);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            this.assertCrcNotSet((Page)this.readNextPage(colADesc, pageReadStore));
            this.assertCrcNotSet((Page)this.readNextPage(colADesc, pageReadStore));
            this.assertCrcNotSet((Page)this.readNextPage(colBDesc, pageReadStore));
            this.assertCrcNotSet((Page)this.readNextPage(colBDesc, pageReadStore));
        }
    }

    @Test
    public void testWriteOffVerifyOffV1() throws IOException {
        this.testWriteOffVerifyOff(ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testWriteOffVerifyOffV2() throws IOException {
        this.testWriteOffVerifyOff(ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    private void testWriteOffVerifyOn(ParquetProperties.WriterVersion version) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", false);
        conf.setBoolean("parquet.page.verify-checksum.enabled", true);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED, version);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            this.assertCorrectContent(this.getPageBytes(this.readNextPage(colADesc, pageReadStore)), colAPage1Bytes);
            this.assertCorrectContent(this.getPageBytes(this.readNextPage(colADesc, pageReadStore)), colAPage2Bytes);
            this.assertCorrectContent(this.getPageBytes(this.readNextPage(colBDesc, pageReadStore)), colBPage1Bytes);
            this.assertCorrectContent(this.getPageBytes(this.readNextPage(colBDesc, pageReadStore)), colBPage2Bytes);
        }
    }

    @Test
    public void testWriteOffVerifyOnV1() throws IOException {
        this.testWriteOffVerifyOn(ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testWriteOffVerifyOnV2() throws IOException {
        this.testWriteOffVerifyOn(ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    private void testWriteOnVerifyOn(ParquetProperties.WriterVersion version) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", true);
        conf.setBoolean("parquet.page.verify-checksum.enabled", true);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED, version);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            DataPage colAPage1 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage1, colAPage1Bytes);
            this.assertCorrectContent(this.getPageBytes(colAPage1), colAPage1Bytes);
            DataPage colAPage2 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage2, colAPage2Bytes);
            this.assertCorrectContent(this.getPageBytes(colAPage2), colAPage2Bytes);
            DataPage colBPage1 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage1, colBPage1Bytes);
            this.assertCorrectContent(this.getPageBytes(colBPage1), colBPage1Bytes);
            DataPage colBPage2 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage2, colBPage2Bytes);
            this.assertCorrectContent(this.getPageBytes(colBPage2), colBPage2Bytes);
        }
    }

    @Test
    public void testWriteOnVerifyOnV1() throws IOException {
        this.testWriteOnVerifyOn(ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testWriteOnVerifyOnV2() throws IOException {
        this.testWriteOnVerifyOn(ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    private void testCorruptedPage(ParquetProperties.WriterVersion version) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", true);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED, version);
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)conf);
        try (SeekableInputStream inputStream = inputFile.newStream();){
            int fileLen = (int)inputFile.getLength();
            byte[] fileBytes = new byte[fileLen];
            inputStream.readFully(fileBytes);
            inputStream.close();
            int n = fileLen / 8;
            fileBytes[n] = (byte)(fileBytes[n] + 1);
            int n2 = fileLen / 8 + fileLen / 4 * 3;
            fileBytes[n2] = (byte)(fileBytes[n2] + 1);
            HadoopOutputFile outputFile = HadoopOutputFile.fromPath((Path)path, (Configuration)conf);
            try (PositionOutputStream outputStream = outputFile.createOrOverwrite(0x100000L);){
                outputStream.write(fileBytes);
                outputStream.close();
                conf.setBoolean("parquet.page.verify-checksum.enabled", false);
                try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
                    PageReadStore pageReadStore = reader.readNextRowGroup();
                    DataPage colAPage1 = this.readNextPage(colADesc, pageReadStore);
                    Assert.assertFalse((String)"Data in page was not corrupted", (boolean)Arrays.equals(this.getPageBytes(colAPage1), colAPage1Bytes));
                    this.readNextPage(colADesc, pageReadStore);
                    this.readNextPage(colBDesc, pageReadStore);
                    DataPage colBPage2 = this.readNextPage(colBDesc, pageReadStore);
                    Assert.assertFalse((String)"Data in page was not corrupted", (boolean)Arrays.equals(this.getPageBytes(colBPage2), colBPage2Bytes));
                }
                conf.setBoolean("parquet.page.verify-checksum.enabled", true);
                reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));
                var13_17 = null;
                try {
                    this.assertVerificationFailed(reader);
                }
                catch (Throwable throwable) {
                    var13_17 = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (var13_17 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {
                                var13_17.addSuppressed(throwable);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testCorruptedPageV1() throws IOException {
        this.testCorruptedPage(ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testCorruptedPageV2() throws IOException {
        this.testCorruptedPage(ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    private void testCompression(ParquetProperties.WriterVersion version) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", true);
        conf.setBoolean("parquet.page.verify-checksum.enabled", true);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.SNAPPY, version);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            DataPage colAPage1 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage1, this.snappy(colAPage1Bytes, this.getDataOffset((Page)colAPage1)));
            this.assertCorrectContent(this.getPageBytes(colAPage1), colAPage1Bytes);
            DataPage colAPage2 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage2, this.snappy(colAPage2Bytes, this.getDataOffset((Page)colAPage2)));
            this.assertCorrectContent(this.getPageBytes(colAPage2), colAPage2Bytes);
            DataPage colBPage1 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage1, this.snappy(colBPage1Bytes, this.getDataOffset((Page)colBPage1)));
            this.assertCorrectContent(this.getPageBytes(colBPage1), colBPage1Bytes);
            DataPage colBPage2 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage2, this.snappy(colBPage2Bytes, this.getDataOffset((Page)colBPage2)));
            this.assertCorrectContent(this.getPageBytes(colBPage2), colBPage2Bytes);
        }
    }

    @Test
    public void testCompressionV1() throws IOException {
        this.testCompression(ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testCompressionV2() throws IOException {
        this.testCompression(ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    private void testNestedWithNulls(ParquetProperties.WriterVersion version) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", false);
        conf.setBoolean("parquet.page.verify-checksum.enabled", false);
        Path refPath = this.writeNestedWithNullsSampleParquetFile(conf, false, CompressionCodecName.SNAPPY, version);
        try (ParquetFileReader refReader = this.getParquetFileReader(refPath, conf, Arrays.asList(colCIdDesc, colDValDesc));){
            PageReadStore refPageReadStore = refReader.readNextRowGroup();
            byte[] colCIdPageBytes = this.getPageBytes(this.readNextPage(colCIdDesc, refPageReadStore));
            byte[] colDValPageBytes = this.getPageBytes(this.readNextPage(colDValDesc, refPageReadStore));
            conf.setBoolean("parquet.page.write-checksum.enabled", true);
            conf.setBoolean("parquet.page.verify-checksum.enabled", true);
            Path path = this.writeNestedWithNullsSampleParquetFile(conf, false, CompressionCodecName.SNAPPY, version);
            try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colCIdDesc, colDValDesc));){
                PageReadStore pageReadStore = reader.readNextRowGroup();
                DataPage colCIdPage = this.readNextPage(colCIdDesc, pageReadStore);
                this.assertCrcSetAndCorrect((Page)colCIdPage, this.snappy(colCIdPageBytes, this.getDataOffset((Page)colCIdPage)));
                this.assertCorrectContent(this.getPageBytes(colCIdPage), colCIdPageBytes);
                DataPage colDValPage = this.readNextPage(colDValDesc, pageReadStore);
                this.assertCrcSetAndCorrect((Page)colDValPage, this.snappy(colDValPageBytes, this.getDataOffset((Page)colDValPage)));
                this.assertCorrectContent(this.getPageBytes(colDValPage), colDValPageBytes);
            }
        }
    }

    @Test
    public void testNestedWithNullsV1() throws IOException {
        this.testNestedWithNulls(ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testNestedWithNullsV2() throws IOException {
        this.testNestedWithNulls(ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    private void testDictionaryEncoding(ParquetProperties.WriterVersion version) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", false);
        conf.setBoolean("parquet.page.verify-checksum.enabled", false);
        Path refPath = this.writeNestedWithNullsSampleParquetFile(conf, true, CompressionCodecName.SNAPPY, version);
        try (ParquetFileReader refReader = this.getParquetFileReader(refPath, conf, Collections.singletonList(colDValDesc));){
            PageReadStore refPageReadStore = refReader.readNextRowGroup();
            byte[] dictPageBytes = this.readDictPage(colDValDesc, refPageReadStore).getBytes().toByteArray();
            byte[] colDValPageBytes = this.getPageBytes(this.readNextPage(colDValDesc, refPageReadStore));
            conf.setBoolean("parquet.page.write-checksum.enabled", true);
            conf.setBoolean("parquet.page.verify-checksum.enabled", true);
            Path path = this.writeNestedWithNullsSampleParquetFile(conf, true, CompressionCodecName.SNAPPY, version);
            try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Collections.singletonList(colDValDesc));){
                PageReadStore pageReadStore = reader.readNextRowGroup();
                DictionaryPage dictPage = this.readDictPage(colDValDesc, pageReadStore);
                this.assertCrcSetAndCorrect((Page)dictPage, this.snappy(dictPageBytes));
                this.assertCorrectContent(dictPage.getBytes().toByteArray(), dictPageBytes);
                DataPage colDValPage = this.readNextPage(colDValDesc, pageReadStore);
                this.assertCrcSetAndCorrect((Page)colDValPage, this.snappy(colDValPageBytes, this.getDataOffset((Page)colDValPage)));
                this.assertCorrectContent(this.getPageBytes(colDValPage), colDValPageBytes);
            }
        }
    }

    @Test
    public void testDictionaryEncodingV1() throws IOException {
        this.testDictionaryEncoding(ParquetProperties.WriterVersion.PARQUET_1_0);
    }

    @Test
    public void testDictionaryEncodingV2() throws IOException {
        this.testDictionaryEncoding(ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    private byte[] snappy(byte[] bytes, int offset) throws IOException {
        int length = bytes.length - offset;
        SnappyCompressor compressor = new SnappyCompressor();
        compressor.reset();
        compressor.setInput(bytes, offset, length);
        compressor.finish();
        byte[] buffer = new byte[length * 2];
        int compressedSize = compressor.compress(buffer, 0, buffer.length);
        return BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.from((byte[])Arrays.copyOfRange(bytes, 0, offset)), BytesInput.from((byte[])Arrays.copyOfRange(buffer, 0, compressedSize))}).toByteArray();
    }

    private byte[] snappy(byte[] bytes) throws IOException {
        return this.snappy(bytes, 0);
    }

    private int getDataOffset(Page page) {
        if (page instanceof DataPageV2) {
            return (int)(((DataPageV2)page).getRepetitionLevels().size() + ((DataPageV2)page).getDefinitionLevels().size());
        }
        return 0;
    }

    private ParquetFileReader getParquetFileReader(Path path, Configuration conf, List<ColumnDescriptor> columns) throws IOException {
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)conf);
        SeekableInputStream inputStream = inputFile.newStream();
        ParquetReadOptions readOptions = HadoopReadOptions.builder((Configuration)conf).build();
        ParquetMetadata footer = ParquetFileReader.readFooter((InputFile)inputFile, (ParquetReadOptions)readOptions, (SeekableInputStream)inputStream);
        ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile, (ParquetMetadata)footer, (ParquetReadOptions)readOptions, (SeekableInputStream)inputStream);
        reader.setRequestedSchema(columns);
        return reader;
    }

    private DictionaryPage readDictPage(ColumnDescriptor colDesc, PageReadStore pageReadStore) {
        return pageReadStore.getPageReader(colDesc).readDictionaryPage();
    }

    private DataPage readNextPage(ColumnDescriptor colDesc, PageReadStore pageReadStore) {
        return pageReadStore.getPageReader(colDesc).readPage();
    }

    private void assertCorrectContent(byte[] pageBytes, byte[] referenceBytes) {
        Assert.assertArrayEquals((String)"Read page content was different from expected page content", (byte[])referenceBytes, (byte[])pageBytes);
    }

    private byte[] getPageBytes(DataPage page) throws IOException {
        if (page instanceof DataPageV1) {
            DataPageV1 pageV1 = (DataPageV1)page;
            return pageV1.getBytes().toByteArray();
        }
        if (page instanceof DataPageV2) {
            DataPageV2 pageV2 = (DataPageV2)page;
            return BytesInput.concat((BytesInput[])new BytesInput[]{pageV2.getRepetitionLevels(), pageV2.getDefinitionLevels(), pageV2.getData()}).toByteArray();
        }
        throw new IllegalArgumentException("Unknown page type " + page.getClass().getName());
    }

    private void assertCrcSetAndCorrect(Page page, byte[] referenceBytes) {
        Assert.assertTrue((String)"Checksum was not set in page", (boolean)page.getCrc().isPresent());
        int crcFromPage = page.getCrc().getAsInt();
        this.crc.reset();
        this.crc.update(referenceBytes);
        Assert.assertEquals((String)"Checksum found in page did not match calculated reference checksum", (long)this.crc.getValue(), (long)((long)crcFromPage & 0xFFFFFFFFL));
    }

    private void assertCrcNotSet(Page page) {
        Assert.assertFalse((String)"Checksum was set in page", (boolean)page.getCrc().isPresent());
    }

    private void assertVerificationFailed(ParquetFileReader reader) {
        try {
            reader.readNextRowGroup();
            Assert.fail((String)"Expected checksum verification exception to be thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Thrown exception is of incorrect type", (boolean)(e instanceof ParquetDecodingException));
            Assert.assertTrue((String)"Did not catch checksum verification ParquetDecodingException", (boolean)e.getMessage().contains("CRC checksum verification failed"));
        }
    }
}

