/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.IndexCache;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.rewrite.MaskMode;
import org.apache.parquet.hadoop.rewrite.ParquetRewriter;
import org.apache.parquet.hadoop.rewrite.RewriteOptions;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.EncDecProperties;
import org.apache.parquet.hadoop.util.EncryptionTestFile;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.hadoop.util.TestFileBuilder;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParquetRewriterTest {
    private final int numRecord;
    private final Configuration conf;
    private final ParquetConfiguration parquetConf = new PlainParquetConfiguration();
    private final ParquetProperties.WriterVersion writerVersion;
    private final IndexCache.CacheStrategy indexCacheStrategy;
    private final boolean usingHadoop;
    private List<EncryptionTestFile> inputFiles = Lists.newArrayList();
    private List<EncryptionTestFile> inputFilesToJoin = Lists.newArrayList();
    private String outputFile = null;
    private ParquetRewriter rewriter = null;
    private final EncryptionTestFile gzipEncryptionTestFileWithoutBloomFilterColumn;
    private final EncryptionTestFile uncompressedEncryptionTestFileWithoutBloomFilterColumn;

    @Parameterized.Parameters(name="WriterVersion = {0}, IndexCacheStrategy = {1}, UsingHadoop = {2}, numRecord = {3}, rowsPerPage = {4}")
    public static Object[][] parameters() {
        int DefaultNumRecord = 10000;
        int DefaultRowsPerPage = 2000;
        return new Object[][]{{"v1", "NONE", true, 10000, 2000}, {"v1", "PREFETCH_BLOCK", true, 10000, 2000}, {"v2", "PREFETCH_BLOCK", true, 10000, 2000}, {"v2", "PREFETCH_BLOCK", false, 10000, 2000}};
    }

    public ParquetRewriterTest(String writerVersion, String indexCacheStrategy, boolean _usingHadoop, int _numRecord, int rowsPerPage) throws IOException {
        this.writerVersion = ParquetProperties.WriterVersion.fromString((String)writerVersion);
        this.indexCacheStrategy = IndexCache.CacheStrategy.valueOf((String)indexCacheStrategy);
        this.usingHadoop = _usingHadoop;
        this.numRecord = _numRecord;
        Configuration _conf = new Configuration();
        _conf.set("parquet.page.row.count.limit", Integer.toString(rowsPerPage));
        this.conf = _conf;
        MessageType testSchema = this.createSchema();
        this.gzipEncryptionTestFileWithoutBloomFilterColumn = new TestFileBuilder(this.conf, testSchema).withNumRecord(this.numRecord).withCodec("GZIP").withPageSize(1024).withWriterVersion(this.writerVersion).build();
        this.uncompressedEncryptionTestFileWithoutBloomFilterColumn = new TestFileBuilder(this.conf, testSchema).withNumRecord(this.numRecord).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build();
    }

    private void testPruneSingleColumnTranslateCodec(List<Path> inputPaths) throws Exception {
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        List<String> pruneColumns = Collections.singletonList("Gender");
        CompressionCodecName newCodec = CompressionCodecName.ZSTD;
        RewriteOptions options = builder.prune(pruneColumns).transform(newCodec).indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        this.validateSchemaWithGenderColumnPruned(false);
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(CompressionCodecName.ZSTD);
            }
        }, null);
        this.validateColumnData(new HashSet<String>(pruneColumns), Collections.emptySet(), null, false, Collections.emptyMap());
        this.validatePageIndex(new HashSet<String>(), false, Collections.emptyMap());
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    @Before
    public void setUp() {
        this.outputFile = TestFileBuilder.createTempFile("test");
        this.inputFilesToJoin = new ArrayList<EncryptionTestFile>();
    }

    @Test
    public void testPruneSingleColumnTranslateCodecSingleFile() throws Exception {
        this.addGzipInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneSingleColumnTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testPruneSingleColumnTranslateCodecTwoFiles() throws Exception {
        this.addGzipInputFile();
        this.addUncompressedInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(1)).getFileName()));
            }
        };
        this.testPruneSingleColumnTranslateCodec((List<Path>)inputPaths);
    }

    private void testPruneNullifyTranslateCodec(List<Path> inputPaths) throws Exception {
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        List<String> pruneColumns = Collections.singletonList("Gender");
        HashMap<String, MaskMode> maskColumns = new HashMap<String, MaskMode>();
        maskColumns.put("Links.Forward", MaskMode.NULLIFY);
        final CompressionCodecName newCodec = CompressionCodecName.ZSTD;
        RewriteOptions options = builder.prune(pruneColumns).mask(maskColumns).transform(newCodec).indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        this.validateSchemaWithGenderColumnPruned(false);
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(newCodec);
            }
        }, null);
        this.validateColumnData(new HashSet<String>(pruneColumns), maskColumns.keySet(), null, false, Collections.emptyMap());
        this.validatePageIndex((Set<String>)ImmutableSet.of((Object)"Links.Forward"), false, Collections.emptyMap());
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    @Test
    public void testPruneNullifyTranslateCodecSingleFile() throws Exception {
        this.addGzipInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneNullifyTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testPruneNullifyTranslateCodecTwoFiles() throws Exception {
        this.addGzipInputFile();
        this.addUncompressedInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(1)).getFileName()));
            }
        };
        this.testPruneNullifyTranslateCodec((List<Path>)inputPaths);
    }

    private void testPruneEncryptTranslateCodec(List<Path> inputPaths) throws Exception {
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        List<String> pruneColumns = Collections.singletonList("Gender");
        builder.prune(pruneColumns);
        final CompressionCodecName newCodec = CompressionCodecName.ZSTD;
        builder.transform(newCodec);
        String[] encryptColumns = new String[]{"DocId"};
        FileEncryptionProperties fileEncryptionProperties = EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false);
        builder.encrypt(Arrays.asList(encryptColumns)).encryptionProperties(fileEncryptionProperties);
        builder.indexCacheStrategy(this.indexCacheStrategy);
        RewriteOptions options = builder.build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        this.validateSchemaWithGenderColumnPruned(false);
        FileDecryptionProperties fileDecryptionProperties = EncDecProperties.getFileDecryptionProperties();
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(newCodec);
            }
        }, fileDecryptionProperties);
        this.validateColumnData(new HashSet<String>(pruneColumns), Collections.emptySet(), fileDecryptionProperties, false, Collections.emptyMap());
        ParquetMetadata metaData = this.getFileMetaData(this.outputFile, fileDecryptionProperties);
        Assert.assertFalse((boolean)metaData.getBlocks().isEmpty());
        List columns = ((BlockMetaData)metaData.getBlocks().get(0)).getColumns();
        HashSet<String> set = new HashSet<String>(Arrays.asList(encryptColumns));
        for (ColumnChunkMetaData column : columns) {
            if (set.contains(column.getPath().toDotString())) {
                Assert.assertTrue((boolean)column.isEncrypted());
                continue;
            }
            Assert.assertFalse((boolean)column.isEncrypted());
        }
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    @Test
    public void testPruneEncryptTranslateCodecSingleFile() throws Exception {
        this.addGzipInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneEncryptTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testPruneEncryptTranslateCodecTwoFiles() throws Exception {
        this.addGzipInputFile();
        this.addUncompressedInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(1)).getFileName()));
            }
        };
        this.testPruneEncryptTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testRewriteWithoutColumnIndexes() throws Exception {
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(ParquetRewriterTest.class.getResource("/test-file-with-no-column-indexes-1.parquet").toURI()));
            }
        };
        this.inputFiles = inputPaths.stream().map(p -> new EncryptionTestFile(p.toString(), null)).collect(Collectors.toList());
        RewriteOptions.Builder builder = this.createBuilder((List<Path>)inputPaths);
        HashMap maskCols = Maps.newHashMap();
        maskCols.put("location.lat", MaskMode.NULLIFY);
        maskCols.put("location.lon", MaskMode.NULLIFY);
        maskCols.put("location", MaskMode.NULLIFY);
        ArrayList pruneCols = Lists.newArrayList((Object[])new String[]{"phoneNumbers"});
        RewriteOptions options = builder.mask((Map)maskCols).prune((List)pruneCols).indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        List fields = schema.getFields();
        Assert.assertEquals((long)fields.size(), (long)3L);
        Assert.assertEquals((Object)((Type)fields.get(0)).getName(), (Object)"id");
        Assert.assertEquals((Object)((Type)fields.get(1)).getName(), (Object)"name");
        Assert.assertEquals((Object)((Type)fields.get(2)).getName(), (Object)"location");
        List subFields = ((Type)fields.get(2)).asGroupType().getFields();
        Assert.assertEquals((long)subFields.size(), (long)2L);
        Assert.assertEquals((Object)((Type)subFields.get(0)).getName(), (Object)"lon");
        Assert.assertEquals((Object)((Type)subFields.get(1)).getName(), (Object)"lat");
        try (ParquetReader outReader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.outputFile)).withConf(this.conf).build();
             ParquetReader inReader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)((Path)inputPaths.get(0))).withConf(this.conf).build();){
            Group inRead = (Group)inReader.read();
            Group outRead = (Group)outReader.read();
            while (inRead != null || outRead != null) {
                Assert.assertNotNull((Object)inRead);
                Assert.assertNotNull((Object)outRead);
                Assert.assertEquals((long)inRead.getLong("id", 0), (long)outRead.getLong("id", 0));
                Assert.assertEquals((Object)inRead.getString("name", 0), (Object)outRead.getString("name", 0));
                Group finalOutRead = outRead;
                Assert.assertThrows(RuntimeException.class, () -> finalOutRead.getGroup("location", 0).getDouble("lat", 0));
                Assert.assertThrows(RuntimeException.class, () -> finalOutRead.getGroup("location", 0).getDouble("lon", 0));
                Assert.assertThrows(InvalidRecordException.class, () -> finalOutRead.getGroup("phoneNumbers", 0));
                inRead = (Group)inReader.read();
                outRead = (Group)outReader.read();
            }
        }
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    private void testNullifyAndEncryptColumn(List<Path> inputPaths) throws Exception {
        HashMap<String, MaskMode> maskColumns = new HashMap<String, MaskMode>();
        maskColumns.put("Links.Forward", MaskMode.NULLIFY);
        String[] encryptColumns = new String[]{"DocId"};
        FileEncryptionProperties fileEncryptionProperties = EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false);
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        RewriteOptions options = builder.mask(maskColumns).transform(CompressionCodecName.ZSTD).encrypt(Arrays.asList(encryptColumns)).encryptionProperties(fileEncryptionProperties).indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        FileDecryptionProperties fileDecryptionProperties = EncDecProperties.getFileDecryptionProperties();
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(CompressionCodecName.ZSTD);
            }
        }, fileDecryptionProperties);
        this.validateColumnData(Collections.emptySet(), maskColumns.keySet(), fileDecryptionProperties, false, Collections.emptyMap());
        this.validatePageIndex((Set<String>)ImmutableSet.of((Object)"DocId", (Object)"Links.Forward"), false, Collections.emptyMap());
        ParquetMetadata metaData = this.getFileMetaData(this.outputFile, fileDecryptionProperties);
        Assert.assertFalse((boolean)metaData.getBlocks().isEmpty());
        HashSet<String> encryptedColumns = new HashSet<String>(Arrays.asList(encryptColumns));
        for (BlockMetaData blockMetaData : metaData.getBlocks()) {
            List columns = blockMetaData.getColumns();
            for (ColumnChunkMetaData column : columns) {
                if (encryptedColumns.contains(column.getPath().toDotString())) {
                    Assert.assertTrue((boolean)column.isEncrypted());
                    continue;
                }
                Assert.assertFalse((boolean)column.isEncrypted());
            }
        }
    }

    @Test
    public void testNullifyEncryptSingleFile() throws Exception {
        this.addGzipInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testNullifyAndEncryptColumn((List<Path>)inputPaths);
    }

    @Test
    public void testNullifyEncryptTwoFiles() throws Exception {
        this.addGzipInputFile();
        this.addUncompressedInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(1)).getFileName()));
            }
        };
        this.testNullifyAndEncryptColumn((List<Path>)inputPaths);
    }

    @Test
    public void testMergeTwoFilesOnly() throws Exception {
        this.addGzipInputFile();
        this.addUncompressedInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>();
        for (EncryptionTestFile inputFile : this.inputFiles) {
            inputPaths.add(new Path(inputFile.getFileName()));
        }
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        RewriteOptions options = builder.indexCacheStrategy(this.indexCacheStrategy).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        MessageType expectSchema = this.createSchema();
        Assert.assertEquals((Object)expectSchema, (Object)schema);
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)new HashSet<CompressionCodecName>(){
            {
                this.add(CompressionCodecName.GZIP);
                this.add(CompressionCodecName.UNCOMPRESSED);
            }
        }, null);
        this.validateColumnData(Collections.emptySet(), Collections.emptySet(), null, false, Collections.emptyMap());
        this.validatePageIndex(new HashSet<String>(), false, Collections.emptyMap());
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
    }

    @Test
    public void testMergeTwoFilesOnlyRenameColumn() throws Exception {
        this.addGzipInputFile();
        this.addUncompressedInputFile();
        ImmutableMap renameColumns = ImmutableMap.of((Object)"Name", (Object)"NameRenamed");
        ImmutableList pruneColumns = ImmutableList.of((Object)"Gender");
        String[] encryptColumns = new String[]{"DocId"};
        FileEncryptionProperties fileEncryptionProperties = EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false);
        List<Path> inputPaths = this.inputFiles.stream().map(x -> new Path(x.getFileName())).collect(Collectors.toList());
        RewriteOptions.Builder builder = this.createBuilder(inputPaths);
        RewriteOptions options = builder.indexCacheStrategy(this.indexCacheStrategy).renameColumns((Map)ImmutableMap.of((Object)"Name", (Object)"NameRenamed")).prune((List)pruneColumns).transform(CompressionCodecName.SNAPPY).encrypt(Arrays.asList(encryptColumns)).encryptionProperties(fileEncryptionProperties).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        FileDecryptionProperties fileDecryptionProperties = EncDecProperties.getFileDecryptionProperties();
        ParquetMetadata pmd = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = pmd.getFileMetaData().getSchema();
        MessageType expectSchema = this.createSchemaWithRenamed();
        Assert.assertEquals((Object)expectSchema, (Object)schema);
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)ImmutableSet.of((Object)CompressionCodecName.SNAPPY), fileDecryptionProperties);
        this.validateColumnData(new HashSet<String>((Collection<String>)pruneColumns), Collections.emptySet(), fileDecryptionProperties, false, (Map<String, String>)renameColumns);
        this.validatePageIndex((Set<String>)ImmutableSet.of((Object)"DocId"), false, (Map<String, String>)renameColumns);
        this.validateCreatedBy();
        this.validateRowGroupRowCount();
        ParquetMetadata metaData = this.getFileMetaData(this.outputFile, fileDecryptionProperties);
        Assert.assertFalse((boolean)metaData.getBlocks().isEmpty());
        HashSet<String> encryptedColumns = new HashSet<String>(Arrays.asList(encryptColumns));
        for (BlockMetaData blockMetaData : metaData.getBlocks()) {
            List columns = blockMetaData.getColumns();
            for (ColumnChunkMetaData column : columns) {
                if (encryptedColumns.contains(column.getPath().toDotString())) {
                    Assert.assertTrue((boolean)column.isEncrypted());
                    continue;
                }
                Assert.assertFalse((boolean)column.isEncrypted());
            }
        }
    }

    @Test(expected=InvalidSchemaException.class)
    public void testMergeTwoFilesWithDifferentSchema() throws Exception {
        this.testMergeTwoFilesWithDifferentSchemaSetup(true, null, null);
    }

    @Test(expected=InvalidSchemaException.class)
    public void testMergeTwoFilesToJoinWithDifferentSchema() throws Exception {
        this.testMergeTwoFilesWithDifferentSchemaSetup(false, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeTwoFilesWithWrongDestinationRenamedColumn() throws Exception {
        this.testMergeTwoFilesWithDifferentSchemaSetup(null, (Map<String, String>)ImmutableMap.of((Object)"WrongColumnName", (Object)"WrongColumnNameRenamed"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeTwoFilesWithWrongSourceRenamedColumn() throws Exception {
        this.testMergeTwoFilesWithDifferentSchemaSetup(null, (Map<String, String>)ImmutableMap.of((Object)"Name", (Object)"DocId"), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeTwoFilesNullifyAndRenamedSameColumn() throws Exception {
        this.testMergeTwoFilesWithDifferentSchemaSetup(null, (Map<String, String>)ImmutableMap.of((Object)"Name", (Object)"NameRenamed"), (Map<String, MaskMode>)ImmutableMap.of((Object)"Name", (Object)MaskMode.NULLIFY));
    }

    public void testMergeTwoFilesWithDifferentSchemaSetup(Boolean wrongSchemaInInputFile, Map<String, String> renameColumns, Map<String, MaskMode> maskColumns) throws Exception {
        MessageType schema1 = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
        MessageType schema2 = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender")});
        this.inputFiles = Lists.newArrayList();
        this.inputFiles.add(new TestFileBuilder(this.conf, schema1).withNumRecord(this.numRecord).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
        this.inputFilesToJoin.add(new TestFileBuilder(this.conf, schema1).withNumRecord(this.numRecord).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
        if (wrongSchemaInInputFile != null) {
            if (wrongSchemaInInputFile.booleanValue()) {
                this.inputFiles.add(new TestFileBuilder(this.conf, schema2).withNumRecord(this.numRecord).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
            } else {
                this.inputFilesToJoin.add(new TestFileBuilder(this.conf, schema2).withNumRecord(this.numRecord).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
            }
        }
        RewriteOptions.Builder builder = this.createBuilder(this.inputFiles.stream().map(x -> new Path(x.getFileName())).collect(Collectors.toList()), this.inputFilesToJoin.stream().map(x -> new Path(x.getFileName())).collect(Collectors.toList()), false);
        RewriteOptions options = builder.indexCacheStrategy(this.indexCacheStrategy).renameColumns(renameColumns).mask(maskColumns).build();
        this.rewriter = new ParquetRewriter(options);
    }

    @Test
    public void testRewriteFileWithMultipleBlocks() throws Exception {
        this.addGzipInputFile();
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneSingleColumnTranslateCodec((List<Path>)inputPaths);
    }

    @Test
    public void testPruneSingleColumnTranslateCodecAndEnableBloomFilter() throws Exception {
        this.testSingleInputFileSetupWithBloomFilter("DocId");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneSingleColumnTranslateCodec((List<Path>)inputPaths);
        Map<ColumnPath, List<BloomFilter>> inputBloomFilters = this.allInputBloomFilters();
        Map<ColumnPath, List<BloomFilter>> outputBloomFilters = this.allOutputBloomFilters(null);
        Assert.assertEquals(inputBloomFilters, outputBloomFilters);
    }

    @Test
    public void testPruneNullifyTranslateCodecAndEnableBloomFilter() throws Exception {
        this.testSingleInputFileSetupWithBloomFilter("DocId", "Links.Forward");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneNullifyTranslateCodec((List<Path>)inputPaths);
        Map<ColumnPath, List<BloomFilter>> inputBloomFilters = this.allInputBloomFilters();
        Assert.assertEquals((long)inputBloomFilters.size(), (long)2L);
        Assert.assertTrue((boolean)inputBloomFilters.containsKey(ColumnPath.fromDotString((String)"Links.Forward")));
        Assert.assertTrue((boolean)inputBloomFilters.containsKey(ColumnPath.fromDotString((String)"DocId")));
        Map<ColumnPath, List<BloomFilter>> outputBloomFilters = this.allOutputBloomFilters(null);
        Assert.assertEquals((long)outputBloomFilters.size(), (long)1L);
        Assert.assertTrue((boolean)outputBloomFilters.containsKey(ColumnPath.fromDotString((String)"DocId")));
        inputBloomFilters.remove(ColumnPath.fromDotString((String)"Links.Forward"));
        Assert.assertEquals(inputBloomFilters, outputBloomFilters);
    }

    @Test
    public void testPruneEncryptTranslateCodecAndEnableBloomFilter() throws Exception {
        this.testSingleInputFileSetupWithBloomFilter("DocId", "Links.Forward");
        ArrayList<Path> inputPaths = new ArrayList<Path>(){
            {
                this.add(new Path(((EncryptionTestFile)ParquetRewriterTest.this.inputFiles.get(0)).getFileName()));
            }
        };
        this.testPruneEncryptTranslateCodec((List<Path>)inputPaths);
        Map<ColumnPath, List<BloomFilter>> inputBloomFilters = this.allInputBloomFilters();
        Assert.assertThrows(ParquetCryptoRuntimeException.class, () -> this.allOutputBloomFilters(null));
        FileDecryptionProperties fileDecryptionProperties = EncDecProperties.getFileDecryptionProperties();
        Map<ColumnPath, List<BloomFilter>> outputBloomFilters = this.allOutputBloomFilters(fileDecryptionProperties);
        Assert.assertEquals(inputBloomFilters, outputBloomFilters);
    }

    private void testSingleInputFileSetupWithBloomFilter(String ... bloomFilterEnabledColumns) throws IOException {
        this.testSingleInputFileSetup(bloomFilterEnabledColumns);
    }

    private void testSingleInputFileSetup(String ... bloomFilterEnabledColumns) throws IOException {
        MessageType schema = this.createSchema();
        this.inputFiles = Lists.newArrayList();
        this.inputFiles.add(new TestFileBuilder(this.conf, schema).withNumRecord(this.numRecord).withCodec("GZIP").withPageSize(0x100000).withRowGroupSize(0x8000000L).withBloomFilterEnabled(bloomFilterEnabledColumns).withWriterVersion(this.writerVersion).build());
    }

    @Test
    public void testFilesToJoinHaveDifferentRowCount() throws Exception {
        MessageType schema1 = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId")});
        MessageType schema2 = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name")});
        this.inputFiles = ImmutableList.of((Object)new TestFileBuilder(this.conf, schema1).withNumRecord(this.numRecord).build());
        this.inputFilesToJoin = ImmutableList.of((Object)new TestFileBuilder(this.conf, schema2).withNumRecord(this.numRecord / 2).build());
        RewriteOptions.Builder builder = this.createBuilder(this.inputFiles.stream().map(x -> new Path(x.getFileName())).collect(Collectors.toList()), this.inputFilesToJoin.stream().map(x -> new Path(x.getFileName())).collect(Collectors.toList()), true);
        RewriteOptions options = builder.build();
        try {
            this.rewriter = new ParquetRewriter(options);
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("The number of rows in each block must match"));
        }
    }

    @Test
    public void testOneInputFileManyInputFilesToJoinWithJoinColumnsOverwrite() throws Exception {
        this.testOneInputFileManyInputFilesToJoinSetup(true);
    }

    @Test
    public void testOneInputFileManyInputFilesToJoinWithoutJoinColumnsOverwrite() throws Exception {
        this.testOneInputFileManyInputFilesToJoinSetup(false);
    }

    public void testOneInputFileManyInputFilesToJoinSetup(boolean joinColumnsOverwrite) throws Exception {
        this.testOneInputFileManyInputFilesToJoinSetup();
        String encryptColumn = "DocId";
        String pruneColumn = "Gender";
        FileEncryptionProperties fileEncryptionProperties = EncDecProperties.getFileEncryptionProperties(new String[]{encryptColumn}, ParquetCipher.AES_GCM_CTR_V1, false);
        FileDecryptionProperties fileDecryptionProperties = EncDecProperties.getFileDecryptionProperties();
        List<Path> inputPathsL = this.inputFiles.stream().map(x -> new Path(x.getFileName())).collect(Collectors.toList());
        List<Path> inputPathsR = this.inputFilesToJoin.stream().map(y -> new Path(y.getFileName())).collect(Collectors.toList());
        ImmutableList pruneColumns = ImmutableList.of((Object)pruneColumn);
        ImmutableMap maskColumns = ImmutableMap.of((Object)encryptColumn, (Object)MaskMode.NULLIFY);
        RewriteOptions options = this.createBuilder(inputPathsL, inputPathsR, true).prune((List)pruneColumns).mask((Map)maskColumns).transform(CompressionCodecName.ZSTD).indexCacheStrategy(this.indexCacheStrategy).overwriteInputWithJoinColumns(joinColumnsOverwrite).encrypt((List)ImmutableList.of((Object)encryptColumn)).encryptionProperties(fileEncryptionProperties).build();
        this.rewriter = new ParquetRewriter(options);
        this.rewriter.processBlocks();
        this.rewriter.close();
        Map<ColumnPath, List<BloomFilter>> inputBloomFilters = this.allInputBloomFilters();
        Map<ColumnPath, List<BloomFilter>> outputBloomFilters = this.allOutputBloomFilters(fileDecryptionProperties);
        Set schemaRColumns = this.createSchemaToJoin().getColumns().stream().map(x -> ColumnPath.get((String[])x.getPath())).collect(Collectors.toSet());
        Set rBloomFilters = outputBloomFilters.keySet().stream().filter(schemaRColumns::contains).collect(Collectors.toSet());
        ParquetMetadata metaData = this.getFileMetaData(this.outputFile, fileDecryptionProperties);
        Assert.assertFalse((boolean)metaData.getBlocks().isEmpty());
        List columns = ((BlockMetaData)metaData.getBlocks().get(0)).getColumns();
        ImmutableSet set = ImmutableSet.of((Object)encryptColumn);
        for (ColumnChunkMetaData column : columns) {
            if (set.contains(column.getPath().toDotString())) {
                Assert.assertTrue((boolean)column.isEncrypted());
                continue;
            }
            Assert.assertFalse((boolean)column.isEncrypted());
        }
        this.validateColumnData(new HashSet<String>((Collection<String>)pruneColumns), maskColumns.keySet(), fileDecryptionProperties, joinColumnsOverwrite, Collections.emptyMap());
        this.validateSchemaWithGenderColumnPruned(true);
        this.validateCreatedBy();
        Assert.assertEquals(inputBloomFilters.keySet(), rBloomFilters);
        this.verifyCodec(this.outputFile, (Set<CompressionCodecName>)ImmutableSet.of((Object)CompressionCodecName.ZSTD), fileDecryptionProperties);
        this.validatePageIndex((Set<String>)ImmutableSet.of((Object)encryptColumn), joinColumnsOverwrite, Collections.emptyMap());
    }

    private void testOneInputFileManyInputFilesToJoinSetup() throws IOException {
        this.inputFiles = Lists.newArrayList((Object[])new EncryptionTestFile[]{new TestFileBuilder(this.conf, this.createSchema()).withNumRecord(this.numRecord).withRowGroupSize(0x100000L).withCodec("GZIP").withPageSize(0x100000).withWriterVersion(this.writerVersion).build()});
        List rowGroupRowCounts = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.inputFiles.get(0).getFileName()), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER).getBlocks().stream().map(BlockMetaData::getRowCount).collect(Collectors.toList());
        Iterator iterator = rowGroupRowCounts.iterator();
        while (iterator.hasNext()) {
            long count = (Long)iterator.next();
            this.inputFilesToJoin.add(new TestFileBuilder(this.conf, this.createSchemaToJoin()).withNumRecord((int)count).withCodec("UNCOMPRESSED").withPageSize(0x100000).withWriterVersion(this.writerVersion).build());
        }
    }

    private MessageType createSchema() {
        return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.FLOAT, "FloatFraction"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "DoubleFraction"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
    }

    private MessageType createSchemaToJoin() {
        return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.FLOAT, "FloatFraction"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "Age"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
    }

    private MessageType createSchemaWithRenamed() {
        return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "NameRenamed"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.FLOAT, "FloatFraction"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "DoubleFraction"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
    }

    private void validateColumnData(Set<String> prunePaths, Set<String> nullifiedPaths, FileDecryptionProperties fileDecryptionProperties, Boolean joinColumnsOverwrite, Map<String, String> renameColumns) throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(this.outputFile)).withConf(this.conf).withDecryption(fileDecryptionProperties).build();
        List filesMain = this.inputFiles.stream().flatMap(x -> Arrays.stream(x.getFileContent())).collect(Collectors.toList());
        List filesJoined = this.inputFilesToJoin.stream().flatMap(x -> Arrays.stream(x.getFileContent())).collect(Collectors.toList());
        BiFunction<String, Integer, Group> groupsExpected = (name, rowIdx) -> {
            if (!((SimpleGroup)filesMain.get(0)).getType().containsField(name) || joinColumnsOverwrite.booleanValue() && !filesJoined.isEmpty() && ((SimpleGroup)filesJoined.get(0)).getType().containsField(name)) {
                return (Group)filesJoined.get((int)rowIdx);
            }
            return (Group)filesMain.get((int)rowIdx);
        };
        int totalRows = this.inputFiles.stream().mapToInt(x -> x.getFileContent().length).sum();
        for (int i = 0; i < totalRows; ++i) {
            Group groupActual = (Group)reader.read();
            Assert.assertNotNull((Object)groupActual);
            if (!prunePaths.contains("DocId")) {
                if (nullifiedPaths.contains("DocId")) {
                    Assert.assertThrows(RuntimeException.class, () -> groupActual.getLong("DocId", 0));
                } else {
                    Assert.assertEquals((long)groupActual.getLong("DocId", 0), (long)groupsExpected.apply("DocId", i).getLong("DocId", 0));
                }
            }
            if (!prunePaths.contains("Name") && !nullifiedPaths.contains("Name")) {
                String colName = renameColumns.getOrDefault("Name", "Name");
                Assert.assertArrayEquals((byte[])groupActual.getBinary(colName, 0).getBytes(), (byte[])groupsExpected.apply("Name", i).getBinary("Name", 0).getBytes());
            }
            if (!prunePaths.contains("Gender") && !nullifiedPaths.contains("Gender")) {
                Assert.assertArrayEquals((byte[])groupActual.getBinary("Gender", 0).getBytes(), (byte[])groupsExpected.apply("Gender", i).getBinary("Gender", 0).getBytes());
            }
            if (!prunePaths.contains("FloatFraction") && !nullifiedPaths.contains("FloatFraction")) {
                Assert.assertEquals((float)groupActual.getFloat("FloatFraction", 0), (float)groupsExpected.apply("FloatFraction", i).getFloat("FloatFraction", 0), (float)0.0f);
            }
            if (!prunePaths.contains("DoubleFraction") && !nullifiedPaths.contains("DoubleFraction")) {
                Assert.assertEquals((double)groupActual.getDouble("DoubleFraction", 0), (double)groupsExpected.apply("DoubleFraction", i).getDouble("DoubleFraction", 0), (double)0.0);
            }
            Group subGroup = groupActual.getGroup("Links", 0);
            if (!prunePaths.contains("Links.Backward") && !nullifiedPaths.contains("Links.Backward")) {
                Assert.assertArrayEquals((byte[])subGroup.getBinary("Backward", 0).getBytes(), (byte[])groupsExpected.apply("Links", i).getGroup("Links", 0).getBinary("Backward", 0).getBytes());
            }
            if (prunePaths.contains("Links.Forward")) continue;
            if (nullifiedPaths.contains("Links.Forward")) {
                Assert.assertThrows(RuntimeException.class, () -> subGroup.getBinary("Forward", 0));
                continue;
            }
            Assert.assertArrayEquals((byte[])subGroup.getBinary("Forward", 0).getBytes(), (byte[])groupsExpected.apply("Links", i).getGroup("Links", 0).getBinary("Forward", 0).getBytes());
        }
        reader.close();
    }

    private ParquetMetadata getFileMetaData(String file, FileDecryptionProperties fileDecryptionProperties) throws IOException {
        ParquetMetadata pmd;
        ParquetReadOptions readOptions = ParquetReadOptions.builder().withDecryption(fileDecryptionProperties).build();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)new Path(file), (Configuration)this.conf);
        try (SeekableInputStream in = inputFile.newStream();){
            pmd = ParquetFileReader.readFooter((InputFile)inputFile, (ParquetReadOptions)readOptions, (SeekableInputStream)in);
        }
        return pmd;
    }

    private void verifyCodec(String file, Set<CompressionCodecName> expectedCodecs, FileDecryptionProperties fileDecryptionProperties) throws IOException {
        HashSet<CompressionCodecName> codecs = new HashSet<CompressionCodecName>();
        ParquetMetadata pmd = this.getFileMetaData(file, fileDecryptionProperties);
        for (int i = 0; i < pmd.getBlocks().size(); ++i) {
            BlockMetaData block = (BlockMetaData)pmd.getBlocks().get(i);
            for (int j = 0; j < block.getColumns().size(); ++j) {
                ColumnChunkMetaData columnChunkMetaData = (ColumnChunkMetaData)block.getColumns().get(j);
                codecs.add(columnChunkMetaData.getCodec());
            }
        }
        Assert.assertEquals(expectedCodecs, codecs);
    }

    private ColumnPath normalizeFieldsInPath(ColumnPath path, Map<String, String> renameColumns) {
        String[] pathArray = path.toArray();
        if (renameColumns != null) {
            pathArray[0] = renameColumns.getOrDefault(pathArray[0], pathArray[0]);
        }
        return ColumnPath.get((String[])pathArray);
    }

    private void validatePageIndex(Set<String> exclude, boolean joinColumnsOverwrite, Map<String, String> renameColumns) throws Exception {
        class BlockMeta {
            final CompressionConverter.TransParquetFileReader reader;
            final BlockMetaData blockMeta;
            final Map<ColumnPath, ColumnChunkMetaData> colPathToMeta;

            BlockMeta(CompressionConverter.TransParquetFileReader reader, BlockMetaData blockMeta, Map<ColumnPath, ColumnChunkMetaData> colPathToMeta) {
                this.reader = reader;
                this.blockMeta = blockMeta;
                this.colPathToMeta = colPathToMeta;
            }
        }
        CheckedFunction<List, List> blockMetaExtractor = files -> {
            ArrayList result = new ArrayList();
            for (String inputFile : files) {
                CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(inputFile), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());
                reader.getFooter().getBlocks().forEach(blockMetaData -> result.add(new BlockMeta(reader, (BlockMetaData)blockMetaData, blockMetaData.getColumns().stream().collect(Collectors.toMap(ColumnChunkMetaData::getPath, Function.identity())))));
            }
            return result;
        };
        List inBlocksMain = blockMetaExtractor.apply(this.inputFiles.stream().map(EncryptionTestFile::getFileName).collect(Collectors.toList()));
        List inBlocksJoined = blockMetaExtractor.apply(this.inputFilesToJoin.stream().map(EncryptionTestFile::getFileName).collect(Collectors.toList()));
        List outBlocks = blockMetaExtractor.apply((List)ImmutableList.of((Object)this.outputFile));
        Map<String, String> renameColumnsInverted = renameColumns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        for (int blockIdx = 0; blockIdx < outBlocks.size(); ++blockIdx) {
            BlockMetaData outBlockMeta = ((BlockMeta)outBlocks.get((int)blockIdx)).blockMeta;
            CompressionConverter.TransParquetFileReader outReader = ((BlockMeta)outBlocks.get((int)blockIdx)).reader;
            for (ColumnChunkMetaData outChunk : outBlockMeta.getColumns()) {
                ColumnChunkMetaData inChunk;
                BlockMetaData inBlockMeta;
                CompressionConverter.TransParquetFileReader inReader;
                if (exclude.contains(outChunk.getPath().toDotString())) continue;
                ColumnPath colPath = this.normalizeFieldsInPath(outChunk.getPath(), renameColumnsInverted);
                if (!((BlockMeta)inBlocksMain.get((int)blockIdx)).colPathToMeta.containsKey(colPath) || joinColumnsOverwrite && !inBlocksJoined.isEmpty() && ((BlockMeta)inBlocksJoined.get((int)blockIdx)).colPathToMeta.containsKey(colPath)) {
                    inReader = ((BlockMeta)inBlocksJoined.get((int)blockIdx)).reader;
                    inBlockMeta = ((BlockMeta)inBlocksJoined.get((int)blockIdx)).blockMeta;
                    inChunk = ((BlockMeta)inBlocksJoined.get((int)blockIdx)).colPathToMeta.get(colPath);
                } else {
                    inReader = ((BlockMeta)inBlocksMain.get((int)blockIdx)).reader;
                    inBlockMeta = ((BlockMeta)inBlocksMain.get((int)blockIdx)).blockMeta;
                    inChunk = ((BlockMeta)inBlocksMain.get((int)blockIdx)).colPathToMeta.get(colPath);
                }
                ColumnIndex inColumnIndex = inReader.readColumnIndex(inChunk);
                OffsetIndex inOffsetIndex = inReader.readOffsetIndex(inChunk);
                ColumnIndex outColumnIndex = outReader.readColumnIndex(outChunk);
                OffsetIndex outOffsetIndex = outReader.readOffsetIndex(outChunk);
                if (inColumnIndex != null) {
                    Assert.assertEquals((Object)inColumnIndex.getBoundaryOrder(), (Object)outColumnIndex.getBoundaryOrder());
                    Assert.assertEquals((Object)inColumnIndex.getMaxValues(), (Object)outColumnIndex.getMaxValues());
                    Assert.assertEquals((Object)inColumnIndex.getMinValues(), (Object)outColumnIndex.getMinValues());
                    Assert.assertEquals((Object)inColumnIndex.getNullCounts(), (Object)outColumnIndex.getNullCounts());
                }
                if (inOffsetIndex == null) continue;
                List<Long> inOffsets = this.getOffsets(inReader, inChunk);
                List<Long> outOffsets = this.getOffsets(outReader, outChunk);
                Assert.assertEquals((long)inOffsets.size(), (long)outOffsets.size());
                Assert.assertEquals((long)inOffsets.size(), (long)inOffsetIndex.getPageCount());
                Assert.assertEquals((long)inOffsetIndex.getPageCount(), (long)outOffsetIndex.getPageCount());
                for (int k = 0; k < inOffsetIndex.getPageCount(); ++k) {
                    Assert.assertEquals((long)inOffsetIndex.getFirstRowIndex(k), (long)outOffsetIndex.getFirstRowIndex(k));
                    Assert.assertEquals((long)inOffsetIndex.getLastRowIndex(k, inBlockMeta.getRowCount()), (long)outOffsetIndex.getLastRowIndex(k, outBlockMeta.getRowCount()));
                    Assert.assertEquals((long)inOffsetIndex.getOffset(k), (long)inOffsets.get(k));
                    Assert.assertEquals((long)outOffsetIndex.getOffset(k), (long)outOffsets.get(k));
                }
            }
        }
        for (BlockMeta t3 : inBlocksMain) {
            t3.reader.close();
        }
        for (BlockMeta t3 : inBlocksJoined) {
            t3.reader.close();
        }
        for (BlockMeta t3 : outBlocks) {
            t3.reader.close();
        }
    }

    private List<Long> getOffsets(CompressionConverter.TransParquetFileReader reader, ColumnChunkMetaData chunk) throws IOException {
        ArrayList<Long> offsets = new ArrayList<Long>();
        reader.setStreamPosition(chunk.getStartingPos());
        long readValues = 0L;
        long totalChunkValues = chunk.getValueCount();
        block5: while (readValues < totalChunkValues) {
            long curOffset = reader.getPos();
            PageHeader pageHeader = reader.readPageHeader();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    this.rewriter.readBlock(pageHeader.getCompressed_page_size(), reader);
                    continue block5;
                }
                case DATA_PAGE: {
                    DataPageHeader headerV1 = pageHeader.data_page_header;
                    offsets.add(curOffset);
                    this.rewriter.readBlock(pageHeader.getCompressed_page_size(), reader);
                    readValues += (long)headerV1.getNum_values();
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    DataPageHeaderV2 headerV2 = pageHeader.data_page_header_v2;
                    offsets.add(curOffset);
                    int rlLength = headerV2.getRepetition_levels_byte_length();
                    this.rewriter.readBlock(rlLength, reader);
                    int dlLength = headerV2.getDefinition_levels_byte_length();
                    this.rewriter.readBlock(dlLength, reader);
                    int payLoadLength = pageHeader.getCompressed_page_size() - rlLength - dlLength;
                    this.rewriter.readBlock(payLoadLength, reader);
                    readValues += (long)headerV2.getNum_values();
                    continue block5;
                }
            }
            throw new IOException("Not recognized page type");
        }
        return offsets;
    }

    private void validateCreatedBy() throws Exception {
        HashSet<String> createdBySet = new HashSet<String>();
        List inFiles = Stream.concat(this.inputFiles.stream(), this.inputFilesToJoin.stream()).collect(Collectors.toList());
        for (EncryptionTestFile inputFile : inFiles) {
            ParquetMetadata pmd = this.getFileMetaData(inputFile.getFileName(), null);
            createdBySet.add(pmd.getFileMetaData().getCreatedBy());
            Assert.assertNull(pmd.getFileMetaData().getKeyValueMetaData().get("original.created.by"));
        }
        Object[] inputCreatedBys = createdBySet.toArray();
        Assert.assertEquals((long)1L, (long)inputCreatedBys.length);
        FileMetaData outFMD = this.getFileMetaData(this.outputFile, null).getFileMetaData();
        String createdBy = outFMD.getCreatedBy();
        Assert.assertNotNull((Object)createdBy);
        Assert.assertEquals((Object)createdBy, (Object)"parquet-mr version 1.16.0 (build 402c3810c372d29603e181771acebfecc71bef61)");
        String inputCreatedBy = (String)inputCreatedBys[0];
        String originalCreatedBy = (String)outFMD.getKeyValueMetaData().get("original.created.by");
        Assert.assertEquals((Object)inputCreatedBy, (Object)originalCreatedBy);
    }

    private void validateRowGroupRowCount() throws Exception {
        ArrayList<Long> inputRowCounts = new ArrayList<Long>();
        for (EncryptionTestFile inputFile : this.inputFiles) {
            ParquetMetadata inputPmd = this.getFileMetaData(inputFile.getFileName(), null);
            for (BlockMetaData blockMetaData : inputPmd.getBlocks()) {
                inputRowCounts.add(blockMetaData.getRowCount());
            }
        }
        ArrayList<Long> outputRowCounts = new ArrayList<Long>();
        ParquetMetadata outPmd = this.getFileMetaData(this.outputFile, null);
        for (BlockMetaData blockMetaData : outPmd.getBlocks()) {
            outputRowCounts.add(blockMetaData.getRowCount());
        }
        Assert.assertEquals(inputRowCounts, outputRowCounts);
    }

    private Map<ColumnPath, List<BloomFilter>> allInputBloomFilters() throws Exception {
        HashMap<ColumnPath, List<BloomFilter>> inputBloomFilters = new HashMap<ColumnPath, List<BloomFilter>>();
        List files = Stream.concat(this.inputFiles.stream(), this.inputFilesToJoin.stream()).collect(Collectors.toList());
        for (EncryptionTestFile inputFile : files) {
            Map<ColumnPath, List<BloomFilter>> bloomFilters = this.allBloomFilters(inputFile.getFileName(), null);
            for (Map.Entry<ColumnPath, List<BloomFilter>> entry : bloomFilters.entrySet()) {
                List bloomFilterList = inputBloomFilters.getOrDefault(entry.getKey(), new ArrayList());
                bloomFilterList.addAll((Collection)entry.getValue());
                inputBloomFilters.put(entry.getKey(), bloomFilterList);
            }
        }
        return inputBloomFilters;
    }

    private Map<ColumnPath, List<BloomFilter>> allOutputBloomFilters(FileDecryptionProperties fileDecryptionProperties) throws Exception {
        return this.allBloomFilters(this.outputFile, fileDecryptionProperties);
    }

    private Map<ColumnPath, List<BloomFilter>> allBloomFilters(String path, FileDecryptionProperties fileDecryptionProperties) throws Exception {
        HashMap<ColumnPath, List<BloomFilter>> allBloomFilters = new HashMap<ColumnPath, List<BloomFilter>>();
        ParquetReadOptions readOptions = ParquetReadOptions.builder().withDecryption(fileDecryptionProperties).build();
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)new Path(path), (Configuration)this.conf);
        try (CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader((InputFile)inputFile, readOptions);){
            ParquetMetadata metadata = reader.getFooter();
            for (BlockMetaData blockMetaData : metadata.getBlocks()) {
                for (ColumnChunkMetaData columnChunkMetaData : blockMetaData.getColumns()) {
                    BloomFilter bloomFilter = reader.readBloomFilter(columnChunkMetaData);
                    if (bloomFilter == null) continue;
                    List bloomFilterList = allBloomFilters.getOrDefault(columnChunkMetaData.getPath(), new ArrayList());
                    bloomFilterList.add(bloomFilter);
                    allBloomFilters.put(columnChunkMetaData.getPath(), bloomFilterList);
                }
            }
        }
        return allBloomFilters;
    }

    private RewriteOptions.Builder createBuilder(List<Path> inputPaths) throws IOException {
        return this.createBuilder(inputPaths, new ArrayList<Path>(), false);
    }

    private RewriteOptions.Builder createBuilder(List<Path> inputPathsL, List<Path> inputPathsR, boolean overwriteInputWithJoinColumns) throws IOException {
        RewriteOptions.Builder builder;
        if (this.usingHadoop) {
            Path outputPath = new Path(this.outputFile);
            builder = new RewriteOptions.Builder(this.conf, inputPathsL, inputPathsR, outputPath);
        } else {
            HadoopOutputFile outputPath = HadoopOutputFile.fromPath((Path)new Path(this.outputFile), (Configuration)this.conf);
            List inputsL = inputPathsL.stream().map(p -> HadoopInputFile.fromPathUnchecked((Path)p, (Configuration)this.conf)).collect(Collectors.toList());
            List inputsR = inputPathsR.stream().map(p -> HadoopInputFile.fromPathUnchecked((Path)p, (Configuration)this.conf)).collect(Collectors.toList());
            builder = new RewriteOptions.Builder(this.parquetConf, inputsL, inputsR, (OutputFile)outputPath);
        }
        builder.overwriteInputWithJoinColumns(overwriteInputWithJoinColumns);
        return builder;
    }

    private void validateSchemaWithGenderColumnPruned(boolean addJoinedColumn) throws IOException {
        MessageType expectSchema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.FLOAT, "FloatFraction"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "DoubleFraction"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
        if (addJoinedColumn) {
            expectSchema = expectSchema.union(new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "Age")}));
        }
        MessageType actualSchema = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(this.outputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER).getFileMetaData().getSchema();
        Assert.assertEquals((Object)expectSchema, (Object)actualSchema);
    }

    private void addGzipInputFile() {
        if (!this.inputFiles.contains(this.gzipEncryptionTestFileWithoutBloomFilterColumn)) {
            this.inputFiles.add(this.gzipEncryptionTestFileWithoutBloomFilterColumn);
        }
    }

    private void addUncompressedInputFile() {
        if (!this.inputFiles.contains(this.uncompressedEncryptionTestFileWithoutBloomFilterColumn)) {
            this.inputFiles.add(this.uncompressedEncryptionTestFileWithoutBloomFilterColumn);
        }
    }

    @FunctionalInterface
    static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

