/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestBinder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.FutureDataInputStreamBuilderImpl;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.MockHadoopInputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHadoopOpenFile {
    private static final int FIRST = MockHadoopInputStream.TEST_ARRAY[0];
    private URI fsUri;
    private FileStatus status;
    private Path path;
    private Configuration conf;
    private IOException fileNotFound;
    private IllegalArgumentException illegal;

    @Before
    public void setUp() throws URISyntaxException {
        this.fsUri = new URI("mock://path/");
        this.path = new Path("mock://path/file");
        this.conf = new Configuration(false);
        this.fileNotFound = new FileNotFoundException("file not found");
        this.illegal = new IllegalArgumentException("illegal");
        this.status = new FileStatus(10L, false, 1, 1L, 0L, this.path);
    }

    @After
    public void tearDown() {
        FileSystemTestBinder.cleanFilesystemCache();
    }

    @Test
    public void testOpenFileGoodPath() throws Throwable {
        FileSystem mockFS = this.prepareMockFS();
        FSDataInputStream in = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        StubOpenFileBuilder opener = new StubOpenFileBuilder(mockFS, this.path, CompletableFuture.completedFuture(in));
        ((FileSystem)Mockito.doReturn((Object)((Object)opener)).when((Object)mockFS)).openFile(this.path);
        TestHadoopOpenFile.openAndRead(this.fileFromStatus());
        ((FileSystem)Mockito.verify((Object)mockFS, (VerificationMode)Mockito.never())).open(this.path);
    }

    @Test
    public void testOpenFileEarlyFailure() throws Throwable {
        FileSystem mockFS = this.prepareMockFS();
        FSDataInputStream in = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        ((FileSystem)Mockito.doThrow((Throwable)this.illegal).when((Object)mockFS)).openFile(this.path);
        ((FileSystem)Mockito.doReturn((Object)in).when((Object)mockFS)).open(this.path);
        TestHadoopOpenFile.openAndRead(this.fileFromStatus());
    }

    @Test
    public void testOpenFileLateFailure() throws Throwable {
        FileSystem mockFS = this.prepareMockFS();
        FSDataInputStream in = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        StubOpenFileBuilder opener = new StubOpenFileBuilder(mockFS, this.path, (CompletableFuture)CompletableFuture.completedFuture(null).thenApply(f -> {
            throw this.illegal;
        }));
        ((FileSystem)Mockito.doReturn((Object)((Object)opener)).when((Object)mockFS)).openFile(this.path);
        ((FileSystem)Mockito.doReturn((Object)in).when((Object)mockFS)).open(this.path);
        TestHadoopOpenFile.openAndRead(this.fileFromStatus());
    }

    private static void openAndRead(HadoopInputFile inputFile) throws IOException {
        try (SeekableInputStream stream = inputFile.newStream();){
            Assert.assertEquals((String)"byte read", (long)FIRST, (long)stream.read());
        }
    }

    @Test
    public void testOpenFileRaisesIOException() throws Throwable {
        FileSystem mockFS = this.prepareMockFS();
        StubOpenFileBuilder opener = new StubOpenFileBuilder(mockFS, this.path, (CompletableFuture)CompletableFuture.completedFuture(null).thenApply(f -> {
            throw new UncheckedIOException(this.fileNotFound);
        }));
        ((FileSystem)Mockito.doReturn((Object)((Object)opener)).when((Object)mockFS)).openFile(this.path);
        HadoopInputFile inputFile = this.fileFromStatus();
        Assert.assertThrows(FileNotFoundException.class, () -> ((HadoopInputFile)inputFile).newStream());
        ((FileSystem)Mockito.verify((Object)mockFS, (VerificationMode)Mockito.never())).open(this.path);
    }

    @Test
    public void testOpenFileDoubleFailure() throws Throwable {
        FileSystem mockFS = this.prepareMockFS();
        ((FileSystem)Mockito.doThrow((Throwable)this.illegal).when((Object)mockFS)).openFile(this.path);
        ((FileSystem)Mockito.doThrow((Throwable)this.fileNotFound).when((Object)mockFS)).open(this.path);
        HadoopInputFile inputFile = this.fileFromStatus();
        FileNotFoundException caught = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> ((HadoopInputFile)inputFile).newStream());
        Assert.assertSame((Object)this.fileNotFound, (Object)caught);
        Throwable[] suppressed = caught.getSuppressed();
        Assert.assertEquals((String)"number of suppressed exceptions", (long)1L, (long)suppressed.length);
        Assert.assertSame((Object)this.illegal, (Object)suppressed[0]);
    }

    @Test
    public void testOpenFileDoubleRTE() throws Throwable {
        FileSystem mockFS = this.prepareMockFS();
        ((FileSystem)Mockito.doThrow((Throwable)this.illegal).when((Object)mockFS)).openFile(this.path);
        NullPointerException npe = new NullPointerException("null");
        ((FileSystem)Mockito.doThrow((Throwable)npe).when((Object)mockFS)).open(this.path);
        HadoopInputFile inputFile = this.fileFromStatus();
        NullPointerException caught = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> ((HadoopInputFile)inputFile).newStream());
        Assert.assertSame((Object)npe, (Object)caught);
        Throwable[] suppressed = caught.getSuppressed();
        Assert.assertEquals((String)"number of suppressed exceptions", (long)1L, (long)suppressed.length);
        Assert.assertSame((Object)this.illegal, (Object)suppressed[0]);
    }

    private FileSystem prepareMockFS() throws IOException {
        FileSystem mockFS = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doNothing().when((Object)mockFS)).close();
        ((FileSystem)Mockito.doReturn((Object)this.conf).when((Object)mockFS)).getConf();
        ((FileSystem)Mockito.doReturn((Object)this.status).when((Object)mockFS)).getFileStatus(this.path);
        FileSystemTestBinder.addFileSystemForTesting(this.fsUri, mockFS);
        return mockFS;
    }

    private HadoopInputFile fileFromStatus() throws IOException {
        return HadoopInputFile.fromStatus((FileStatus)this.status, (Configuration)this.conf);
    }

    private static final class StubOpenFileBuilder
    extends FutureDataInputStreamBuilderImpl {
        private final CompletableFuture<FSDataInputStream> result;

        private StubOpenFileBuilder(FileSystem fileSystem, Path path, CompletableFuture<FSDataInputStream> result) {
            super(fileSystem, path);
            this.result = result;
        }

        public CompletableFuture<FSDataInputStream> build() throws IllegalArgumentException, UnsupportedOperationException {
            return this.result;
        }
    }
}

