/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.statistics.geospatial.GeospatialStatistics;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.LocalInputFile;
import org.apache.parquet.io.LocalOutputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKBWriter;

public class TestGeometryTypeRoundTrip {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    private Path newTempPath() throws IOException {
        File file = this.temp.newFile();
        Preconditions.checkArgument((boolean)file.delete(), (String)"Could not remove temp file");
        return file.toPath();
    }

    @Test
    public void testBasicReadWriteGeometryValue() throws Exception {
        GeometryFactory geomFactory = new GeometryFactory();
        WKBWriter wkbWriter = new WKBWriter();
        Binary[] points = new Binary[]{Binary.fromConstantByteArray((byte[])wkbWriter.write((Geometry)geomFactory.createPoint(new Coordinate(1.0, 1.0)))), Binary.fromConstantByteArray((byte[])wkbWriter.write((Geometry)geomFactory.createPoint(new Coordinate(2.0, 2.0))))};
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(null))).named("geometry")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Path path = this.newTempPath();
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new LocalOutputFile(path)).withConf(conf)).withDictionaryEncoding(false)).build();){
            for (Binary value : points) {
                writer.write((Object)factory.newGroup().append("geometry", value));
            }
        }
        var9_9 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)new LocalInputFile(path));){
            Assert.assertEquals((long)2L, (long)reader.getRecordCount());
            ParquetMetadata footer = reader.getFooter();
            Assert.assertNotNull((Object)footer);
            ColumnChunkMetaData columnChunkMetaData = (ColumnChunkMetaData)((BlockMetaData)reader.getRowGroups().get(0)).getColumns().get(0);
            Assert.assertNotNull((Object)columnChunkMetaData);
            GeospatialStatistics geospatialStatistics = columnChunkMetaData.getGeospatialStatistics();
            Assert.assertNotNull((Object)geospatialStatistics);
            Assert.assertEquals((double)1.0, (double)geospatialStatistics.getBoundingBox().getXMin(), (double)0.0);
            Assert.assertEquals((double)2.0, (double)geospatialStatistics.getBoundingBox().getXMax(), (double)0.0);
            Assert.assertEquals((double)1.0, (double)geospatialStatistics.getBoundingBox().getYMin(), (double)0.0);
            Assert.assertEquals((double)2.0, (double)geospatialStatistics.getBoundingBox().getYMax(), (double)0.0);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testBasicReadWriteGeographyValue() throws Exception {
        GeometryFactory geomFactory = new GeometryFactory();
        WKBWriter wkbWriter = new WKBWriter();
        Binary[] points = new Binary[]{Binary.fromConstantByteArray((byte[])wkbWriter.write((Geometry)geomFactory.createPoint(new Coordinate(1.0, 1.0)))), Binary.fromConstantByteArray((byte[])wkbWriter.write((Geometry)geomFactory.createPoint(new Coordinate(2.0, 2.0))))};
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geographyType())).named("geography")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Path path = this.newTempPath();
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new LocalOutputFile(path)).withConf(conf)).withDictionaryEncoding(false)).build();){
            for (Binary value : points) {
                writer.write((Object)factory.newGroup().append("geography", value));
            }
        }
        var9_9 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)new LocalInputFile(path));){
            Assert.assertEquals((long)2L, (long)reader.getRecordCount());
            ParquetMetadata footer = reader.getFooter();
            Assert.assertNotNull((Object)footer);
            ColumnChunkMetaData columnChunkMetaData = (ColumnChunkMetaData)((BlockMetaData)reader.getRowGroups().get(0)).getColumns().get(0);
            Assert.assertNotNull((Object)columnChunkMetaData);
            GeospatialStatistics geospatialStatistics = columnChunkMetaData.getGeospatialStatistics();
            Assert.assertNull((Object)geospatialStatistics);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testInvalidGeometryPresented() throws Exception {
        GeometryFactory geomFactory = new GeometryFactory();
        WKBWriter wkbWriter = new WKBWriter();
        Binary[] geometries = new Binary[]{Binary.fromConstantByteArray((byte[])wkbWriter.write((Geometry)geomFactory.createPoint(new Coordinate(1.0, 1.0)))), Binary.fromConstantByteArray((byte[])new byte[]{1, 2, 3, 4}), Binary.fromConstantByteArray((byte[])wkbWriter.write((Geometry)geomFactory.createPoint(new Coordinate(2.0, 2.0))))};
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.geometryType(null))).named("geometry")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Path path = this.newTempPath();
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((OutputFile)new LocalOutputFile(path)).withConf(conf)).withDictionaryEncoding(false)).build();){
            for (Binary value : geometries) {
                writer.write((Object)factory.newGroup().append("geometry", value));
            }
        }
        var9_9 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)new LocalInputFile(path));){
            Assert.assertEquals((long)3L, (long)reader.getRecordCount());
            ParquetMetadata footer = reader.getFooter();
            Assert.assertNotNull((Object)footer);
            ColumnChunkMetaData columnChunkMetaData = (ColumnChunkMetaData)((BlockMetaData)reader.getRowGroups().get(0)).getColumns().get(0);
            Assert.assertNotNull((Object)columnChunkMetaData);
            GeospatialStatistics geospatialStatistics = columnChunkMetaData.getGeospatialStatistics();
            Assert.assertNotNull((String)"Geospatial statistics should omit the corrupt geometry", (Object)geospatialStatistics);
            Assert.assertTrue((String)"Geospatial statistics should be valid", (boolean)geospatialStatistics.isValid());
            Assert.assertNotNull((String)"Bounding box should not be null", (Object)geospatialStatistics.getBoundingBox());
            Assert.assertNotNull((String)"Geospatial types should not be null", (Object)geospatialStatistics.getGeospatialTypes());
            Assert.assertTrue((String)"Geospatial types should be valid", (boolean)geospatialStatistics.getGeospatialTypes().isValid());
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }
}

