/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.statistics.SizeStatistics;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSizeStatisticsRoundTrip {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testBinaryColumnSizeStatistics() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Path path = this.newTempPath();
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withPageRowCountLimit(2)).withMinRowCountForPageSizeCheck(1)).withConf(conf)).build();){
            writer.write((Object)factory.newGroup().append("name", "a"));
            writer.write((Object)factory.newGroup().append("name", "b"));
            writer.write((Object)factory.newGroup().append("name", "c"));
            writer.write((Object)factory.newGroup().append("name", "d"));
        }
        var6_6 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
            ParquetMetadata footer = reader.getFooter();
            ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)footer.getBlocks().get(0)).getColumns().get(0);
            SizeStatistics sizeStatistics = column.getSizeStatistics();
            Assert.assertEquals(Optional.of(4L), (Object)sizeStatistics.getUnencodedByteArrayDataBytes());
            Assert.assertEquals(Collections.emptyList(), (Object)sizeStatistics.getRepetitionLevelHistogram());
            Assert.assertEquals(Collections.emptyList(), (Object)sizeStatistics.getDefinitionLevelHistogram());
            ColumnIndex columnIndex = reader.readColumnIndex(column);
            Assert.assertEquals(Collections.emptyList(), (Object)columnIndex.getRepetitionLevelHistogram());
            Assert.assertEquals(Collections.emptyList(), (Object)columnIndex.getDefinitionLevelHistogram());
            OffsetIndex offsetIndex = reader.readOffsetIndex(column);
            Assert.assertEquals((long)2L, (long)offsetIndex.getPageCount());
            Assert.assertEquals(Optional.of(2L), (Object)offsetIndex.getUnencodedByteArrayDataBytes(0));
            Assert.assertEquals(Optional.of(2L), (Object)offsetIndex.getUnencodedByteArrayDataBytes(1));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testNestedRepeatedOptionalColumnSizeStatistics() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().optionalGroup().repeatedGroup().optional(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value")).named("list")).named("outer")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Path path = this.newTempPath();
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withPageRowCountLimit(2)).withMinRowCountForPageSizeCheck(1)).withConf(conf)).build();){
            Group g1 = factory.newGroup();
            Group outer1 = g1.addGroup("outer");
            Group list1 = outer1.addGroup("list");
            list1.append("value", "a");
            Group list2 = outer1.addGroup("list");
            list2.append("value", "b");
            writer.write((Object)g1);
            Group g2 = factory.newGroup();
            Group outer2 = g2.addGroup("outer");
            Group list3 = outer2.addGroup("list");
            list3.append("value", "c");
            writer.write((Object)g2);
        }
        var6_6 = null;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
            ParquetMetadata footer = reader.getFooter();
            ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)footer.getBlocks().get(0)).getColumns().get(0);
            SizeStatistics sizeStatistics = column.getSizeStatistics();
            Assert.assertEquals(Optional.of(3L), (Object)sizeStatistics.getUnencodedByteArrayDataBytes());
            Assert.assertEquals(Arrays.asList(2L, 1L), (Object)sizeStatistics.getRepetitionLevelHistogram());
            Assert.assertEquals(Arrays.asList(0L, 0L, 0L, 3L), (Object)sizeStatistics.getDefinitionLevelHistogram());
            ColumnIndex columnIndex = reader.readColumnIndex(column);
            Assert.assertEquals(Arrays.asList(2L, 1L), (Object)sizeStatistics.getRepetitionLevelHistogram());
            Assert.assertEquals(Arrays.asList(0L, 0L, 0L, 3L), (Object)sizeStatistics.getDefinitionLevelHistogram());
            OffsetIndex offsetIndex = reader.readOffsetIndex(column);
            Assert.assertEquals((long)1L, (long)offsetIndex.getPageCount());
            Assert.assertEquals(Optional.of(3L), (Object)offsetIndex.getUnencodedByteArrayDataBytes(0));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    private Path newTempPath() throws IOException {
        File file = this.temp.newFile();
        Preconditions.checkArgument((boolean)file.delete(), (String)"Could not remove temp file");
        return new Path(file.getAbsolutePath());
    }
}

