/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.ql.io.parquet.writable.BinaryWritable;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.api.Binary;

public class ParquetHiveSerDe
implements SerDe {
    public static final Text MAP_KEY = new Text("key");
    public static final Text MAP_VALUE = new Text("value");
    public static final Text MAP = new Text("map");
    public static final Text ARRAY = new Text("bag");
    private SerDeStats stats;
    private ObjectInspector objInspector;
    private LAST_OPERATION status;
    private long serializedSize;
    private long deserializedSize;

    public final void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(","));
        ArrayList columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("ParquetHiveSerde initialization failed. Number of column name and column type differs. columnNames = " + columnNames + ", columnTypes = " + columnTypes);
        }
        TypeInfo rowTypeInfo = TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        this.objInspector = new ArrayWritableObjectInspector((StructTypeInfo)rowTypeInfo);
        this.stats = new SerDeStats();
        this.serializedSize = 0L;
        this.deserializedSize = 0L;
        this.status = LAST_OPERATION.UNKNOWN;
    }

    public Object deserialize(Writable blob) throws SerDeException {
        this.status = LAST_OPERATION.DESERIALIZE;
        this.deserializedSize = 0L;
        if (blob instanceof ArrayWritable) {
            this.deserializedSize = ((ArrayWritable)blob).get().length;
            return blob;
        }
        return null;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return ArrayWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (!objInspector.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            throw new SerDeException("Cannot serialize " + objInspector.getCategory() + ". Can only serialize a struct");
        }
        ArrayWritable serializeData = this.createStruct(obj, (StructObjectInspector)objInspector);
        this.serializedSize = serializeData.get().length;
        this.status = LAST_OPERATION.SERIALIZE;
        return serializeData;
    }

    private ArrayWritable createStruct(Object obj, StructObjectInspector inspector) throws SerDeException {
        List fields = inspector.getAllStructFieldRefs();
        Writable[] arr = new Writable[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = (StructField)fields.get(i);
            Object subObj = inspector.getStructFieldData(obj, field);
            ObjectInspector subInspector = field.getFieldObjectInspector();
            arr[i] = this.createObject(subObj, subInspector);
        }
        return new ArrayWritable(Writable.class, arr);
    }

    private Writable createMap(Object obj, MapObjectInspector inspector) throws SerDeException {
        Map sourceMap = inspector.getMap(obj);
        ObjectInspector keyInspector = inspector.getMapKeyObjectInspector();
        ObjectInspector valueInspector = inspector.getMapValueObjectInspector();
        ArrayList<ArrayWritable> array = new ArrayList<ArrayWritable>();
        if (sourceMap != null) {
            for (Map.Entry keyValue : sourceMap.entrySet()) {
                Writable key = this.createObject(keyValue.getKey(), keyInspector);
                Writable value = this.createObject(keyValue.getValue(), valueInspector);
                if (key == null) continue;
                Writable[] arr = new Writable[]{key, value};
                array.add(new ArrayWritable(Writable.class, arr));
            }
        }
        if (array.size() > 0) {
            ArrayWritable subArray = new ArrayWritable(ArrayWritable.class, (Writable[])array.toArray(new ArrayWritable[array.size()]));
            return new ArrayWritable(Writable.class, new Writable[]{subArray});
        }
        return null;
    }

    private ArrayWritable createArray(Object obj, ListObjectInspector inspector) throws SerDeException {
        List sourceArray = inspector.getList(obj);
        ObjectInspector subInspector = inspector.getListElementObjectInspector();
        ArrayList<Writable> array = new ArrayList<Writable>();
        if (sourceArray != null) {
            for (Object curObj : sourceArray) {
                Writable newObj = this.createObject(curObj, subInspector);
                if (newObj == null) continue;
                array.add(newObj);
            }
        }
        if (array.size() > 0) {
            ArrayWritable subArray = new ArrayWritable(((Writable)array.get(0)).getClass(), array.toArray(new Writable[array.size()]));
            return new ArrayWritable(Writable.class, new Writable[]{subArray});
        }
        return null;
    }

    private Writable createPrimitive(Object obj, PrimitiveObjectInspector inspector) throws SerDeException {
        if (obj == null) {
            return null;
        }
        switch (inspector.getPrimitiveCategory()) {
            case VOID: {
                return null;
            }
            case BOOLEAN: {
                return new BooleanWritable((((BooleanObjectInspector)inspector).get(obj) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
            }
            case BYTE: {
                return new ByteWritable(((ByteObjectInspector)inspector).get(obj));
            }
            case DOUBLE: {
                return new DoubleWritable(((DoubleObjectInspector)inspector).get(obj));
            }
            case FLOAT: {
                return new FloatWritable(((FloatObjectInspector)inspector).get(obj));
            }
            case INT: {
                return new IntWritable(((IntObjectInspector)inspector).get(obj));
            }
            case LONG: {
                return new LongWritable(((LongObjectInspector)inspector).get(obj));
            }
            case SHORT: {
                return new ShortWritable(((ShortObjectInspector)inspector).get(obj));
            }
            case STRING: {
                return new BinaryWritable(Binary.fromString(((StringObjectInspector)inspector).getPrimitiveJavaObject(obj)));
            }
        }
        throw new SerDeException("Unknown primitive : " + inspector.getPrimitiveCategory());
    }

    private Writable createObject(Object obj, ObjectInspector inspector) throws SerDeException {
        switch (inspector.getCategory()) {
            case STRUCT: {
                return this.createStruct(obj, (StructObjectInspector)inspector);
            }
            case LIST: {
                return this.createArray(obj, (ListObjectInspector)inspector);
            }
            case MAP: {
                return this.createMap(obj, (MapObjectInspector)inspector);
            }
            case PRIMITIVE: {
                return this.createPrimitive(obj, (PrimitiveObjectInspector)inspector);
            }
        }
        throw new SerDeException("Unknown data type" + inspector.getCategory());
    }

    public SerDeStats getSerDeStats() {
        assert (this.status != LAST_OPERATION.UNKNOWN);
        if (this.status == LAST_OPERATION.SERIALIZE) {
            this.stats.setRawDataSize(this.serializedSize);
        } else {
            this.stats.setRawDataSize(this.deserializedSize);
        }
        return this.stats;
    }

    private static enum LAST_OPERATION {
        SERIALIZE,
        DESERIALIZE,
        UNKNOWN;

    }
}

