/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.write;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriter;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

public class DataWritableWriteSupport
extends WriteSupport<ArrayWritable> {
    public static final String PARQUET_HIVE_SCHEMA = "parquet.hive.schema";
    private DataWritableWriter writer;
    private MessageType schema;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_HIVE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType((String)configuration.get(PARQUET_HIVE_SCHEMA));
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        this.schema = DataWritableWriteSupport.getSchema(configuration);
        return new WriteSupport.WriteContext(this.schema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer = new DataWritableWriter(recordConsumer, (GroupType)this.schema);
    }

    public void write(ArrayWritable record) {
        this.writer.write(record);
    }
}

