/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.math.BigDecimal;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.hive.ql.io.parquet.writable.BinaryWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.PrimitiveConverter;

public enum ETypeConverter {
    EDOUBLE_CONVERTER((Class)Double.TYPE){

        @Override
        Converter getConverter(Class<?> type, final int index, final HiveGroupConverter parent) {
            return new PrimitiveConverter(){

                public void addDouble(double value) {
                    parent.set(index, (Writable)new DoubleWritable(value));
                }
            };
        }
    }
    ,
    EBOOLEAN_CONVERTER((Class)Boolean.TYPE){

        @Override
        Converter getConverter(Class<?> type, final int index, final HiveGroupConverter parent) {
            return new PrimitiveConverter(){

                public void addBoolean(boolean value) {
                    parent.set(index, (Writable)new BooleanWritable(value));
                }
            };
        }
    }
    ,
    EFLOAT_CONVERTER((Class)Float.TYPE){

        @Override
        Converter getConverter(Class<?> type, final int index, final HiveGroupConverter parent) {
            return new PrimitiveConverter(){

                public void addFloat(float value) {
                    parent.set(index, (Writable)new FloatWritable(value));
                }
            };
        }
    }
    ,
    EINT32_CONVERTER((Class)Integer.TYPE){

        @Override
        Converter getConverter(Class<?> type, final int index, final HiveGroupConverter parent) {
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    parent.set(index, (Writable)new IntWritable(value));
                }
            };
        }
    }
    ,
    EINT64_CONVERTER((Class)Long.TYPE){

        @Override
        Converter getConverter(Class<?> type, final int index, final HiveGroupConverter parent) {
            return new PrimitiveConverter(){

                public void addLong(long value) {
                    parent.set(index, (Writable)new LongWritable(value));
                }
            };
        }
    }
    ,
    EINT96_CONVERTER((Class)BigDecimal.class){

        @Override
        Converter getConverter(Class<?> type, final int index, final HiveGroupConverter parent) {
            return new PrimitiveConverter(){

                public void addDouble(double value) {
                    parent.set(index, (Writable)new DoubleWritable(value));
                }
            };
        }
    }
    ,
    EBINARY_CONVERTER((Class)Binary.class){

        @Override
        Converter getConverter(Class<?> type, final int index, final HiveGroupConverter parent) {
            return new PrimitiveConverter(){
                private Binary[] dictBinary;
                private String[] dict;

                public boolean hasDictionarySupport() {
                    return true;
                }

                public void setDictionary(Dictionary dictionary) {
                    this.dictBinary = new Binary[dictionary.getMaxId() + 1];
                    this.dict = new String[dictionary.getMaxId() + 1];
                    for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                        Binary binary;
                        this.dictBinary[i] = binary = dictionary.decodeToBinary(i);
                        this.dict[i] = binary.toStringUsingUTF8();
                    }
                }

                public void addValueFromDictionary(int dictionaryId) {
                    parent.set(index, new BinaryWritable.DicBinaryWritable(this.dictBinary[dictionaryId], this.dict[dictionaryId]));
                }

                public void addBinary(Binary value) {
                    parent.set(index, new BinaryWritable(value));
                }
            };
        }
    };

    final Class<?> _type;

    private ETypeConverter(Class<?> type) {
        this._type = type;
    }

    private Class<?> getType() {
        return this._type;
    }

    abstract Converter getConverter(Class<?> var1, int var2, HiveGroupConverter var3);

    public static Converter getNewConverter(Class<?> type, int index, HiveGroupConverter parent) {
        for (ETypeConverter eConverter : ETypeConverter.values()) {
            if (eConverter.getType() != type) continue;
            return eConverter.getConverter(type, index, parent);
        }
        throw new IllegalArgumentException("Converter not found ... for type : " + type);
    }
}

