/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.GroupType;

public class ArrayWritableGroupConverter
extends HiveGroupConverter {
    private final Converter[] converters;
    private final HiveGroupConverter parent;
    private final int index;
    private final boolean isMap;
    private Writable currentValue;
    private Writable[] mapPairContainer;

    public ArrayWritableGroupConverter(GroupType groupType, HiveGroupConverter parent, int index) {
        this.parent = parent;
        this.index = index;
        int count = groupType.getFieldCount();
        if (count < 1 || count > 2) {
            throw new IllegalStateException("Field count must be either 1 or 2: " + count);
        }
        this.isMap = count == 2;
        this.converters = new Converter[count];
        for (int i = 0; i < count; ++i) {
            this.converters[i] = ArrayWritableGroupConverter.getConverterFromDescription(groupType.getType(i), i, this);
        }
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
        if (this.isMap) {
            this.mapPairContainer = new Writable[2];
        }
    }

    public void end() {
        if (this.isMap) {
            this.currentValue = new ArrayWritable(Writable.class, this.mapPairContainer);
        }
        this.parent.add(this.index, this.currentValue);
    }

    @Override
    protected void set(int index, Writable value) {
        if (index != 0 && this.mapPairContainer == null || index > 1) {
            throw new ParquetDecodingException("Repeated group can only have one or two fields for maps. Not allowed to set for the index : " + index);
        }
        if (this.isMap) {
            this.mapPairContainer[index] = value;
        } else {
            this.currentValue = value;
        }
    }

    @Override
    protected void add(int index, Writable value) {
        this.set(index, value);
    }
}

