/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

public class ParquetHiveArrayInspector
implements SettableListObjectInspector {
    ObjectInspector arrayElementInspector;

    public ParquetHiveArrayInspector(ObjectInspector arrayElementInspector) {
        this.arrayElementInspector = arrayElementInspector;
    }

    public String getTypeName() {
        return "array<" + this.arrayElementInspector.getTypeName() + ">";
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }

    public ObjectInspector getListElementObjectInspector() {
        return this.arrayElementInspector;
    }

    public Object getListElement(Object data, int index) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            Writable[] listContainer = ((ArrayWritable)data).get();
            if (listContainer == null || listContainer.length == 0) {
                return null;
            }
            Writable subObj = listContainer[0];
            if (subObj == null) {
                return null;
            }
            if (index >= 0 && index < ((ArrayWritable)subObj).get().length) {
                return ((ArrayWritable)subObj).get()[index];
            }
            return null;
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    public int getListLength(Object data) {
        if (data == null) {
            return -1;
        }
        if (data instanceof ArrayWritable) {
            Writable[] listContainer = ((ArrayWritable)data).get();
            if (listContainer == null || listContainer.length == 0) {
                return -1;
            }
            Writable subObj = listContainer[0];
            if (subObj == null) {
                return 0;
            }
            return ((ArrayWritable)subObj).get().length;
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    public List<?> getList(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            Writable[] listContainer = ((ArrayWritable)data).get();
            if (listContainer == null || listContainer.length == 0) {
                return null;
            }
            Writable subObj = listContainer[0];
            if (subObj == null) {
                return null;
            }
            Writable[] array = ((ArrayWritable)subObj).get();
            ArrayList<Writable> list = new ArrayList<Writable>();
            for (Writable obj : array) {
                list.add(obj);
            }
            return list;
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    public Object create(int size) {
        ArrayList<Object> result = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            result.add(null);
        }
        return result;
    }

    public Object set(Object list, int index, Object element) {
        ArrayList l = (ArrayList)list;
        l.set(index, element);
        return list;
    }

    public Object resize(Object list, int newSize) {
        ArrayList l = (ArrayList)list;
        l.ensureCapacity(newSize);
        while (l.size() < newSize) {
            l.add(null);
        }
        while (l.size() > newSize) {
            l.remove(l.size() - 1);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ObjectInspector other = ((ParquetHiveArrayInspector)o).arrayElementInspector;
        return other.equals(this.arrayElementInspector);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.arrayElementInspector != null ? this.arrayElementInspector.hashCode() : 0);
        return hash;
    }
}

