/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig.summary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.parquet.pig.summary.EnumStat;
import org.apache.parquet.pig.summary.SummaryData;
import org.apache.parquet.pig.summary.ValueStat;
import shaded.parquet.com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StringSummaryData
extends SummaryData {
    private ValueStat size = new ValueStat();
    private EnumStat values = new EnumStat();

    public void add(String s) {
        super.add(s);
        this.size.add(s.length());
        this.values.add(s);
    }

    @Override
    public void merge(SummaryData other) {
        super.merge(other);
        StringSummaryData stringSummaryData = (StringSummaryData)other;
        this.size.merge(stringSummaryData.size);
        this.values.merge(stringSummaryData.values);
    }

    public ValueStat getSize() {
        return this.size;
    }

    public void setSize(ValueStat size) {
        this.size = size;
    }

    public Collection<EnumStat.EnumValueCount> getValues() {
        Collection<EnumStat.EnumValueCount> values2 = this.values.getValues();
        if (values2 == null) {
            return null;
        }
        ArrayList<EnumStat.EnumValueCount> list = new ArrayList<EnumStat.EnumValueCount>(values2);
        Collections.sort(list, new Comparator<EnumStat.EnumValueCount>(){

            @Override
            public int compare(EnumStat.EnumValueCount o1, EnumStat.EnumValueCount o2) {
                return o2.getCount() - o1.getCount();
            }
        });
        return list;
    }

    public void setValues(Collection<EnumStat.EnumValueCount> values) {
        this.values.setValues(values);
    }
}

