/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.parquet.pig.SchemaConversionException;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.pig.LoadPushDown;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PigSchemaConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PigSchemaConverter.class);
    static final String ARRAY_VALUE_NAME = "value";
    private ColumnAccess columnAccess;

    public PigSchemaConverter() {
        this(false);
    }

    public PigSchemaConverter(boolean columnIndexAccess) {
        this.columnAccess = columnIndexAccess ? new ColumnIndexAccess() : new ColumnNameAccess();
    }

    public static Schema parsePigSchema(String pigSchemaString) {
        try {
            return pigSchemaString == null ? null : Utils.getSchemaFromString((String)pigSchemaString);
        }
        catch (ParserException e) {
            throw new SchemaConversionException("could not parse Pig schema: " + pigSchemaString, e);
        }
    }

    static String pigSchemaToString(Schema pigSchema) {
        String pigSchemaString = pigSchema.toString();
        return pigSchemaString.substring(1, pigSchemaString.length() - 1);
    }

    public static LoadPushDown.RequiredFieldList deserializeRequiredFieldList(String requiredFieldString) {
        if (requiredFieldString == null) {
            return null;
        }
        try {
            return (LoadPushDown.RequiredFieldList)ObjectSerializer.deserialize((String)requiredFieldString);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize pushProjection", e);
        }
    }

    static String serializeRequiredFieldList(LoadPushDown.RequiredFieldList requiredFieldList) {
        try {
            return ObjectSerializer.serialize((Serializable)requiredFieldList);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to searlize required fields.", e);
        }
    }

    public Schema convert(MessageType parquetSchema) {
        return this.convertFields(parquetSchema.getFields());
    }

    public Schema convertField(Type parquetType) {
        return this.convertFields(Arrays.asList(parquetType));
    }

    private Schema convertFields(List<Type> parquetFields) {
        ArrayList<Schema.FieldSchema> fields = new ArrayList<Schema.FieldSchema>();
        for (Type parquetType : parquetFields) {
            try {
                Schema.FieldSchema innerfieldSchema = this.getFieldSchema(parquetType);
                if (parquetType.isRepetition(Type.Repetition.REPEATED)) {
                    Schema bagSchema = new Schema(Arrays.asList(innerfieldSchema));
                    fields.add(new Schema.FieldSchema(null, bagSchema, 120));
                    continue;
                }
                fields.add(innerfieldSchema);
            }
            catch (FrontendException fe) {
                throw new SchemaConversionException("can't convert " + parquetType, fe);
            }
        }
        return new Schema(fields);
    }

    private Schema.FieldSchema getSimpleFieldSchema(final String fieldName, Type parquetType) throws FrontendException {
        PrimitiveType.PrimitiveTypeName parquetPrimitiveTypeName = parquetType.asPrimitiveType().getPrimitiveTypeName();
        final LogicalTypeAnnotation logicalTypeAnnotation = parquetType.getLogicalTypeAnnotation();
        return (Schema.FieldSchema)parquetPrimitiveTypeName.convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<Schema.FieldSchema, FrontendException>(){

            public Schema.FieldSchema convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 20);
            }

            public Schema.FieldSchema convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 25);
            }

            public Schema.FieldSchema convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 10);
            }

            public Schema.FieldSchema convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 15);
            }

            public Schema.FieldSchema convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                LOG.warn("Converting type " + primitiveTypeName + " to bytearray");
                return new Schema.FieldSchema(fieldName, null, 50);
            }

            public Schema.FieldSchema convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                    return new Schema.FieldSchema(fieldName, null, 70);
                }
                return new Schema.FieldSchema(fieldName, null, 50);
            }

            public Schema.FieldSchema convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                return new Schema.FieldSchema(fieldName, null, 5);
            }

            public Schema.FieldSchema convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) throws FrontendException {
                if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
                    return new Schema.FieldSchema(fieldName, null, 55);
                }
                return new Schema.FieldSchema(fieldName, null, 50);
            }
        });
    }

    private Schema.FieldSchema getComplexFieldSchema(final String fieldName, Type parquetType) throws FrontendException {
        final GroupType parquetGroupType = parquetType.asGroupType();
        LogicalTypeAnnotation logicalTypeAnnotation = parquetGroupType.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation != null) {
            try {
                return (Schema.FieldSchema)logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Schema.FieldSchema>(){

                    public Optional<Schema.FieldSchema> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                        try {
                            if (parquetGroupType.getFieldCount() != 1 || parquetGroupType.getType(0).isPrimitive()) {
                                throw new SchemaConversionException("Invalid map type " + parquetGroupType);
                            }
                            GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                            if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED) || mapKeyValType.getLogicalTypeAnnotation() != null && !mapKeyValType.getLogicalTypeAnnotation().equals(LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance()) || mapKeyValType.getFieldCount() != 2) {
                                throw new SchemaConversionException("Invalid map type " + parquetGroupType);
                            }
                            Type valueType = mapKeyValType.getType(1);
                            Schema s = PigSchemaConverter.this.convertField(valueType);
                            s.getField((int)0).alias = null;
                            return Optional.of(new Schema.FieldSchema(fieldName, s, 100));
                        }
                        catch (FrontendException e) {
                            throw new FrontendExceptionWrapper(e);
                        }
                    }

                    public Optional<Schema.FieldSchema> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                        try {
                            Type type = parquetGroupType.getType(0);
                            if (parquetGroupType.getFieldCount() != 1 || type.isPrimitive()) {
                                Schema primitiveSchema = new Schema(PigSchemaConverter.this.getSimpleFieldSchema(parquetGroupType.getFieldName(0), type));
                                Schema tupleSchema = new Schema(new Schema.FieldSchema(PigSchemaConverter.ARRAY_VALUE_NAME, primitiveSchema, 110));
                                return Optional.of(new Schema.FieldSchema(fieldName, tupleSchema, 120));
                            }
                            GroupType tupleType = parquetGroupType.getType(0).asGroupType();
                            if (!tupleType.isRepetition(Type.Repetition.REPEATED)) {
                                throw new SchemaConversionException("Invalid list type " + parquetGroupType);
                            }
                            Schema tupleSchema = new Schema(new Schema.FieldSchema(tupleType.getName(), PigSchemaConverter.this.convertFields(tupleType.getFields()), 110));
                            return Optional.of(new Schema.FieldSchema(fieldName, tupleSchema, 120));
                        }
                        catch (FrontendException e) {
                            throw new FrontendExceptionWrapper(e);
                        }
                    }
                }).orElseThrow(() -> new SchemaConversionException("Unexpected original type for " + parquetType + ": " + logicalTypeAnnotation));
            }
            catch (FrontendExceptionWrapper e) {
                throw e.frontendException;
            }
        }
        return new Schema.FieldSchema(fieldName, this.convertFields(parquetGroupType.getFields()), 110);
    }

    private Schema.FieldSchema getFieldSchema(Type parquetType) throws FrontendException {
        String fieldName = parquetType.getName();
        if (parquetType.isPrimitive()) {
            return this.getSimpleFieldSchema(fieldName, parquetType);
        }
        return this.getComplexFieldSchema(fieldName, parquetType);
    }

    public MessageType convert(Schema pigSchema) {
        return new MessageType("pig_schema", this.convertTypes(pigSchema));
    }

    private Type[] convertTypes(Schema pigSchema) {
        List fields = pigSchema.getFields();
        Type[] types = new Type[fields.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.convert((Schema.FieldSchema)fields.get(i), i);
        }
        return types;
    }

    private Type convert(Schema.FieldSchema fieldSchema, String defaultAlias) {
        String name = this.name(fieldSchema.alias, defaultAlias);
        return this.convertWithName(fieldSchema, name);
    }

    private Type convertWithName(Schema.FieldSchema fieldSchema, String name) {
        try {
            switch (fieldSchema.type) {
                case 120: {
                    return this.convertBag(name, fieldSchema);
                }
                case 110: {
                    return this.convertTuple(name, fieldSchema, Type.Repetition.OPTIONAL);
                }
                case 100: {
                    return this.convertMap(name, fieldSchema);
                }
                case 5: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.BOOLEAN);
                }
                case 55: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
                }
                case 10: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.INT32);
                }
                case 15: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.INT64);
                }
                case 20: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.FLOAT);
                }
                case 25: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.DOUBLE);
                }
                case 30: {
                    throw new UnsupportedOperationException();
                }
                case 50: {
                    return this.primitive(name, PrimitiveType.PrimitiveTypeName.BINARY);
                }
            }
            throw new SchemaConversionException("Unknown type " + fieldSchema.type + " " + DataType.findTypeName((byte)fieldSchema.type));
        }
        catch (FrontendException e) {
            throw new SchemaConversionException("can't convert " + fieldSchema, e);
        }
    }

    private Type convert(Schema.FieldSchema fieldSchema, int index) {
        return this.convert(fieldSchema, "field_" + index);
    }

    private GroupType convertBag(String name, Schema.FieldSchema fieldSchema) throws FrontendException {
        Schema.FieldSchema innerField = fieldSchema.schema.getField(0);
        return ConversionPatterns.listType((Type.Repetition)Type.Repetition.OPTIONAL, (String)name, (Type)this.convertTuple(this.name(innerField.alias, "bag"), innerField, Type.Repetition.REPEATED));
    }

    private String name(String fieldAlias, String defaultName) {
        return fieldAlias == null ? defaultName : fieldAlias;
    }

    private Type primitive(String name, PrimitiveType.PrimitiveTypeName primitive, LogicalTypeAnnotation logicalTypeAnnotation) {
        return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)primitive, (Type.Repetition)Type.Repetition.OPTIONAL).as(logicalTypeAnnotation)).named(name);
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive) {
        return (PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)primitive, (Type.Repetition)Type.Repetition.OPTIONAL).named(name);
    }

    private GroupType convertMap(String alias, Schema.FieldSchema fieldSchema) {
        Schema innerSchema = fieldSchema.schema;
        if (innerSchema == null || innerSchema.size() != 1) {
            throw new SchemaConversionException("Invalid map Schema, schema should contain exactly one field: " + fieldSchema);
        }
        Schema.FieldSchema innerField = null;
        try {
            innerField = innerSchema.getField(0);
        }
        catch (FrontendException fe) {
            throw new SchemaConversionException("Invalid map schema, cannot infer innerschema: ", fe);
        }
        Type convertedValue = this.convertWithName(innerField, ARRAY_VALUE_NAME);
        return ConversionPatterns.stringKeyMapType((Type.Repetition)Type.Repetition.OPTIONAL, (String)alias, (String)this.name(innerField.alias, "map"), (Type)convertedValue);
    }

    private GroupType convertTuple(String alias, Schema.FieldSchema field, Type.Repetition repetition) {
        return new GroupType(repetition, alias, this.convertTypes(field.schema));
    }

    public MessageType filter(MessageType schemaToFilter, Schema requestedPigSchema) {
        return this.filter(schemaToFilter, requestedPigSchema, null);
    }

    public MessageType filter(MessageType schemaToFilter, Schema requestedPigSchema, LoadPushDown.RequiredFieldList requiredFieldList) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("filtering schema:\n" + schemaToFilter + "\nwith requested pig schema:\n " + requestedPigSchema);
            }
            List<Type> result = this.columnAccess.filterTupleSchema((GroupType)schemaToFilter, requestedPigSchema, requiredFieldList);
            if (LOG.isDebugEnabled()) {
                LOG.debug("schema:\n" + schemaToFilter + "\nfiltered to:\n" + result);
            }
            return new MessageType(schemaToFilter.getName(), result);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("can't filter " + schemaToFilter + " with " + requestedPigSchema, e);
        }
    }

    private Type filter(Type type, Schema.FieldSchema fieldSchema) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("filtering type:\n" + type + "\nwith:\n " + fieldSchema);
        }
        try {
            switch (fieldSchema.type) {
                case 120: {
                    return this.filterBag(type.asGroupType(), fieldSchema);
                }
                case 100: {
                    return this.filterMap(type.asGroupType(), fieldSchema);
                }
                case 110: {
                    return this.filterTuple(type.asGroupType(), fieldSchema);
                }
            }
            return type;
        }
        catch (FrontendException e) {
            throw new SchemaConversionException("can't filter " + type + " with " + fieldSchema, e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("can't filter " + type + " with " + fieldSchema, e);
        }
    }

    private Type filterTuple(GroupType tupleType, Schema.FieldSchema tupleFieldSchema) throws FrontendException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("filtering TUPLE schema:\n" + tupleType + "\nwith:\n " + tupleFieldSchema);
        }
        return tupleType.withNewFields(this.columnAccess.filterTupleSchema(tupleType, tupleFieldSchema.schema, null));
    }

    private Type filterMap(GroupType mapType, Schema.FieldSchema mapFieldSchema) throws FrontendException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("filtering MAP schema:\n" + mapType + "\nwith:\n " + mapFieldSchema);
        }
        if (mapType.getFieldCount() != 1) {
            throw new RuntimeException("not unwrapping the right type, this should be a Map: " + mapType);
        }
        GroupType nested = mapType.getType(0).asGroupType();
        if (nested.getFieldCount() != 2) {
            throw new RuntimeException("this should be a Map Key/Value: " + mapType);
        }
        Schema.FieldSchema innerField = mapFieldSchema.schema.getField(0);
        return mapType.withNewFields(new Type[]{nested.withNewFields(new Type[]{nested.getType(0), this.filter(nested.getType(1), innerField)})});
    }

    private Type filterBag(GroupType bagType, Schema.FieldSchema bagFieldSchema) throws FrontendException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("filtering BAG schema:\n" + bagType + "\nwith:\n " + bagFieldSchema);
        }
        if (bagType.getFieldCount() != 1) {
            throw new RuntimeException("not unwrapping the right type, this should be a Bag: " + bagType);
        }
        Type nested = bagType.getType(0);
        Schema.FieldSchema innerField = bagFieldSchema.schema.getField(0);
        if (nested.isPrimitive() || nested.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation || nested.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
            innerField = innerField.schema.getField(0);
        }
        return bagType.withNewFields(new Type[]{this.filter(nested, innerField)});
    }

    private static final class FrontendExceptionWrapper
    extends RuntimeException {
        final FrontendException frontendException;

        FrontendExceptionWrapper(FrontendException frontendException) {
            this.frontendException = frontendException;
        }
    }

    class ColumnNameAccess
    implements ColumnAccess {
        ColumnNameAccess() {
        }

        @Override
        public List<Type> filterTupleSchema(GroupType schemaToFilter, Schema requestedPigSchema, LoadPushDown.RequiredFieldList requiredFieldsList) {
            List fields = requestedPigSchema.getFields();
            ArrayList<Type> newFields = new ArrayList<Type>();
            for (int i = 0; i < fields.size(); ++i) {
                Schema.FieldSchema fieldSchema = (Schema.FieldSchema)fields.get(i);
                String name = PigSchemaConverter.this.name(fieldSchema.alias, "field_" + i);
                if (!schemaToFilter.containsField(name)) continue;
                newFields.add(PigSchemaConverter.this.filter(schemaToFilter.getType(name), fieldSchema));
            }
            return newFields;
        }
    }

    class ColumnIndexAccess
    implements ColumnAccess {
        ColumnIndexAccess() {
        }

        @Override
        public List<Type> filterTupleSchema(GroupType schemaToFilter, Schema pigSchema, LoadPushDown.RequiredFieldList requiredFieldsList) {
            ArrayList<Type> newFields = new ArrayList<Type>();
            ArrayList<Pair> indexedFields = new ArrayList<Pair>();
            try {
                if (requiredFieldsList == null) {
                    int index = 0;
                    for (Schema.FieldSchema fs : pigSchema.getFields()) {
                        indexedFields.add(new Pair((Object)fs, (Object)index++));
                    }
                } else {
                    for (LoadPushDown.RequiredField rf : requiredFieldsList.getFields()) {
                        indexedFields.add(new Pair((Object)pigSchema.getField(rf.getAlias()), (Object)rf.getIndex()));
                    }
                }
                for (Pair p : indexedFields) {
                    Schema.FieldSchema fieldSchema = pigSchema.getField(((Schema.FieldSchema)p.first).alias);
                    if ((Integer)p.second >= schemaToFilter.getFieldCount()) continue;
                    Type type = (Type)schemaToFilter.getFields().get((Integer)p.second);
                    newFields.add(PigSchemaConverter.this.filter(type, fieldSchema));
                }
            }
            catch (FrontendException e) {
                throw new RuntimeException("Failed to filter requested fields", e);
            }
            return newFields;
        }
    }

    static interface ColumnAccess {
        public List<Type> filterTupleSchema(GroupType var1, Schema var2, LoadPushDown.RequiredFieldList var3);
    }
}

