/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.parquet.io.api.Binary;

public class DecimalUtils {
    public static BigDecimal binaryToDecimal(Binary value, int precision, int scale) {
        if (precision <= 18) {
            ByteBuffer buffer = value.toByteBuffer();
            byte[] bytes = buffer.array();
            int start = buffer.arrayOffset() + buffer.position();
            int end = buffer.arrayOffset() + buffer.limit();
            long unscaled = 0L;
            for (int i = start; i < end; ++i) {
                unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
            }
            int bits = 8 * (end - start);
            long unscaledNew = unscaled << 64 - bits >> 64 - bits;
            if ((double)unscaledNew <= -Math.pow(10.0, 18.0) || (double)unscaledNew >= Math.pow(10.0, 18.0)) {
                return new BigDecimal(unscaledNew);
            }
            return BigDecimal.valueOf((double)unscaledNew / Math.pow(10.0, scale));
        }
        return new BigDecimal(new BigInteger(value.getBytes()), scale);
    }
}

