/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig.summary;

import java.util.Map;
import org.apache.parquet.pig.summary.BagSummaryData;
import org.apache.parquet.pig.summary.MapSummaryData;
import org.apache.parquet.pig.summary.NumberSummaryData;
import org.apache.parquet.pig.summary.StringSummaryData;
import org.apache.parquet.pig.summary.SummaryData;
import org.apache.parquet.pig.summary.TupleSummaryData;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class FieldSummaryData
extends SummaryData {
    private String name;
    private BagSummaryData bag;
    private TupleSummaryData tuple;
    private MapSummaryData map;
    private StringSummaryData string;
    private NumberSummaryData number;
    private long nullCount;
    private long unknown;
    private long error;

    @Override
    public void merge(SummaryData other) {
        super.merge(other);
        FieldSummaryData otherFieldSummaryData = (FieldSummaryData)other;
        if (otherFieldSummaryData.name != null) {
            this.setName(otherFieldSummaryData.name);
        }
        this.bag = FieldSummaryData.merge(this.bag, otherFieldSummaryData.bag);
        this.tuple = FieldSummaryData.merge(this.tuple, otherFieldSummaryData.tuple);
        this.map = FieldSummaryData.merge(this.map, otherFieldSummaryData.map);
        this.string = FieldSummaryData.merge(this.string, otherFieldSummaryData.string);
        this.number = FieldSummaryData.merge(this.number, otherFieldSummaryData.number);
        this.nullCount += otherFieldSummaryData.nullCount;
        this.unknown += otherFieldSummaryData.unknown;
        this.error += otherFieldSummaryData.error;
    }

    public void add(Schema schema, Object o) {
        super.add(o);
        if (o == null) {
            ++this.nullCount;
        } else if (o instanceof DataBag) {
            if (this.bag == null) {
                this.bag = new BagSummaryData();
            }
            this.bag.add(schema, (DataBag)o);
        } else if (o instanceof Tuple) {
            if (this.tuple == null) {
                this.tuple = new TupleSummaryData();
            }
            this.tuple.addTuple(schema, (Tuple)o);
        } else if (o instanceof Map) {
            if (this.map == null) {
                this.map = new MapSummaryData();
            }
            this.map.add(schema, (Map)o);
        } else if (o instanceof String) {
            if (this.string == null) {
                this.string = new StringSummaryData();
            }
            this.string.add((String)o);
        } else if (o instanceof Number) {
            if (this.number == null) {
                this.number = new NumberSummaryData();
            }
            this.number.add((Number)o);
        } else {
            ++this.unknown;
        }
    }

    public void addError() {
        ++this.error;
    }

    public BagSummaryData getBag() {
        return this.bag;
    }

    public void setBag(BagSummaryData bag) {
        this.bag = bag;
    }

    public TupleSummaryData getTuple() {
        return this.tuple;
    }

    public void setTuple(TupleSummaryData tuple) {
        this.tuple = tuple;
    }

    public MapSummaryData getMap() {
        return this.map;
    }

    public void setMap(MapSummaryData map) {
        this.map = map;
    }

    public StringSummaryData getString() {
        return this.string;
    }

    public void setString(StringSummaryData string) {
        this.string = string;
    }

    public NumberSummaryData getNumber() {
        return this.number;
    }

    public void setNumber(NumberSummaryData number) {
        this.number = number;
    }

    public Long getNull() {
        return this.nullCount == 0L ? null : Long.valueOf(this.nullCount);
    }

    public void setNull(long nullCnt) {
        this.nullCount = nullCnt;
    }

    public Long getUnknown() {
        return this.unknown == 0L ? null : Long.valueOf(this.unknown);
    }

    public void setUnknown(long unknown) {
        this.unknown = unknown;
    }

    public Long getError() {
        return this.error == 0L ? null : Long.valueOf(this.error);
    }

    public void setError(long error) {
        this.error = error;
    }

    public void setName(String name) {
        if (this.name != null && !this.name.equals(name)) {
            throw new IllegalStateException("name mismatch " + this.name + " expected, got " + name);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

