/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtoMessageConverter
extends GroupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoMessageConverter.class);
    protected final Configuration conf;
    protected final Converter[] converters;
    protected final ParentValueContainer parent;
    protected final Message.Builder myBuilder;
    protected final Map<String, String> extraMetadata;

    ProtoMessageConverter(Configuration conf, ParentValueContainer pvc, Class<? extends Message> protoClass, GroupType parquetSchema, Map<String, String> extraMetadata) {
        this(conf, pvc, Protobufs.getMessageBuilder(protoClass), parquetSchema, extraMetadata);
    }

    ProtoMessageConverter(Configuration conf, ParentValueContainer pvc, Message.Builder builder, GroupType parquetSchema, Map<String, String> extraMetadata) {
        int schemaSize = parquetSchema.getFieldCount();
        this.converters = new Converter[schemaSize];
        this.conf = conf;
        this.parent = pvc;
        this.extraMetadata = extraMetadata;
        int parquetFieldIndex = 1;
        if (pvc == null) {
            throw new IllegalStateException("Missing parent value container");
        }
        this.myBuilder = builder;
        Descriptors.Descriptor protoDescriptor = builder.getDescriptorForType();
        for (Type parquetField : parquetSchema.getFields()) {
            Descriptors.FieldDescriptor protoField = protoDescriptor.findFieldByName(parquetField.getName());
            if (protoField == null) {
                String description = "Scheme mismatch \n\"" + parquetField + "\"\n proto descriptor:\n" + protoDescriptor.toProto();
                throw new IncompatibleSchemaModificationException("Cant find \"" + parquetField.getName() + "\" " + description);
            }
            this.converters[parquetFieldIndex - 1] = this.newMessageConverter(this.myBuilder, protoField, parquetField);
            ++parquetFieldIndex;
        }
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
    }

    public void end() {
        this.parent.add(this.myBuilder.build());
        this.myBuilder.clear();
    }

    protected Converter newMessageConverter(final Message.Builder parentBuilder, final Descriptors.FieldDescriptor fieldDescriptor, final Type parquetType) {
        boolean isRepeated = fieldDescriptor.isRepeated();
        ParentValueContainer parent = isRepeated ? new ParentValueContainer(){

            @Override
            public void add(Object value) {
                parentBuilder.addRepeatedField(fieldDescriptor, value);
            }
        } : new ParentValueContainer(){

            @Override
            public void add(Object value) {
                parentBuilder.setField(fieldDescriptor, value);
            }
        };
        LogicalTypeAnnotation logicalTypeAnnotation = parquetType.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation == null) {
            return this.newScalarConverter(parent, parentBuilder, fieldDescriptor, parquetType);
        }
        return logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

            public Optional<Converter> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                return Optional.of(new ListConverter(parentBuilder, fieldDescriptor, parquetType));
            }

            public Optional<Converter> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                return Optional.of(new MapConverter(parentBuilder, fieldDescriptor, parquetType));
            }
        }).orElseGet(() -> this.newScalarConverter(parent, parentBuilder, fieldDescriptor, parquetType));
    }

    protected Converter newScalarConverter(ParentValueContainer pvc, Message.Builder parentBuilder, Descriptors.FieldDescriptor fieldDescriptor, Type parquetType) {
        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
        switch (javaType) {
            case STRING: {
                return new ProtoStringConverter(pvc);
            }
            case FLOAT: {
                return new ProtoFloatConverter(pvc);
            }
            case DOUBLE: {
                return new ProtoDoubleConverter(pvc);
            }
            case BOOLEAN: {
                return new ProtoBooleanConverter(pvc);
            }
            case BYTE_STRING: {
                return new ProtoBinaryConverter(pvc);
            }
            case ENUM: {
                return new ProtoEnumConverter(pvc, fieldDescriptor);
            }
            case INT: {
                return new ProtoIntConverter(pvc);
            }
            case LONG: {
                return new ProtoLongConverter(pvc);
            }
            case MESSAGE: {
                Message.Builder subBuilder = parentBuilder.newBuilderForField(fieldDescriptor);
                return new ProtoMessageConverter(this.conf, pvc, subBuilder, parquetType.asGroupType(), this.extraMetadata);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert type: %s (Parquet type: %s) ", javaType, parquetType));
    }

    public Message.Builder getBuilder() {
        return this.myBuilder;
    }

    final class MapConverter
    extends GroupConverter {
        private final Converter converter;

        public MapConverter(Message.Builder parentBuilder, Descriptors.FieldDescriptor fieldDescriptor, Type parquetType) {
            LogicalTypeAnnotation logicalTypeAnnotation = parquetType.getLogicalTypeAnnotation();
            if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation)) {
                throw new ParquetDecodingException("Expected MAP wrapper. Found: " + logicalTypeAnnotation + " instead.");
            }
            if (!parquetType.asGroupType().containsField("key_value")) {
                throw new ParquetDecodingException("Expected map but got: " + parquetType);
            }
            Type parquetSchema = parquetType.asGroupType().getType("key_value");
            this.converter = ProtoMessageConverter.this.newMessageConverter(parentBuilder, fieldDescriptor, parquetSchema);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex > 0) {
                throw new ParquetDecodingException("Unexpected multiple fields in the MAP wrapper");
            }
            return this.converter;
        }

        public void start() {
        }

        public void end() {
        }
    }

    final class ListConverter
    extends GroupConverter {
        private final Converter converter;

        public ListConverter(Message.Builder parentBuilder, Descriptors.FieldDescriptor fieldDescriptor, Type parquetType) {
            LogicalTypeAnnotation logicalTypeAnnotation = parquetType.getLogicalTypeAnnotation();
            if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) || parquetType.isPrimitive()) {
                throw new ParquetDecodingException("Expected LIST wrapper. Found: " + logicalTypeAnnotation + " instead.");
            }
            GroupType rootWrapperType = parquetType.asGroupType();
            if (!rootWrapperType.containsField("list") || rootWrapperType.getType("list").isPrimitive()) {
                throw new ParquetDecodingException("Expected repeated 'list' group inside LIST wrapperr but got: " + rootWrapperType);
            }
            GroupType listType = rootWrapperType.getType("list").asGroupType();
            if (!listType.containsField("element")) {
                throw new ParquetDecodingException("Expected 'element' inside repeated list group but got: " + listType);
            }
            Type elementType = listType.getType("element");
            this.converter = ProtoMessageConverter.this.newMessageConverter(parentBuilder, fieldDescriptor, elementType);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex > 0) {
                throw new ParquetDecodingException("Unexpected multiple fields in the LIST wrapper");
            }
            return new GroupConverter(){

                public Converter getConverter(int fieldIndex) {
                    return ListConverter.this.converter;
                }

                public void start() {
                }

                public void end() {
                }
            };
        }

        public void start() {
        }

        public void end() {
        }
    }

    final class ProtoStringConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoStringConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBinary(Binary binary) {
            String str = binary.toStringUsingUTF8();
            this.parent.add(str);
        }
    }

    final class ProtoLongConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoLongConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addLong(long value) {
            this.parent.add(value);
        }
    }

    final class ProtoIntConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoIntConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addInt(int value) {
            this.parent.add(value);
        }
    }

    final class ProtoFloatConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoFloatConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addFloat(float value) {
            this.parent.add(Float.valueOf(value));
        }
    }

    final class ProtoDoubleConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoDoubleConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addDouble(double value) {
            this.parent.add(value);
        }
    }

    final class ProtoBooleanConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoBooleanConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addBoolean(boolean value) {
            this.parent.add(value);
        }
    }

    final class ProtoBinaryConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoBinaryConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBinary(Binary binary) {
            ByteString byteString = ByteString.copyFrom((ByteBuffer)binary.toByteBuffer());
            this.parent.add(byteString);
        }
    }

    final class ProtoEnumConverter
    extends PrimitiveConverter {
        private final Descriptors.FieldDescriptor fieldType;
        private final Map<Binary, Descriptors.EnumValueDescriptor> enumLookup;
        private Descriptors.EnumValueDescriptor[] dict;
        private final ParentValueContainer parent;
        private final Descriptors.EnumDescriptor enumType;
        private final String unknownEnumPrefix;
        private final boolean acceptUnknownEnum;

        public ProtoEnumConverter(ParentValueContainer parent, Descriptors.FieldDescriptor fieldType) {
            this.parent = parent;
            this.fieldType = fieldType;
            this.enumType = fieldType.getEnumType();
            this.enumLookup = this.makeLookupStructure(this.enumType);
            this.unknownEnumPrefix = "UNKNOWN_ENUM_VALUE_" + this.enumType.getName() + "_";
            this.acceptUnknownEnum = ProtoMessageConverter.this.conf.getBoolean("parquet.proto.accept.unknown.enum", false);
        }

        private Map<Binary, Descriptors.EnumValueDescriptor> makeLookupStructure(Descriptors.EnumDescriptor enumType) {
            HashMap<Binary, Descriptors.EnumValueDescriptor> lookupStructure = new HashMap<Binary, Descriptors.EnumValueDescriptor>();
            if (ProtoMessageConverter.this.extraMetadata.containsKey("parquet.proto.enum." + enumType.getFullName())) {
                String enumNameNumberPairs = ProtoMessageConverter.this.extraMetadata.get("parquet.proto.enum." + enumType.getFullName());
                if (enumNameNumberPairs == null || enumNameNumberPairs.trim().isEmpty()) {
                    LOG.debug("No enum is written for " + enumType.getFullName());
                    return lookupStructure;
                }
                for (String enumItem : enumNameNumberPairs.split(",")) {
                    String[] nameAndNumber = enumItem.split(":");
                    if (nameAndNumber.length != 2) {
                        throw new BadConfigurationException("Invalid enum bookkeeper from the metadata: " + enumNameNumberPairs);
                    }
                    lookupStructure.put(Binary.fromString((String)nameAndNumber[0]), enumType.findValueByNumberCreatingIfUnknown(Integer.parseInt(nameAndNumber[1])));
                }
            } else {
                List enumValues = enumType.getValues();
                for (Descriptors.EnumValueDescriptor value : enumValues) {
                    String name = value.getName();
                    lookupStructure.put(Binary.fromString((String)name), enumType.findValueByName(name));
                }
            }
            return lookupStructure;
        }

        private Descriptors.EnumValueDescriptor translateEnumValue(Binary binaryValue) {
            Descriptors.EnumValueDescriptor protoValue = this.enumLookup.get(binaryValue);
            if (protoValue == null) {
                String unknownLabel = binaryValue.toStringUsingUTF8();
                if (unknownLabel.startsWith(this.unknownEnumPrefix)) {
                    try {
                        int i = Integer.parseInt(unknownLabel.substring(this.unknownEnumPrefix.length()));
                        Descriptors.EnumValueDescriptor unknownEnumValue = this.enumType.findValueByNumberCreatingIfUnknown(i);
                        this.enumLookup.put(binaryValue, unknownEnumValue);
                        return unknownEnumValue;
                    }
                    catch (NumberFormatException i) {
                        // empty catch block
                    }
                }
                if (!this.acceptUnknownEnum) {
                    Set<Binary> knownValues = this.enumLookup.keySet();
                    String msg = "Illegal enum value \"" + binaryValue + "\" in protocol buffer \"" + this.fieldType.getFullName() + "\" legal values are: \"" + knownValues + "\"";
                    throw new InvalidRecordException(msg);
                }
                LOG.error("Found unknown value " + unknownLabel + " for field " + this.fieldType.getFullName() + " probably because your proto schema is outdated, accept it as unknown enum with number -1");
                Descriptors.EnumValueDescriptor unrecognized = this.enumType.findValueByNumberCreatingIfUnknown(-1);
                this.enumLookup.put(binaryValue, unrecognized);
                return unrecognized;
            }
            return protoValue;
        }

        public final void addBinary(Binary binaryValue) {
            Descriptors.EnumValueDescriptor protoValue = this.translateEnumValue(binaryValue);
            this.parent.add(protoValue);
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.add(this.dict[dictionaryId]);
        }

        public boolean hasDictionarySupport() {
            return true;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new Descriptors.EnumValueDescriptor[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                Binary binaryValue = dictionary.decodeToBinary(i);
                this.dict[i] = this.translateEnumValue(binaryValue);
            }
        }
    }

    static abstract class ParentValueContainer {
        ParentValueContainer() {
        }

        public abstract void add(Object var1);
    }
}

