/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.proto.ProtoRecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoReadSupport<T extends Message>
extends ReadSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoReadSupport.class);
    public static final String PB_REQUESTED_PROJECTION = "parquet.proto.projection";
    public static final String PB_CLASS = "parquet.proto.class";
    public static final String PB_DESCRIPTOR = "parquet.proto.descriptor";

    public static void setRequestedProjection(Configuration configuration, String requestedProjection) {
        configuration.set(PB_REQUESTED_PROJECTION, requestedProjection);
    }

    public static void setProtobufClass(Configuration configuration, String protobufClass) {
        configuration.set(PB_CLASS, protobufClass);
    }

    public ReadSupport.ReadContext init(InitContext context) {
        String requestedProjectionString = context.getParquetConfiguration().get(PB_REQUESTED_PROJECTION);
        if (requestedProjectionString != null && !requestedProjectionString.trim().isEmpty()) {
            MessageType requestedProjection = ProtoReadSupport.getSchemaForRead((MessageType)context.getFileSchema(), (String)requestedProjectionString);
            LOG.debug("Reading data with projection {}", (Object)requestedProjection);
            return new ReadSupport.ReadContext(requestedProjection);
        }
        MessageType fileSchema = context.getFileSchema();
        LOG.debug("Reading data with schema {}", (Object)fileSchema);
        return new ReadSupport.ReadContext(fileSchema);
    }

    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return this.prepareForRead((ParquetConfiguration)new HadoopParquetConfiguration(configuration), keyValueMetaData, fileSchema, readContext);
    }

    public RecordMaterializer<T> prepareForRead(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        String headerProtoClass = keyValueMetaData.get(PB_CLASS);
        String configuredProtoClass = configuration.get(PB_CLASS);
        if (configuredProtoClass != null) {
            LOG.debug("Replacing class " + headerProtoClass + " by " + configuredProtoClass);
            headerProtoClass = configuredProtoClass;
        }
        if (headerProtoClass == null) {
            throw new RuntimeException("I Need parameter parquet.proto.class with Protocol Buffer class");
        }
        LOG.debug("Reading data with Protocol Buffer class {}", (Object)headerProtoClass);
        MessageType requestedSchema = readContext.getRequestedSchema();
        Class protobufClass = Protobufs.getProtobufClass((String)headerProtoClass);
        return new ProtoRecordMaterializer(configuration, requestedSchema, (Class<? extends Message>)protobufClass, keyValueMetaData);
    }
}

