/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.type.Date;
import com.google.type.TimeOfDay;
import com.twitter.elephantbird.util.Protobufs;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoSchemaConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoSchemaConverter.class);
    public static final String PB_MAX_RECURSION = "parquet.proto.maxRecursion";
    private final boolean parquetSpecsCompliant;
    private final boolean unwrapProtoWrappers;
    private final int maxRecursion;

    public ProtoSchemaConverter() {
        this(false);
    }

    public ProtoSchemaConverter(boolean parquetSpecsCompliant) {
        this(parquetSpecsCompliant, 5, false);
    }

    public ProtoSchemaConverter(Configuration config) {
        this((ParquetConfiguration)new HadoopParquetConfiguration(config));
    }

    public ProtoSchemaConverter(ParquetConfiguration config) {
        this(config.getBoolean("parquet.proto.writeSpecsCompliant", false), config.getInt(PB_MAX_RECURSION, 5), config.getBoolean("parquet.proto.unwrapProtoWrappers", false));
    }

    public ProtoSchemaConverter(boolean parquetSpecsCompliant, int maxRecursion) {
        this(parquetSpecsCompliant, maxRecursion, false);
    }

    public ProtoSchemaConverter(boolean parquetSpecsCompliant, int maxRecursion, boolean unwrapProtoWrappers) {
        this.parquetSpecsCompliant = parquetSpecsCompliant;
        this.maxRecursion = maxRecursion;
        this.unwrapProtoWrappers = unwrapProtoWrappers;
    }

    public static void setMaxRecursion(Configuration config, int maxRecursion) {
        config.setInt(PB_MAX_RECURSION, maxRecursion);
    }

    public MessageType convert(Descriptors.Descriptor descriptor) {
        int depth = 0;
        ImmutableSetMultimap seen = ImmutableSetMultimap.of((Object)descriptor.getFullName(), (Object)depth);
        LOG.trace("convert:\n{}", (Object)descriptor.toProto());
        MessageType messageType = (MessageType)this.convertFields((Types.GroupBuilder)Types.buildMessage(), descriptor.getFields(), (ImmutableSetMultimap<String, Integer>)seen, depth).named(descriptor.getFullName());
        LOG.debug("Converter info:\n{}\n  was converted to:\n{}", (Object)descriptor.toProto(), (Object)messageType);
        return messageType;
    }

    public MessageType convert(Class<? extends Message> protobufClass) {
        LOG.debug("Converting protocol buffer class \"{}\" to parquet schema", protobufClass);
        Descriptors.Descriptor descriptor = Protobufs.getMessageDescriptor(protobufClass);
        return this.convert(descriptor);
    }

    private <T> Types.GroupBuilder<T> convertFields(Types.GroupBuilder<T> groupBuilder, List<Descriptors.FieldDescriptor> fieldDescriptors, ImmutableSetMultimap<String, Integer> seen, int depth) {
        for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
            groupBuilder = (Types.GroupBuilder)this.addField(fieldDescriptor, groupBuilder, seen, depth).id(fieldDescriptor.getNumber()).named(fieldDescriptor.getName());
        }
        return groupBuilder;
    }

    private static Type.Repetition getRepetition(Descriptors.FieldDescriptor descriptor) {
        if (descriptor.isRequired()) {
            return Type.Repetition.REQUIRED;
        }
        if (descriptor.isRepeated()) {
            return Type.Repetition.REPEATED;
        }
        return Type.Repetition.OPTIONAL;
    }

    private <T> Types.Builder<? extends Types.Builder<?, Types.GroupBuilder<T>>, Types.GroupBuilder<T>> addField(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder, ImmutableSetMultimap<String, Integer> seen, int depth) {
        if (descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            if (this.unwrapProtoWrappers) {
                Descriptors.Descriptor messageType = descriptor.getMessageType();
                if (messageType.equals(Timestamp.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.INT64, ProtoSchemaConverter.getRepetition(descriptor)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
                }
                if (messageType.equals(Date.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.INT32, ProtoSchemaConverter.getRepetition(descriptor)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
                }
                if (messageType.equals(TimeOfDay.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.INT64, ProtoSchemaConverter.getRepetition(descriptor)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
                }
                if (messageType.equals(DoubleValue.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, ProtoSchemaConverter.getRepetition(descriptor));
                }
                if (messageType.equals(StringValue.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.BINARY, ProtoSchemaConverter.getRepetition(descriptor)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
                }
                if (messageType.equals(BoolValue.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, ProtoSchemaConverter.getRepetition(descriptor));
                }
                if (messageType.equals(FloatValue.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, ProtoSchemaConverter.getRepetition(descriptor));
                }
                if (messageType.equals(Int64Value.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.INT64, ProtoSchemaConverter.getRepetition(descriptor));
                }
                if (messageType.equals(UInt64Value.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.INT64, ProtoSchemaConverter.getRepetition(descriptor));
                }
                if (messageType.equals(Int32Value.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.INT32, ProtoSchemaConverter.getRepetition(descriptor));
                }
                if (messageType.equals(UInt32Value.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.INT64, ProtoSchemaConverter.getRepetition(descriptor));
                }
                if (messageType.equals(BytesValue.getDescriptor())) {
                    return builder.primitive(PrimitiveType.PrimitiveTypeName.BINARY, ProtoSchemaConverter.getRepetition(descriptor));
                }
            }
            return this.addMessageField(descriptor, builder, seen, depth);
        }
        ParquetType parquetType = ProtoSchemaConverter.getParquetType(descriptor);
        if (descriptor.isRepeated() && this.parquetSpecsCompliant) {
            return ProtoSchemaConverter.addRepeatedPrimitive(parquetType.primitiveType, parquetType.logicalTypeAnnotation, builder);
        }
        Type.Repetition repetition = this.unwrapProtoWrappers ? Type.Repetition.REQUIRED : ProtoSchemaConverter.getRepetition(descriptor);
        return builder.primitive(parquetType.primitiveType, repetition).as(parquetType.logicalTypeAnnotation);
    }

    private static <T> Types.Builder<? extends Types.Builder<?, Types.GroupBuilder<T>>, Types.GroupBuilder<T>> addRepeatedPrimitive(PrimitiveType.PrimitiveTypeName primitiveType, LogicalTypeAnnotation logicalTypeAnnotation, Types.GroupBuilder<T> builder) {
        return (Types.Builder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)builder.group(Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).group(Type.Repetition.REPEATED).primitive(primitiveType, Type.Repetition.REQUIRED).as(logicalTypeAnnotation)).named("element")).named("list");
    }

    private <T> Types.GroupBuilder<Types.GroupBuilder<T>> addRepeatedMessage(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder, ImmutableSetMultimap<String, Integer> seen, int depth) {
        Types.GroupBuilder result = ((Types.GroupBuilder)builder.group(Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).group(Type.Repetition.REPEATED).group(Type.Repetition.OPTIONAL);
        this.convertFields(result, descriptor.getMessageType().getFields(), seen, depth);
        return (Types.GroupBuilder)((Types.GroupBuilder)result.named("element")).named("list");
    }

    private <T> Types.Builder<? extends Types.Builder<?, Types.GroupBuilder<T>>, Types.GroupBuilder<T>> addMessageField(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder, ImmutableSetMultimap<String, Integer> seen, int depth) {
        String typeName = this.getInnerTypeName(descriptor);
        LOG.trace("addMessageField: {} type: {} depth: {}", new Object[]{descriptor.getFullName(), typeName, ++depth});
        if (typeName != null && seen.get((Object)typeName).size() > this.maxRecursion) {
            return builder.primitive(PrimitiveType.PrimitiveTypeName.BINARY, Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)null);
        }
        if (descriptor.isMapField() && this.parquetSpecsCompliant) {
            return this.addMapField(descriptor, builder, seen, depth);
        }
        seen = ImmutableSetMultimap.builder().putAll(seen).put((Object)typeName, (Object)depth).build();
        if (descriptor.isRepeated() && this.parquetSpecsCompliant) {
            return this.addRepeatedMessage(descriptor, builder, (ImmutableSetMultimap<String, Integer>)seen, depth);
        }
        Types.GroupBuilder group = builder.group(ProtoSchemaConverter.getRepetition(descriptor));
        this.convertFields(group, descriptor.getMessageType().getFields(), (ImmutableSetMultimap<String, Integer>)seen, depth);
        return group;
    }

    @Nullable
    private String getInnerTypeName(Descriptors.FieldDescriptor descriptor) {
        if (descriptor.isMapField() && this.parquetSpecsCompliant) {
            descriptor = (Descriptors.FieldDescriptor)descriptor.getMessageType().getFields().get(1);
        }
        if (descriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            LOG.trace("getInnerTypeName: {} => primitive", (Object)descriptor.getFullName());
            return null;
        }
        String name = descriptor.getMessageType().getFullName();
        LOG.trace("getInnerTypeName: {} => {}", (Object)descriptor.getFullName(), (Object)name);
        return name;
    }

    private <T> Types.GroupBuilder<Types.GroupBuilder<T>> addMapField(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder, ImmutableSetMultimap<String, Integer> seen, int depth) {
        List fields = descriptor.getMessageType().getFields();
        if (fields.size() != 2) {
            throw new UnsupportedOperationException("Expected two fields for the map (key/value), but got: " + fields);
        }
        ParquetType mapKeyParquetType = ProtoSchemaConverter.getParquetType((Descriptors.FieldDescriptor)fields.get(0));
        Types.GroupBuilder group = (Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)builder.group(Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).group(Type.Repetition.REPEATED).primitive(mapKeyParquetType.primitiveType, Type.Repetition.REQUIRED).as(mapKeyParquetType.logicalTypeAnnotation)).named("key");
        return (Types.GroupBuilder)((Types.GroupBuilder)this.addField((Descriptors.FieldDescriptor)fields.get(1), group, seen, depth).named("value")).named("key_value");
    }

    private static ParquetType getParquetType(Descriptors.FieldDescriptor fieldDescriptor) {
        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
        switch (javaType) {
            case INT: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.INT32);
            }
            case LONG: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.INT64);
            }
            case DOUBLE: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.DOUBLE);
            }
            case BOOLEAN: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.BOOLEAN);
            }
            case FLOAT: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.FLOAT);
            }
            case STRING: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
            }
            case ENUM: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.enumType());
            }
            case BYTE_STRING: {
                return ParquetType.of(PrimitiveType.PrimitiveTypeName.BINARY);
            }
        }
        throw new UnsupportedOperationException("Cannot convert Protocol Buffer: unknown type " + javaType);
    }

    private static class ParquetType {
        PrimitiveType.PrimitiveTypeName primitiveType;
        LogicalTypeAnnotation logicalTypeAnnotation;

        private ParquetType(PrimitiveType.PrimitiveTypeName primitiveType, LogicalTypeAnnotation logicalTypeAnnotation) {
            this.primitiveType = primitiveType;
            this.logicalTypeAnnotation = logicalTypeAnnotation;
        }

        public static ParquetType of(PrimitiveType.PrimitiveTypeName primitiveType, LogicalTypeAnnotation logicalTypeAnnotation) {
            return new ParquetType(primitiveType, logicalTypeAnnotation);
        }

        public static ParquetType of(PrimitiveType.PrimitiveTypeName primitiveType) {
            return ParquetType.of(primitiveType, null);
        }
    }
}

