/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.util.Timestamps;
import com.google.type.Date;
import com.google.type.TimeOfDay;
import com.twitter.elephantbird.util.Protobufs;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtoMessageConverter
extends GroupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoMessageConverter.class);
    private static final ParentValueContainer DUMMY_PVC = new ParentValueContainer(){

        @Override
        public void add(Object value) {
        }
    };
    protected final ParquetConfiguration conf;
    protected final Converter[] converters;
    protected final ParentValueContainer parent;
    protected final Message.Builder myBuilder;
    protected final Map<String, String> extraMetadata;

    ProtoMessageConverter(Configuration conf, ParentValueContainer pvc, Class<? extends Message> protoClass, GroupType parquetSchema, Map<String, String> extraMetadata) {
        this(conf, pvc, Protobufs.getMessageBuilder(protoClass), parquetSchema, extraMetadata);
    }

    ProtoMessageConverter(ParquetConfiguration conf, ParentValueContainer pvc, Class<? extends Message> protoClass, GroupType parquetSchema, Map<String, String> extraMetadata) {
        this(conf, pvc, Protobufs.getMessageBuilder(protoClass), parquetSchema, extraMetadata);
    }

    ProtoMessageConverter(Configuration conf, ParentValueContainer pvc, Message.Builder builder, GroupType parquetSchema, Map<String, String> extraMetadata) {
        this((ParquetConfiguration)new HadoopParquetConfiguration(conf), pvc, builder, parquetSchema, extraMetadata);
    }

    ProtoMessageConverter(ParquetConfiguration conf, ParentValueContainer pvc, Message.Builder builder, GroupType parquetSchema, Map<String, String> extraMetadata) {
        if (pvc == null) {
            throw new IllegalStateException("Missing parent value container");
        }
        int schemaSize = parquetSchema.getFieldCount();
        this.converters = new Converter[schemaSize];
        this.conf = conf;
        this.parent = pvc;
        this.extraMetadata = extraMetadata;
        boolean ignoreUnknownFields = conf.getBoolean("parquet.proto.ignore.unknown.fields", false);
        this.myBuilder = builder;
        if (builder == null && ignoreUnknownFields) {
            IntStream.range(0, parquetSchema.getFieldCount()).forEach(i -> {
                this.converters[i] = this.dummyScalarConverter(DUMMY_PVC, parquetSchema.getType(i), conf, extraMetadata);
            });
        } else {
            int parquetFieldIndex = 0;
            Descriptors.Descriptor protoDescriptor = builder.getDescriptorForType();
            for (Type parquetField : parquetSchema.getFields()) {
                Descriptors.FieldDescriptor protoField = protoDescriptor.findFieldByName(parquetField.getName());
                this.validateProtoField(ignoreUnknownFields, protoDescriptor.toProto(), parquetField, protoField);
                this.converters[parquetFieldIndex] = protoField != null ? this.newMessageConverter(this.myBuilder, protoField, parquetField) : this.dummyScalarConverter(DUMMY_PVC, parquetField, conf, extraMetadata);
                ++parquetFieldIndex;
            }
        }
    }

    private void validateProtoField(boolean ignoreUnknownFields, DescriptorProtos.DescriptorProto protoDescriptor, Type parquetField, Descriptors.FieldDescriptor protoField) {
        if (protoField == null && !ignoreUnknownFields) {
            String description = "Schema mismatch \n\"" + parquetField + "\"\n proto descriptor:\n" + protoDescriptor;
            throw new IncompatibleSchemaModificationException("Cant find \"" + parquetField.getName() + "\" " + description);
        }
    }

    private Converter dummyScalarConverter(ParentValueContainer pvc, Type parquetField, Configuration conf, Map<String, String> extraMetadata) {
        return this.dummyScalarConverter(pvc, parquetField, (ParquetConfiguration)new HadoopParquetConfiguration(conf), extraMetadata);
    }

    private Converter dummyScalarConverter(ParentValueContainer pvc, Type parquetField, ParquetConfiguration conf, Map<String, String> extraMetadata) {
        if (parquetField.isPrimitive()) {
            PrimitiveType primitiveType = parquetField.asPrimitiveType();
            PrimitiveType.PrimitiveTypeName primitiveTypeName = primitiveType.getPrimitiveTypeName();
            switch (primitiveTypeName) {
                case BINARY: {
                    return new ProtoBinaryConverter(pvc);
                }
                case FLOAT: {
                    return new ProtoFloatConverter(pvc);
                }
                case DOUBLE: {
                    return new ProtoDoubleConverter(pvc);
                }
                case BOOLEAN: {
                    return new ProtoBooleanConverter(pvc);
                }
                case INT32: {
                    return new ProtoIntConverter(pvc);
                }
                case INT64: {
                    return new ProtoLongConverter(pvc);
                }
                case INT96: {
                    return new ProtoStringConverter(pvc);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    return new ProtoBinaryConverter(pvc);
                }
            }
            throw new UnsupportedOperationException(String.format("Cannot convert Parquet type: %s", parquetField));
        }
        return new ProtoMessageConverter(conf, pvc, (Message.Builder)null, parquetField.asGroupType(), extraMetadata);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
    }

    public void end() {
        if (this.myBuilder != null) {
            this.parent.add(this.myBuilder.build());
            this.myBuilder.clear();
        }
    }

    protected Converter newMessageConverter(final Message.Builder parentBuilder, final Descriptors.FieldDescriptor fieldDescriptor, final Type parquetType) {
        boolean isRepeated = fieldDescriptor != null && fieldDescriptor.isRepeated();
        final ParentValueContainer parent = isRepeated ? new ParentValueContainer(){

            @Override
            public void add(Object value) {
                parentBuilder.addRepeatedField(fieldDescriptor, value);
            }
        } : new ParentValueContainer(){

            @Override
            public void add(Object value) {
                parentBuilder.setField(fieldDescriptor, value);
            }
        };
        LogicalTypeAnnotation logicalTypeAnnotation = parquetType.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation == null) {
            return this.newScalarConverter(parent, parentBuilder, fieldDescriptor, parquetType);
        }
        return logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

            public Optional<Converter> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                return Optional.of(new ListConverter(parentBuilder, fieldDescriptor, parquetType));
            }

            public Optional<Converter> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                return Optional.of(new MapConverter(parentBuilder, fieldDescriptor, parquetType));
            }

            public Optional<Converter> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                return Optional.of(new ProtoTimestampConverter(parent, timestampLogicalType));
            }

            public Optional<Converter> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                return Optional.of(new ProtoDateConverter(parent));
            }

            public Optional<Converter> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                return Optional.of(new ProtoTimeConverter(parent, timeLogicalType));
            }
        }).orElseGet(() -> this.newScalarConverter(parent, parentBuilder, fieldDescriptor, parquetType));
    }

    protected Converter newScalarConverter(ParentValueContainer pvc, Message.Builder parentBuilder, Descriptors.FieldDescriptor fieldDescriptor, Type parquetType) {
        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
        switch (javaType) {
            case STRING: {
                return new ProtoStringConverter(pvc);
            }
            case FLOAT: {
                return new ProtoFloatConverter(pvc);
            }
            case DOUBLE: {
                return new ProtoDoubleConverter(pvc);
            }
            case BOOLEAN: {
                return new ProtoBooleanConverter(pvc);
            }
            case BYTE_STRING: {
                return new ProtoBinaryConverter(pvc);
            }
            case ENUM: {
                return new ProtoEnumConverter(pvc, fieldDescriptor);
            }
            case INT: {
                return new ProtoIntConverter(pvc);
            }
            case LONG: {
                return new ProtoLongConverter(pvc);
            }
            case MESSAGE: {
                if (parquetType.isPrimitive()) {
                    Descriptors.Descriptor messageType = fieldDescriptor.getMessageType();
                    if (messageType.equals(DoubleValue.getDescriptor())) {
                        return new ProtoDoubleValueConverter(pvc);
                    }
                    if (messageType.equals(FloatValue.getDescriptor())) {
                        return new ProtoFloatValueConverter(pvc);
                    }
                    if (messageType.equals(Int64Value.getDescriptor())) {
                        return new ProtoInt64ValueConverter(pvc);
                    }
                    if (messageType.equals(UInt64Value.getDescriptor())) {
                        return new ProtoUInt64ValueConverter(pvc);
                    }
                    if (messageType.equals(Int32Value.getDescriptor())) {
                        return new ProtoInt32ValueConverter(pvc);
                    }
                    if (messageType.equals(UInt32Value.getDescriptor())) {
                        return new ProtoUInt32ValueConverter(pvc);
                    }
                    if (messageType.equals(BoolValue.getDescriptor())) {
                        return new ProtoBoolValueConverter(pvc);
                    }
                    if (messageType.equals(StringValue.getDescriptor())) {
                        return new ProtoStringValueConverter(pvc);
                    }
                    if (messageType.equals(BytesValue.getDescriptor())) {
                        return new ProtoBytesValueConverter(pvc);
                    }
                }
                Message.Builder subBuilder = parentBuilder.newBuilderForField(fieldDescriptor);
                return new ProtoMessageConverter(this.conf, pvc, subBuilder, parquetType.asGroupType(), this.extraMetadata);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert type: %s (Parquet type: %s) ", javaType, parquetType));
    }

    public Message.Builder getBuilder() {
        return this.myBuilder;
    }

    final class MapConverter
    extends GroupConverter {
        private final Converter converter;

        public MapConverter(Message.Builder parentBuilder, Descriptors.FieldDescriptor fieldDescriptor, Type parquetType) {
            LogicalTypeAnnotation logicalTypeAnnotation = parquetType.getLogicalTypeAnnotation();
            if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation)) {
                throw new ParquetDecodingException("Expected MAP wrapper. Found: " + logicalTypeAnnotation + " instead.");
            }
            if (!parquetType.asGroupType().containsField("key_value")) {
                throw new ParquetDecodingException("Expected map but got: " + parquetType);
            }
            Type parquetSchema = parquetType.asGroupType().getType("key_value");
            this.converter = ProtoMessageConverter.this.newMessageConverter(parentBuilder, fieldDescriptor, parquetSchema);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex > 0) {
                throw new ParquetDecodingException("Unexpected multiple fields in the MAP wrapper");
            }
            return this.converter;
        }

        public void start() {
        }

        public void end() {
        }
    }

    final class ListConverter
    extends GroupConverter {
        private final Converter converter;

        public ListConverter(Message.Builder parentBuilder, Descriptors.FieldDescriptor fieldDescriptor, Type parquetType) {
            LogicalTypeAnnotation logicalTypeAnnotation = parquetType.getLogicalTypeAnnotation();
            if (!(logicalTypeAnnotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) || parquetType.isPrimitive()) {
                throw new ParquetDecodingException("Expected LIST wrapper. Found: " + logicalTypeAnnotation + " instead.");
            }
            GroupType rootWrapperType = parquetType.asGroupType();
            if (!rootWrapperType.containsField("list") || rootWrapperType.getType("list").isPrimitive()) {
                throw new ParquetDecodingException("Expected repeated 'list' group inside LIST wrapperr but got: " + rootWrapperType);
            }
            GroupType listType = rootWrapperType.getType("list").asGroupType();
            if (!listType.containsField("element")) {
                throw new ParquetDecodingException("Expected 'element' inside repeated list group but got: " + listType);
            }
            Type elementType = listType.getType("element");
            this.converter = ProtoMessageConverter.this.newMessageConverter(parentBuilder, fieldDescriptor, elementType);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex > 0) {
                throw new ParquetDecodingException("Unexpected multiple fields in the LIST wrapper");
            }
            return new GroupConverter(){

                public Converter getConverter(int fieldIndex) {
                    return ListConverter.this.converter;
                }

                public void start() {
                }

                public void end() {
                }
            };
        }

        public void start() {
        }

        public void end() {
        }
    }

    static final class ProtoBytesValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoBytesValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBinary(Binary binary) {
            ByteString byteString = ByteString.copyFrom((ByteBuffer)binary.toByteBuffer());
            this.parent.add(BytesValue.of((ByteString)byteString));
        }
    }

    static final class ProtoStringValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoStringValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBinary(Binary binary) {
            String str = binary.toStringUsingUTF8();
            this.parent.add(StringValue.of((String)str));
        }
    }

    static final class ProtoBoolValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoBoolValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBoolean(boolean value) {
            this.parent.add(BoolValue.of((boolean)value));
        }
    }

    static final class ProtoUInt32ValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoUInt32ValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addLong(long value) {
            this.parent.add(UInt32Value.of((int)Math.toIntExact(value)));
        }
    }

    static final class ProtoInt32ValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoInt32ValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addInt(int value) {
            this.parent.add(Int32Value.of((int)value));
        }
    }

    static final class ProtoUInt64ValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoUInt64ValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addLong(long value) {
            this.parent.add(UInt64Value.of((long)value));
        }
    }

    static final class ProtoInt64ValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoInt64ValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addLong(long value) {
            this.parent.add(Int64Value.of((long)value));
        }
    }

    static final class ProtoFloatValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoFloatValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addFloat(float value) {
            this.parent.add(FloatValue.of((float)value));
        }
    }

    static final class ProtoDoubleValueConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoDoubleValueConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addDouble(double value) {
            this.parent.add(DoubleValue.of((double)value));
        }
    }

    static final class ProtoTimeConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;
        final LogicalTypeAnnotation.TimeLogicalTypeAnnotation logicalTypeAnnotation;

        public ProtoTimeConverter(ParentValueContainer parent, LogicalTypeAnnotation.TimeLogicalTypeAnnotation logicalTypeAnnotation) {
            this.parent = parent;
            this.logicalTypeAnnotation = logicalTypeAnnotation;
        }

        public void addInt(int value) {
            this.addLong(value);
        }

        public void addLong(long value) {
            LocalTime localTime;
            switch (this.logicalTypeAnnotation.getUnit()) {
                case MILLIS: {
                    localTime = LocalTime.ofNanoOfDay(value * 1000000L);
                    break;
                }
                case MICROS: {
                    localTime = LocalTime.ofNanoOfDay(value * 1000L);
                    break;
                }
                case NANOS: {
                    localTime = LocalTime.ofNanoOfDay(value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized TimeUnit: " + this.logicalTypeAnnotation.getUnit());
                }
            }
            TimeOfDay timeOfDay = TimeOfDay.newBuilder().setHours(localTime.getHour()).setMinutes(localTime.getMinute()).setSeconds(localTime.getSecond()).setNanos(localTime.getNano()).build();
            this.parent.add(timeOfDay);
        }
    }

    static final class ProtoDateConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoDateConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addInt(int value) {
            LocalDate localDate = LocalDate.ofEpochDay(value);
            Date date = Date.newBuilder().setYear(localDate.getYear()).setMonth(localDate.getMonthValue()).setDay(localDate.getDayOfMonth()).build();
            this.parent.add(date);
        }
    }

    static final class ProtoTimestampConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;
        final LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logicalTypeAnnotation;

        public ProtoTimestampConverter(ParentValueContainer parent, LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logicalTypeAnnotation) {
            this.parent = parent;
            this.logicalTypeAnnotation = logicalTypeAnnotation;
        }

        public void addLong(long value) {
            switch (this.logicalTypeAnnotation.getUnit()) {
                case MICROS: {
                    this.parent.add(Timestamps.fromMicros((long)value));
                    break;
                }
                case MILLIS: {
                    this.parent.add(Timestamps.fromMillis((long)value));
                    break;
                }
                case NANOS: {
                    this.parent.add(Timestamps.fromNanos((long)value));
                }
            }
        }
    }

    static final class ProtoStringConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoStringConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBinary(Binary binary) {
            String str = binary.toStringUsingUTF8();
            this.parent.add(str);
        }
    }

    static final class ProtoLongConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoLongConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addLong(long value) {
            this.parent.add(value);
        }
    }

    static final class ProtoIntConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoIntConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addInt(int value) {
            this.parent.add(value);
        }
    }

    static final class ProtoFloatConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoFloatConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addFloat(float value) {
            this.parent.add(Float.valueOf(value));
        }
    }

    static final class ProtoDoubleConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoDoubleConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addDouble(double value) {
            this.parent.add(value);
        }
    }

    static final class ProtoBooleanConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoBooleanConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBoolean(boolean value) {
            this.parent.add(value);
        }
    }

    static final class ProtoBinaryConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoBinaryConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBinary(Binary binary) {
            ByteString byteString = ByteString.copyFrom((ByteBuffer)binary.toByteBuffer());
            this.parent.add(byteString);
        }
    }

    final class ProtoEnumConverter
    extends PrimitiveConverter {
        private final Descriptors.FieldDescriptor fieldType;
        private final Map<Binary, Descriptors.EnumValueDescriptor> enumLookup;
        private Descriptors.EnumValueDescriptor[] dict;
        private final ParentValueContainer parent;
        private final Descriptors.EnumDescriptor enumType;
        private final String unknownEnumPrefix;
        private final boolean acceptUnknownEnum;

        public ProtoEnumConverter(ParentValueContainer parent, Descriptors.FieldDescriptor fieldType) {
            this.parent = parent;
            this.fieldType = fieldType;
            this.enumType = fieldType.getEnumType();
            this.enumLookup = this.makeLookupStructure(this.enumType);
            this.unknownEnumPrefix = "UNKNOWN_ENUM_VALUE_" + this.enumType.getName() + "_";
            this.acceptUnknownEnum = ProtoMessageConverter.this.conf.getBoolean("parquet.proto.accept.unknown.enum", false);
        }

        private Map<Binary, Descriptors.EnumValueDescriptor> makeLookupStructure(Descriptors.EnumDescriptor enumType) {
            HashMap<Binary, Descriptors.EnumValueDescriptor> lookupStructure = new HashMap<Binary, Descriptors.EnumValueDescriptor>();
            if (ProtoMessageConverter.this.extraMetadata.containsKey("parquet.proto.enum." + enumType.getFullName())) {
                String enumNameNumberPairs = ProtoMessageConverter.this.extraMetadata.get("parquet.proto.enum." + enumType.getFullName());
                if (enumNameNumberPairs == null || enumNameNumberPairs.trim().isEmpty()) {
                    LOG.debug("No enum is written for " + enumType.getFullName());
                    return lookupStructure;
                }
                for (String enumItem : enumNameNumberPairs.split(",")) {
                    String[] nameAndNumber = enumItem.split(":");
                    if (nameAndNumber.length != 2) {
                        throw new BadConfigurationException("Invalid enum bookkeeper from the metadata: " + enumNameNumberPairs);
                    }
                    lookupStructure.put(Binary.fromString((String)nameAndNumber[0]), enumType.findValueByNumberCreatingIfUnknown(Integer.parseInt(nameAndNumber[1])));
                }
            } else {
                List enumValues = enumType.getValues();
                for (Descriptors.EnumValueDescriptor value : enumValues) {
                    String name = value.getName();
                    lookupStructure.put(Binary.fromString((String)name), enumType.findValueByName(name));
                }
            }
            return lookupStructure;
        }

        private Descriptors.EnumValueDescriptor translateEnumValue(Binary binaryValue) {
            Descriptors.EnumValueDescriptor protoValue = this.enumLookup.get(binaryValue);
            if (protoValue == null) {
                String unknownLabel = binaryValue.toStringUsingUTF8();
                if (unknownLabel.startsWith(this.unknownEnumPrefix)) {
                    try {
                        int i = Integer.parseInt(unknownLabel.substring(this.unknownEnumPrefix.length()));
                        Descriptors.EnumValueDescriptor unknownEnumValue = this.enumType.findValueByNumberCreatingIfUnknown(i);
                        this.enumLookup.put(binaryValue, unknownEnumValue);
                        return unknownEnumValue;
                    }
                    catch (NumberFormatException i) {
                        // empty catch block
                    }
                }
                if (!this.acceptUnknownEnum) {
                    Set<Binary> knownValues = this.enumLookup.keySet();
                    String msg = "Illegal enum value \"" + binaryValue + "\" in protocol buffer \"" + this.fieldType.getFullName() + "\" legal values are: \"" + knownValues + "\"";
                    throw new InvalidRecordException(msg);
                }
                LOG.error("Found unknown value " + unknownLabel + " for field " + this.fieldType.getFullName() + " probably because your proto schema is outdated, accept it as unknown enum with number -1");
                Descriptors.EnumValueDescriptor unrecognized = this.enumType.findValueByNumberCreatingIfUnknown(-1);
                this.enumLookup.put(binaryValue, unrecognized);
                return unrecognized;
            }
            return protoValue;
        }

        public void addBinary(Binary binaryValue) {
            Descriptors.EnumValueDescriptor protoValue = this.translateEnumValue(binaryValue);
            this.parent.add(protoValue);
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.add(this.dict[dictionaryId]);
        }

        public boolean hasDictionarySupport() {
            return true;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new Descriptors.EnumValueDescriptor[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                Binary binaryValue = dictionary.decodeToBinary(i);
                this.dict[i] = this.translateEnumValue(binaryValue);
            }
        }
    }

    static abstract class ParentValueContainer {
        ParentValueContainer() {
        }

        public abstract void add(Object var1);
    }
}

