/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.util.List;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoSchemaConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoSchemaConverter.class);

    public MessageType convert(Class<? extends Message> protobufClass) {
        LOG.debug("Converting protocol buffer class \"" + protobufClass + "\" to parquet schema.");
        Descriptors.Descriptor descriptor = Protobufs.getMessageDescriptor(protobufClass);
        MessageType messageType = (MessageType)this.convertFields((Types.GroupBuilder)Types.buildMessage(), descriptor.getFields()).named(descriptor.getFullName());
        LOG.debug("Converter info:\n " + descriptor.toProto() + " was converted to \n" + messageType);
        return messageType;
    }

    private <T> Types.GroupBuilder<T> convertFields(Types.GroupBuilder<T> groupBuilder, List<Descriptors.FieldDescriptor> fieldDescriptors) {
        for (Descriptors.FieldDescriptor fieldDescriptor : fieldDescriptors) {
            groupBuilder = (Types.GroupBuilder)this.addField(fieldDescriptor, groupBuilder).id(fieldDescriptor.getNumber()).named(fieldDescriptor.getName());
        }
        return groupBuilder;
    }

    private Type.Repetition getRepetition(Descriptors.FieldDescriptor descriptor) {
        if (descriptor.isRequired()) {
            return Type.Repetition.REQUIRED;
        }
        if (descriptor.isRepeated()) {
            return Type.Repetition.REPEATED;
        }
        return Type.Repetition.OPTIONAL;
    }

    private <T> Types.Builder<? extends Types.Builder<?, Types.GroupBuilder<T>>, Types.GroupBuilder<T>> addField(Descriptors.FieldDescriptor descriptor, Types.GroupBuilder<T> builder) {
        Type.Repetition repetition = this.getRepetition(descriptor);
        Descriptors.FieldDescriptor.JavaType javaType = descriptor.getJavaType();
        switch (javaType) {
            case BOOLEAN: {
                return builder.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition);
            }
            case INT: {
                return builder.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition);
            }
            case LONG: {
                return builder.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition);
            }
            case FLOAT: {
                return builder.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition);
            }
            case DOUBLE: {
                return builder.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition);
            }
            case BYTE_STRING: {
                return builder.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition);
            }
            case STRING: {
                return builder.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8);
            }
            case MESSAGE: {
                Types.GroupBuilder group = builder.group(repetition);
                this.convertFields(group, descriptor.getMessageType().getFields());
                return group;
            }
            case ENUM: {
                return builder.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.ENUM);
            }
        }
        throw new UnsupportedOperationException("Cannot convert Protocol Buffer: unknown type " + javaType);
    }
}

