/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.twitter.elephantbird.util.Protobufs;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.proto.ProtoSchemaConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoWriteSupport<T extends MessageOrBuilder>
extends WriteSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoWriteSupport.class);
    public static final String PB_CLASS_WRITE = "parquet.proto.writeClass";
    private RecordConsumer recordConsumer;
    private Class<? extends Message> protoMessage;
    private MessageWriter messageWriter;

    public ProtoWriteSupport() {
    }

    public ProtoWriteSupport(Class<? extends Message> protobufClass) {
        this.protoMessage = protobufClass;
    }

    public String getName() {
        return "protobuf";
    }

    public static void setSchema(Configuration configuration, Class<? extends Message> protoClass) {
        configuration.setClass(PB_CLASS_WRITE, protoClass, Message.class);
    }

    public void write(T record) {
        this.recordConsumer.startMessage();
        try {
            this.messageWriter.writeTopLevelMessage(record);
        }
        catch (RuntimeException e) {
            Message m = record instanceof Message.Builder ? ((Message.Builder)record).build() : (Message)record;
            LOG.error("Cannot write message " + e.getMessage() + " : " + m);
            throw e;
        }
        this.recordConsumer.endMessage();
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.protoMessage == null) {
            Class pbClass = configuration.getClass(PB_CLASS_WRITE, null, Message.class);
            if (pbClass != null) {
                this.protoMessage = pbClass;
            } else {
                String msg = "Protocol buffer class not specified.";
                String hint = " Please use method ProtoParquetOutputFormat.setProtobufClass(...) or other similar method.";
                throw new BadConfigurationException(msg + hint);
            }
        }
        MessageType rootSchema = new ProtoSchemaConverter().convert(this.protoMessage);
        Descriptors.Descriptor messageDescriptor = Protobufs.getMessageDescriptor(this.protoMessage);
        this.validatedMapping(messageDescriptor, (GroupType)rootSchema);
        this.messageWriter = new MessageWriter(messageDescriptor, (GroupType)rootSchema);
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        extraMetaData.put("parquet.proto.class", this.protoMessage.getName());
        extraMetaData.put("parquet.proto.descriptor", this.serializeDescriptor(this.protoMessage));
        return new WriteSupport.WriteContext(rootSchema, extraMetaData);
    }

    private void validatedMapping(Descriptors.Descriptor descriptor, GroupType parquetSchema) {
        List allFields = descriptor.getFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : allFields) {
            int parquetIndex;
            String fieldName = fieldDescriptor.getName();
            int fieldIndex = fieldDescriptor.getIndex();
            if (fieldIndex == (parquetIndex = parquetSchema.getFieldIndex(fieldName))) continue;
            String message = "FieldIndex mismatch name=" + fieldName + ": " + fieldIndex + " != " + parquetIndex;
            throw new IncompatibleSchemaModificationException(message);
        }
    }

    private FieldWriter unknownType(Descriptors.FieldDescriptor fieldDescriptor) {
        String exceptionMsg = "Unknown type with descriptor \"" + fieldDescriptor + "\" and type \"" + fieldDescriptor.getJavaType() + "\".";
        throw new InvalidRecordException(exceptionMsg);
    }

    private String serializeDescriptor(Class<? extends Message> protoClass) {
        Descriptors.Descriptor descriptor = Protobufs.getMessageDescriptor(protoClass);
        DescriptorProtos.DescriptorProto asProto = descriptor.toProto();
        return TextFormat.printToString((MessageOrBuilder)asProto);
    }

    class BinaryWriter
    extends FieldWriter {
        BinaryWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ByteString byteString = (ByteString)value;
            Binary binary = Binary.fromConstantByteArray((byte[])byteString.toByteArray());
            ProtoWriteSupport.this.recordConsumer.addBinary(binary);
        }
    }

    class BooleanWriter
    extends FieldWriter {
        BooleanWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
        }
    }

    class EnumWriter
    extends FieldWriter {
        EnumWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            Binary binary = Binary.fromString((String)((Descriptors.EnumValueDescriptor)value).getName());
            ProtoWriteSupport.this.recordConsumer.addBinary(binary);
        }
    }

    class DoubleWriter
    extends FieldWriter {
        DoubleWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addDouble(((Double)value).doubleValue());
        }
    }

    class FloatWriter
    extends FieldWriter {
        FloatWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addFloat(((Float)value).floatValue());
        }
    }

    class LongWriter
    extends FieldWriter {
        LongWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addLong(((Long)value).longValue());
        }
    }

    class IntWriter
    extends FieldWriter {
        IntWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.addInteger(((Integer)value).intValue());
        }
    }

    class StringWriter
    extends FieldWriter {
        StringWriter() {
        }

        @Override
        final void writeRawValue(Object value) {
            Binary binaryString = Binary.fromString((String)((String)value));
            ProtoWriteSupport.this.recordConsumer.addBinary(binaryString);
        }
    }

    class ArrayWriter
    extends FieldWriter {
        final FieldWriter fieldWriter;

        ArrayWriter(FieldWriter fieldWriter) {
            this.fieldWriter = fieldWriter;
        }

        @Override
        final void writeRawValue(Object value) {
            throw new UnsupportedOperationException("Array has no raw value");
        }

        @Override
        final void writeField(Object value) {
            ProtoWriteSupport.this.recordConsumer.startField(this.fieldName, this.index);
            List list = (List)value;
            for (Object listEntry : list) {
                this.fieldWriter.writeRawValue(listEntry);
            }
            ProtoWriteSupport.this.recordConsumer.endField(this.fieldName, this.index);
        }
    }

    class MessageWriter
    extends FieldWriter {
        final FieldWriter[] fieldWriters;

        MessageWriter(Descriptors.Descriptor descriptor, GroupType schema) {
            List fields = descriptor.getFields();
            this.fieldWriters = (FieldWriter[])Array.newInstance(FieldWriter.class, fields.size());
            for (Descriptors.FieldDescriptor fieldDescriptor : fields) {
                String name = fieldDescriptor.getName();
                Type type = schema.getType(name);
                FieldWriter writer = this.createWriter(fieldDescriptor, type);
                if (fieldDescriptor.isRepeated()) {
                    writer = new ArrayWriter(writer);
                }
                writer.setFieldName(name);
                writer.setIndex(schema.getFieldIndex(name));
                this.fieldWriters[fieldDescriptor.getIndex()] = writer;
            }
        }

        private FieldWriter createWriter(Descriptors.FieldDescriptor fieldDescriptor, Type type) {
            switch (fieldDescriptor.getJavaType()) {
                case STRING: {
                    return new StringWriter();
                }
                case MESSAGE: {
                    return new MessageWriter(fieldDescriptor.getMessageType(), type.asGroupType());
                }
                case INT: {
                    return new IntWriter();
                }
                case LONG: {
                    return new LongWriter();
                }
                case FLOAT: {
                    return new FloatWriter();
                }
                case DOUBLE: {
                    return new DoubleWriter();
                }
                case ENUM: {
                    return new EnumWriter();
                }
                case BOOLEAN: {
                    return new BooleanWriter();
                }
                case BYTE_STRING: {
                    return new BinaryWriter();
                }
            }
            return ProtoWriteSupport.this.unknownType(fieldDescriptor);
        }

        void writeTopLevelMessage(Object value) {
            this.writeAllFields((MessageOrBuilder)value);
        }

        @Override
        final void writeRawValue(Object value) {
            ProtoWriteSupport.this.recordConsumer.startGroup();
            this.writeAllFields((MessageOrBuilder)value);
            ProtoWriteSupport.this.recordConsumer.endGroup();
        }

        @Override
        final void writeField(Object value) {
            ProtoWriteSupport.this.recordConsumer.startField(this.fieldName, this.index);
            ProtoWriteSupport.this.recordConsumer.startGroup();
            this.writeAllFields((MessageOrBuilder)value);
            ProtoWriteSupport.this.recordConsumer.endGroup();
            ProtoWriteSupport.this.recordConsumer.endField(this.fieldName, this.index);
        }

        private void writeAllFields(MessageOrBuilder pb) {
            Map changedPbFields = pb.getAllFields();
            for (Map.Entry entry : changedPbFields.entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)entry.getKey();
                if (fieldDescriptor.isExtension()) {
                    throw new UnsupportedOperationException("Cannot convert Protobuf message with extension field(s)");
                }
                int fieldIndex = fieldDescriptor.getIndex();
                this.fieldWriters[fieldIndex].writeField(entry.getValue());
            }
        }
    }

    class FieldWriter {
        String fieldName;
        int index = -1;

        FieldWriter() {
        }

        void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        void setIndex(int index) {
            this.index = index;
        }

        void writeRawValue(Object value) {
        }

        void writeField(Object value) {
            ProtoWriteSupport.this.recordConsumer.startField(this.fieldName, this.index);
            this.writeRawValue(value);
            ProtoWriteSupport.this.recordConsumer.endField(this.fieldName, this.index);
        }
    }
}

