/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.Strings;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.TBaseRecordConverter;
import org.apache.parquet.thrift.ThriftMetaData;
import org.apache.parquet.thrift.ThriftRecordConverter;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.projection.StrictFieldProjectionFilter;
import org.apache.parquet.thrift.projection.ThriftProjectionException;
import org.apache.parquet.thrift.projection.deprecated.DeprecatedFieldProjectionFilter;
import org.apache.parquet.thrift.struct.ThriftType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftReadSupport<T>
extends ReadSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftReadSupport.class);
    @Deprecated
    public static final String THRIFT_COLUMN_FILTER_KEY = "parquet.thrift.column.filter";
    public static final String STRICT_THRIFT_COLUMN_FILTER_KEY = "parquet.thrift.column.projection.globs";
    private static final String RECORD_CONVERTER_DEFAULT = TBaseRecordConverter.class.getName();
    public static final String THRIFT_READ_CLASS_KEY = "parquet.thrift.read.class";
    private static final String RECORD_CONVERTER_CLASS_KEY = "parquet.thrift.converter.class";
    protected Class<T> thriftClass;

    @Deprecated
    public static void setRecordConverterClass(JobConf conf, Class<?> klass) {
        ThriftReadSupport.setRecordConverterClass((Configuration)conf, klass);
    }

    public static void setRecordConverterClass(Configuration conf, Class<?> klass) {
        conf.set(RECORD_CONVERTER_CLASS_KEY, klass.getName());
    }

    @Deprecated
    public static void setProjectionPushdown(JobConf jobConf, String projectionString) {
        jobConf.set(THRIFT_COLUMN_FILTER_KEY, projectionString);
    }

    public static void setStrictFieldProjectionFilter(Configuration conf, String semicolonDelimitedGlobs) {
        conf.set(STRICT_THRIFT_COLUMN_FILTER_KEY, semicolonDelimitedGlobs);
    }

    public static FieldProjectionFilter getFieldProjectionFilter(Configuration conf) {
        String deprecated = conf.get(THRIFT_COLUMN_FILTER_KEY);
        String strict = conf.get(STRICT_THRIFT_COLUMN_FILTER_KEY);
        if (Strings.isNullOrEmpty((String)deprecated) && Strings.isNullOrEmpty((String)strict)) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)deprecated) && !Strings.isNullOrEmpty((String)strict)) {
            throw new ThriftProjectionException("You cannot provide both parquet.thrift.column.filter and parquet.thrift.column.projection.globs! parquet.thrift.column.filter is deprecated.");
        }
        if (!Strings.isNullOrEmpty((String)deprecated)) {
            LOG.warn("Using {} is deprecated. Please see the docs for {}!", (Object)THRIFT_COLUMN_FILTER_KEY, (Object)STRICT_THRIFT_COLUMN_FILTER_KEY);
            return new DeprecatedFieldProjectionFilter(deprecated);
        }
        return StrictFieldProjectionFilter.fromSemicolonDelimitedString(strict);
    }

    public ThriftReadSupport() {
    }

    public ThriftReadSupport(Class<T> thriftClass) {
        this.thriftClass = thriftClass;
    }

    public ReadSupport.ReadContext init(InitContext context) {
        MessageType fileMessageType;
        Configuration configuration = context.getConfiguration();
        MessageType requestedProjection = fileMessageType = context.getFileSchema();
        String partialSchemaString = configuration.get("parquet.read.schema");
        FieldProjectionFilter projectionFilter = ThriftReadSupport.getFieldProjectionFilter(configuration);
        if (partialSchemaString != null && projectionFilter != null) {
            throw new ThriftProjectionException(String.format("You cannot provide both a partial schema and field projection filter.Only one of (%s, %s, %s) should be set.", "parquet.read.schema", STRICT_THRIFT_COLUMN_FILTER_KEY, THRIFT_COLUMN_FILTER_KEY));
        }
        if (partialSchemaString != null) {
            requestedProjection = ThriftReadSupport.getSchemaForRead((MessageType)fileMessageType, (String)partialSchemaString);
        } else if (projectionFilter != null) {
            try {
                this.initThriftClassFromMultipleFiles(context.getKeyValueMetadata(), configuration);
                requestedProjection = this.getProjectedSchema(projectionFilter);
            }
            catch (ClassNotFoundException e) {
                throw new ThriftProjectionException("can not find thriftClass from configuration", e);
            }
        }
        MessageType schemaForRead = ThriftReadSupport.getSchemaForRead((MessageType)fileMessageType, (MessageType)requestedProjection);
        return new ReadSupport.ReadContext(schemaForRead);
    }

    protected MessageType getProjectedSchema(FieldProjectionFilter fieldProjectionFilter) {
        return new ThriftSchemaConverter(fieldProjectionFilter).convert(this.thriftClass);
    }

    private void initThriftClassFromMultipleFiles(Map<String, Set<String>> fileMetadata, Configuration conf) throws ClassNotFoundException {
        if (this.thriftClass != null) {
            return;
        }
        String className = conf.get(THRIFT_READ_CLASS_KEY, null);
        if (className == null) {
            Set<String> names = ThriftMetaData.getThriftClassNames(fileMetadata);
            if (names == null || names.size() != 1) {
                throw new ParquetDecodingException("Could not read file as the Thrift class is not provided and could not be resolved from the file: " + names);
            }
            className = names.iterator().next();
        }
        this.thriftClass = Class.forName(className);
    }

    private void initThriftClass(ThriftMetaData metadata, Configuration conf) throws ClassNotFoundException {
        if (this.thriftClass != null) {
            return;
        }
        String className = conf.get(THRIFT_READ_CLASS_KEY, null);
        if (className == null) {
            if (metadata == null) {
                throw new ParquetDecodingException("Could not read file as the Thrift class is not provided and could not be resolved from the file");
            }
            this.thriftClass = metadata.getThriftClass();
        } else {
            this.thriftClass = Class.forName(className);
        }
    }

    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        ThriftMetaData thriftMetaData = ThriftMetaData.fromExtraMetaData(keyValueMetaData);
        try {
            this.initThriftClass(thriftMetaData, configuration);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find Thrift object class for metadata: " + thriftMetaData, e);
        }
        if (thriftMetaData == null) {
            thriftMetaData = ThriftMetaData.fromThriftClass(this.thriftClass);
        }
        String converterClassName = configuration.get(RECORD_CONVERTER_CLASS_KEY, RECORD_CONVERTER_DEFAULT);
        return ThriftReadSupport.getRecordConverterInstance(converterClassName, this.thriftClass, readContext.getRequestedSchema(), thriftMetaData.getDescriptor(), configuration);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> ThriftRecordConverter<T> getRecordConverterInstance(String converterClassName, Class<T> thriftClass, MessageType requestedSchema, ThriftType.StructType descriptor, Configuration conf) {
        Class<?> converterClass;
        try {
            converterClass = Class.forName(converterClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find Thrift converter class: " + converterClassName, e);
        }
        try {
            try {
                Constructor<?> constructor2222 = converterClass.getConstructor(Class.class, MessageType.class, ThriftType.StructType.class, Configuration.class);
                return (ThriftRecordConverter)((Object)constructor2222.newInstance(thriftClass, requestedSchema, descriptor, conf));
            }
            catch (IllegalAccessException constructor2222) {
                try {
                    block11: {
                        break block11;
                        catch (NoSuchMethodException constructor2222) {
                            // empty catch block
                        }
                    }
                    Constructor<?> constructor3 = converterClass.getConstructor(Class.class, MessageType.class, ThriftType.StructType.class);
                    return (ThriftRecordConverter)((Object)constructor3.newInstance(thriftClass, requestedSchema, descriptor));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Cannot access constructor for Thrift converter class: " + converterClassName, e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Cannot find constructor for Thrift converter class: " + converterClassName, e);
                }
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to construct Thrift converter class: " + converterClassName, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to construct Thrift converter class: " + converterClassName, e);
        }
    }
}

