/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import org.apache.parquet.Preconditions;
import org.apache.parquet.ShouldNeverHappenException;
import org.apache.parquet.schema.Type;
import org.apache.parquet.thrift.projection.FieldsPath;

public interface ConvertedField {
    public FieldsPath path();

    public boolean isKeep();

    public Keep asKeep();

    public boolean isDrop();

    public Drop asDrop();

    public boolean isSentinelUnion();

    public SentinelUnion asSentinelUnion();

    public static final class Drop
    extends ConvertedFieldBase {
        public Drop(FieldsPath path) {
            super(path);
        }

        @Override
        public boolean isDrop() {
            return true;
        }

        @Override
        public Drop asDrop() {
            return this;
        }
    }

    public static final class SentinelUnion
    extends ConvertedFieldBase {
        private final Type type;

        public SentinelUnion(FieldsPath path, Type type) {
            super(path);
            this.type = (Type)Preconditions.checkNotNull((Object)type, (String)"type");
        }

        @Override
        public boolean isSentinelUnion() {
            return true;
        }

        @Override
        public SentinelUnion asSentinelUnion() {
            return this;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static final class Keep
    extends ConvertedFieldBase {
        private final Type type;

        public Keep(FieldsPath path, Type type) {
            super(path);
            this.type = (Type)Preconditions.checkNotNull((Object)type, (String)"type");
        }

        @Override
        public boolean isKeep() {
            return true;
        }

        @Override
        public Keep asKeep() {
            return this;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static abstract class ConvertedFieldBase
    implements ConvertedField {
        private final FieldsPath path;

        protected ConvertedFieldBase(FieldsPath path) {
            this.path = (FieldsPath)Preconditions.checkNotNull((Object)path, (String)"path");
        }

        @Override
        public boolean isKeep() {
            return false;
        }

        @Override
        public Keep asKeep() {
            throw new ShouldNeverHappenException("asKeep called on " + this);
        }

        @Override
        public boolean isDrop() {
            return false;
        }

        @Override
        public Drop asDrop() {
            throw new ShouldNeverHappenException("asDrop called on " + this);
        }

        @Override
        public boolean isSentinelUnion() {
            return false;
        }

        @Override
        public SentinelUnion asSentinelUnion() {
            throw new ShouldNeverHappenException("asSentinelUnion called on " + this);
        }

        @Override
        public FieldsPath path() {
            return this.path;
        }
    }
}

