/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.parquet.thrift.ParquetProtocol;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParquetReadProtocol
extends ParquetProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetReadProtocol.class);
    private Deque<TProtocol> events = new LinkedList<TProtocol>();

    ParquetReadProtocol() {
        super("read");
    }

    public void add(TProtocol p) {
        this.events.addLast(p);
    }

    public void addAll(Collection<TProtocol> events) {
        this.events.addAll(events);
    }

    public void clear() {
        this.events.clear();
    }

    private TProtocol next() {
        return this.events.removeFirst();
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        LOG.debug("readMessageBegin()");
        return this.next().readMessageBegin();
    }

    @Override
    public void readMessageEnd() throws TException {
        LOG.debug("readMessageEnd()");
        this.next().readMessageEnd();
    }

    @Override
    public TStruct readStructBegin() throws TException {
        LOG.debug("readStructBegin()");
        return this.next().readStructBegin();
    }

    @Override
    public void readStructEnd() throws TException {
        LOG.debug("readStructEnd()");
        this.next().readStructEnd();
    }

    @Override
    public TField readFieldBegin() throws TException {
        LOG.debug("readFieldBegin()");
        return this.next().readFieldBegin();
    }

    @Override
    public void readFieldEnd() throws TException {
        LOG.debug("readFieldEnd()");
        this.next().readFieldEnd();
    }

    @Override
    public TMap readMapBegin() throws TException {
        LOG.debug("readMapBegin()");
        return this.next().readMapBegin();
    }

    @Override
    public void readMapEnd() throws TException {
        LOG.debug("readMapEnd()");
        this.next().readMapEnd();
    }

    @Override
    public TList readListBegin() throws TException {
        LOG.debug("readListBegin()");
        return this.next().readListBegin();
    }

    @Override
    public void readListEnd() throws TException {
        LOG.debug("readListEnd()");
        this.next().readListEnd();
    }

    @Override
    public TSet readSetBegin() throws TException {
        LOG.debug("readSetBegin()");
        return this.next().readSetBegin();
    }

    @Override
    public void readSetEnd() throws TException {
        LOG.debug("readSetEnd()");
        this.next().readSetEnd();
    }

    @Override
    public boolean readBool() throws TException {
        LOG.debug("readBool()");
        return this.next().readBool();
    }

    @Override
    public byte readByte() throws TException {
        LOG.debug("readByte()");
        return this.next().readByte();
    }

    @Override
    public short readI16() throws TException {
        LOG.debug("readI16()");
        return this.next().readI16();
    }

    @Override
    public int readI32() throws TException {
        LOG.debug("readI32()");
        return this.next().readI32();
    }

    @Override
    public long readI64() throws TException {
        LOG.debug("readI64()");
        return this.next().readI64();
    }

    @Override
    public double readDouble() throws TException {
        LOG.debug("readDouble()");
        return this.next().readDouble();
    }

    @Override
    public String readString() throws TException {
        LOG.debug("readString()");
        return this.next().readString();
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        LOG.debug("readBinary()");
        return this.next().readBinary();
    }
}

