/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.thrift.TBaseWriteSupport;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.BufferedProtocolReadToWrite;
import org.apache.parquet.thrift.FieldIgnoredHandler;
import org.apache.parquet.thrift.ParquetWriteProtocol;
import org.apache.parquet.thrift.ProtocolPipe;
import org.apache.parquet.thrift.ProtocolReadToWrite;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftBytesWriteSupport
extends WriteSupport<BytesWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftBytesWriteSupport.class);
    private static final String PARQUET_PROTOCOL_CLASS = "parquet.protocol.class";
    private final boolean buffered;
    private final TBaseWriteSupport<?> thriftWriteSupport = new TBaseWriteSupport();
    private ProtocolPipe readToWrite;
    private TProtocolFactory protocolFactory;
    private Class<? extends TBase<?, ?>> thriftClass;
    private MessageType schema;
    private ThriftType.StructType thriftStruct;
    private ParquetWriteProtocol parquetWriteProtocol;
    private final FieldIgnoredHandler errorHandler;
    private Configuration configuration;
    private static Method SET_READ_LENGTH;

    public static <U extends TProtocol> void setTProtocolClass(Configuration conf, Class<U> tProtocolClass) {
        conf.set(PARQUET_PROTOCOL_CLASS, tProtocolClass.getName());
    }

    public static Class<TProtocolFactory> getTProtocolFactoryClass(Configuration conf) {
        String tProtocolClassName = conf.get(PARQUET_PROTOCOL_CLASS);
        if (tProtocolClassName == null) {
            throw new BadConfigurationException("the protocol class conf is missing in job conf at parquet.protocol.class");
        }
        try {
            Class<TProtocolFactory> tProtocolFactoryClass = Class.forName(tProtocolClassName + "$Factory");
            return tProtocolFactoryClass;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("the Factory for class " + tProtocolClassName + " in job conf at " + PARQUET_PROTOCOL_CLASS + " could not be found", (Throwable)e);
        }
    }

    public ThriftBytesWriteSupport() {
        this.buffered = true;
        this.errorHandler = null;
    }

    @Deprecated
    public ThriftBytesWriteSupport(TProtocolFactory protocolFactory, Class<? extends TBase<?, ?>> thriftClass, boolean buffered, FieldIgnoredHandler errorHandler) {
        this(new Configuration(), protocolFactory, thriftClass, buffered, errorHandler);
    }

    public ThriftBytesWriteSupport(Configuration configuration, TProtocolFactory protocolFactory, Class<? extends TBase<?, ?>> thriftClass, boolean buffered, FieldIgnoredHandler errorHandler) {
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
        this.thriftClass = thriftClass;
        this.buffered = buffered;
        this.errorHandler = errorHandler;
        if (!buffered && errorHandler != null) {
            throw new IllegalArgumentException("Only buffered protocol can use error handler for now");
        }
    }

    public String getName() {
        return "thrift";
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        this.configuration = configuration;
        if (this.protocolFactory == null) {
            try {
                this.protocolFactory = ThriftBytesWriteSupport.getTProtocolFactoryClass(configuration).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.thriftClass != null) {
            TBaseWriteSupport.setThriftClass(configuration, this.thriftClass);
        } else {
            this.thriftClass = TBaseWriteSupport.getThriftClass(configuration);
        }
        ThriftSchemaConverter thriftSchemaConverter = new ThriftSchemaConverter(this.configuration);
        this.thriftStruct = ThriftSchemaConverter.toStructType(this.thriftClass);
        this.schema = thriftSchemaConverter.convert(this.thriftStruct);
        this.readToWrite = this.buffered ? new BufferedProtocolReadToWrite(this.thriftStruct, this.errorHandler) : new ProtocolReadToWrite();
        return this.thriftWriteSupport.init(configuration);
    }

    private TProtocol protocol(BytesWritable record) {
        TProtocol protocol = this.protocolFactory.getProtocol((TTransport)new TIOStreamTransport((InputStream)new ByteArrayInputStream(record.getBytes())));
        if (SET_READ_LENGTH != null && protocol instanceof TBinaryProtocol) {
            try {
                SET_READ_LENGTH.invoke((Object)protocol, record.getLength());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.warn("setReadLength should not throw an exception", (Throwable)e);
                SET_READ_LENGTH = null;
            }
        }
        return protocol;
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(this.schema);
        this.parquetWriteProtocol = new ParquetWriteProtocol(this.configuration, recordConsumer, columnIO, this.thriftStruct);
        this.thriftWriteSupport.prepareForWrite(recordConsumer);
    }

    public void write(BytesWritable record) {
        try {
            this.readToWrite.readOne(this.protocol(record), this.parquetWriteProtocol);
        }
        catch (TException e) {
            throw new ParquetEncodingException((Throwable)e);
        }
    }

    static {
        try {
            SET_READ_LENGTH = TBinaryProtocol.class.getMethod("setReadLength", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            SET_READ_LENGTH = null;
        }
    }
}

