/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftMetaData.class);
    private static final String THRIFT_CLASS = "thrift.class";
    private static final String THRIFT_DESCRIPTOR = "thrift.descriptor";
    private Class<?> thriftClass;
    private final String thriftClassName;
    private final ThriftType.StructType descriptor;

    public ThriftMetaData(String thriftClassName, ThriftType.StructType descriptor) {
        this.thriftClassName = thriftClassName;
        this.descriptor = descriptor;
    }

    public Class<?> getThriftClass() {
        if (this.thriftClass == null) {
            this.thriftClass = ThriftMetaData.getThriftClass(this.thriftClassName);
        }
        return this.thriftClass;
    }

    public static Class<?> getThriftClass(String thriftClassName) {
        try {
            Class<?> thriftClass = Class.forName(thriftClassName);
            return thriftClass;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("Could not instantiate thrift class " + thriftClassName, (Throwable)e);
        }
    }

    public ThriftType.StructType getDescriptor() {
        return this.descriptor;
    }

    public static ThriftMetaData fromExtraMetaData(Map<String, String> extraMetaData) {
        String thriftClassName = extraMetaData.get(THRIFT_CLASS);
        String thriftDescriptorString = extraMetaData.get(THRIFT_DESCRIPTOR);
        if (thriftClassName == null || thriftDescriptorString == null) {
            return null;
        }
        ThriftType.StructType descriptor = ThriftMetaData.parseDescriptor(thriftDescriptorString);
        return new ThriftMetaData(thriftClassName, descriptor);
    }

    public static ThriftMetaData fromThriftClass(Class<?> thriftClass) {
        if (thriftClass != null && TBase.class.isAssignableFrom(thriftClass)) {
            Class<?> tClass = thriftClass;
            new ThriftSchemaConverter();
            ThriftType.StructType descriptor = ThriftSchemaConverter.toStructType(tClass);
            return new ThriftMetaData(thriftClass.getName(), descriptor);
        }
        return null;
    }

    private static ThriftType.StructType parseDescriptor(String json) {
        try {
            return (ThriftType.StructType)ThriftType.fromJSON(json);
        }
        catch (RuntimeException e) {
            throw new BadConfigurationException("Could not read the thrift descriptor " + json, (Throwable)e);
        }
    }

    public Map<String, String> toExtraMetaData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(THRIFT_CLASS, this.getThriftClass().getName());
        map.put(THRIFT_DESCRIPTOR, this.descriptor.toJSON());
        return map;
    }

    public static Set<String> getThriftClassNames(Map<String, Set<String>> fileMetadata) {
        return fileMetadata.get(THRIFT_CLASS);
    }

    public String toString() {
        return String.format("ThriftMetaData(thriftClassName: %s, descriptor: %s)", this.thriftClassName, this.descriptor);
    }
}

