/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.Preconditions;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.thrift.ParquetProtocol;
import org.apache.parquet.thrift.ParquetReadProtocol;
import org.apache.parquet.thrift.ThriftReader;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.projection.amend.ProtocolEventsAmender;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.struct.ThriftTypeID;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftRecordConverter<T>
extends RecordMaterializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftRecordConverter.class);
    public static final String IGNORE_NULL_LIST_ELEMENTS = "parquet.thrift.ignore-null-elements";
    private static final boolean IGNORE_NULL_LIST_ELEMENTS_DEFAULT = false;
    static final ParquetProtocol readFieldEnd = new ParquetProtocol("readFieldEnd()"){

        @Override
        public void readFieldEnd() throws TException {
        }
    };
    private final ThriftType.StructType thriftType;
    private final ThriftReader<T> thriftReader;
    private final ParquetReadProtocol protocol;
    private GroupConverter structConverter;
    private List<TProtocol> rootEvents = new ArrayList<TProtocol>();
    private boolean missingRequiredFieldsInProjection = false;
    private boolean ignoreNullElements = false;

    @Deprecated
    public ThriftRecordConverter(ThriftReader<T> thriftReader, String name, MessageType requestedParquetSchema, ThriftType.StructType thriftType) {
        this(thriftReader, name, requestedParquetSchema, thriftType, null);
    }

    public ThriftRecordConverter(ThriftReader<T> thriftReader, String name, MessageType requestedParquetSchema, ThriftType.StructType thriftType, Configuration conf) {
        this.thriftReader = thriftReader;
        this.protocol = new ParquetReadProtocol();
        this.thriftType = thriftType;
        if (conf != null) {
            this.ignoreNullElements = conf.getBoolean(IGNORE_NULL_LIST_ELEMENTS, false);
        }
        MessageType fullSchema = ThriftSchemaConverter.convertWithoutProjection(thriftType);
        this.missingRequiredFieldsInProjection = this.hasMissingRequiredFieldInGroupType((GroupType)requestedParquetSchema, (GroupType)fullSchema);
        this.structConverter = new StructConverter(this.rootEvents, (GroupType)requestedParquetSchema, new ThriftField(name, 0, ThriftField.Requirement.REQUIRED, thriftType));
    }

    private boolean hasMissingRequiredFieldInGroupType(GroupType requested, GroupType fullSchema) {
        for (Type field : fullSchema.getFields()) {
            if (requested.containsField(field.getName())) {
                Type requestedType = requested.getType(field.getName());
                if (field.isPrimitive() || !this.hasMissingRequiredFieldInGroupType(requestedType.asGroupType(), field.asGroupType())) continue;
                return true;
            }
            if (field.getRepetition() != Type.Repetition.REQUIRED) continue;
            return true;
        }
        return false;
    }

    public T getCurrentRecord() {
        try {
            if (this.missingRequiredFieldsInProjection) {
                List<TProtocol> fixedEvents = new ProtocolEventsAmender(this.rootEvents).amendMissingRequiredFields(this.thriftType);
                this.protocol.addAll(fixedEvents);
            } else {
                this.protocol.addAll(this.rootEvents);
            }
            this.rootEvents.clear();
            return this.thriftReader.readOneRecord(this.protocol);
        }
        catch (TException e) {
            this.protocol.clear();
            this.rootEvents.clear();
            throw new RecordMaterializer.RecordMaterializationException("Could not read thrift object from protocol", (Throwable)e);
        }
    }

    public void skipCurrentRecord() {
        this.rootEvents.clear();
    }

    public GroupConverter getRootConverter() {
        return this.structConverter;
    }

    private Converter newConverter(List<TProtocol> events, Type type, ThriftField field) {
        switch (field.getType().getType()) {
            case LIST: {
                return new ListConverter(events, type.asGroupType(), field);
            }
            case SET: {
                return new SetConverter(events, type.asGroupType(), field);
            }
            case MAP: {
                return new MapConverter(events, type.asGroupType(), field);
            }
            case STRUCT: {
                return new StructConverter(events, type.asGroupType(), field);
            }
            case STRING: {
                return new FieldStringConverter(events, field);
            }
            case ENUM: {
                return new FieldEnumConverter(events, field);
            }
        }
        return new FieldPrimitiveConverter(events, field);
    }

    class StructConverter
    extends GroupConverter {
        private final int schemaSize;
        private final Converter[] converters;
        private final ThriftType.StructType thriftType;
        private final String name;
        private final TStruct tStruct;
        private final List<TProtocol> events;
        final ParquetProtocol readStructBegin = new ParquetProtocol("readStructBegin()"){

            @Override
            public TStruct readStructBegin() throws TException {
                return StructConverter.this.tStruct;
            }
        };
        private final ParquetProtocol readFieldStop = new ParquetProtocol("readFieldBegin() => STOP"){
            final TField stop;
            {
                this.stop = new TField("", 0, 0);
            }

            @Override
            public TField readFieldBegin() throws TException {
                return this.stop;
            }
        };
        private final ParquetProtocol readStructEnd = new ParquetProtocol("readStructEnd()"){

            @Override
            public void readStructEnd() throws TException {
            }
        };

        private StructConverter(List<TProtocol> events, GroupType parquetSchema, ThriftField field) {
            this.events = events;
            this.name = field.getName();
            this.tStruct = new TStruct(this.name);
            this.thriftType = (ThriftType.StructType)field.getType();
            this.schemaSize = parquetSchema.getFieldCount();
            this.converters = new Converter[this.schemaSize];
            List<ThriftField> thriftChildren = this.thriftType.getChildren();
            for (int i = 0; i < this.schemaSize; ++i) {
                Type schemaType = parquetSchema.getType(i);
                String fieldName = schemaType.getName();
                ThriftField matchingThrift = null;
                for (ThriftField childField : thriftChildren) {
                    String thriftChildName = childField.getName();
                    if (thriftChildName == null || !thriftChildName.equalsIgnoreCase(fieldName)) continue;
                    matchingThrift = childField;
                    break;
                }
                if (matchingThrift == null) continue;
                this.converters[i] = schemaType.isPrimitive() ? new PrimitiveFieldHandler(ThriftRecordConverter.this.newConverter(events, schemaType, matchingThrift).asPrimitiveConverter(), matchingThrift, events) : new GroupFieldhandler(ThriftRecordConverter.this.newConverter(events, schemaType, matchingThrift).asGroupConverter(), matchingThrift, events);
            }
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void start() {
            this.events.add(this.readStructBegin);
        }

        public void end() {
            this.events.add(this.readFieldStop);
            this.events.add(this.readStructEnd);
        }
    }

    class ElementConverter
    extends GroupConverter {
        private Converter elementConverter;
        private List<TProtocol> listEvents;
        private List<TProtocol> elementEvents;
        private int nullElementCount;

        public ElementConverter(String listName, List<TProtocol> listEvents, GroupType repeatedType, ThriftField thriftElement) {
            this.listEvents = listEvents;
            this.elementEvents = new ArrayList<TProtocol>();
            Type elementType = repeatedType.getType(0);
            if (elementType.isRepetition(Type.Repetition.OPTIONAL)) {
                if (ThriftRecordConverter.this.ignoreNullElements) {
                    LOG.warn("List " + listName + " has optional elements: null elements are ignored.");
                } else {
                    throw new ParquetDecodingException("Cannot read list " + listName + " with optional elements: set " + ThriftRecordConverter.IGNORE_NULL_LIST_ELEMENTS + " to ignore nulls.");
                }
            }
            this.elementConverter = ThriftRecordConverter.this.newConverter(this.elementEvents, elementType, thriftElement);
        }

        public Converter getConverter(int fieldIndex) {
            Preconditions.checkArgument((fieldIndex == 0 ? 1 : 0) != 0, (String)"Illegal field index: %s", (Object[])new Object[]{fieldIndex});
            return this.elementConverter;
        }

        public void start() {
            this.elementEvents.clear();
        }

        public void end() {
            if (this.elementEvents.size() > 0) {
                this.listEvents.addAll(this.elementEvents);
            } else {
                ++this.nullElementCount;
            }
        }

        public int getNullElementCount() {
            return this.nullElementCount;
        }
    }

    abstract class CollectionConverter
    extends GroupConverter {
        private ElementConverter elementConverter = null;
        private final Converter child;
        private final Counter childCounter;
        private List<TProtocol> listEvents = new ArrayList<TProtocol>();
        private final List<TProtocol> parentEvents;
        private ThriftTypeID valuesType;

        CollectionConverter(List<TProtocol> parentEvents, GroupType parquetSchema, ThriftField values) {
            this.parentEvents = parentEvents;
            if (parquetSchema.getFieldCount() != 1) {
                throw new IllegalArgumentException("lists have only one field. " + parquetSchema + " size = " + parquetSchema.getFieldCount());
            }
            Type repeatedType = parquetSchema.getType(0);
            this.valuesType = values.getType().getType();
            if (ThriftSchemaConverter.isListElementType(repeatedType, values)) {
                if (repeatedType.isPrimitive()) {
                    PrimitiveCounter counter = new PrimitiveCounter(ThriftRecordConverter.this.newConverter(this.listEvents, repeatedType, values).asPrimitiveConverter());
                    this.child = counter;
                    this.childCounter = counter;
                } else {
                    GroupCounter counter = new GroupCounter(ThriftRecordConverter.this.newConverter(this.listEvents, repeatedType, values).asGroupConverter());
                    this.child = counter;
                    this.childCounter = counter;
                }
            } else {
                this.elementConverter = new ElementConverter(parquetSchema.getName(), this.listEvents, repeatedType.asGroupType(), values);
                GroupCounter counter = new GroupCounter(this.elementConverter);
                this.child = counter;
                this.childCounter = counter;
            }
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex != 0) {
                throw new IllegalArgumentException("lists have only one field. can't reach " + fieldIndex);
            }
            return this.child;
        }

        public void start() {
            this.childCounter.startCounting();
        }

        public void end() {
            int count = this.childCounter.getCount();
            if (this.elementConverter != null) {
                count -= this.elementConverter.getNullElementCount();
            }
            this.collectionStart(count, this.valuesType.getThriftType());
            this.parentEvents.addAll(this.listEvents);
            this.listEvents.clear();
            this.collectionEnd();
        }

        abstract void collectionStart(int var1, byte var2);

        abstract void collectionEnd();
    }

    class ListConverter
    extends CollectionConverter {
        final ParquetProtocol readListEnd;
        private final List<TProtocol> parentEvents;

        ListConverter(List<TProtocol> parentEvents, GroupType parquetSchema, ThriftField field) {
            super(parentEvents, parquetSchema, ((ThriftType.ListType)field.getType()).getValues());
            this.readListEnd = new ParquetProtocol("readListEnd()"){

                @Override
                public void readListEnd() throws TException {
                }
            };
            this.parentEvents = parentEvents;
        }

        @Override
        void collectionStart(final int count, final byte type) {
            this.parentEvents.add(new ParquetProtocol("readListBegin()"){

                @Override
                public TList readListBegin() throws TException {
                    return new TList(type, count);
                }
            });
        }

        @Override
        void collectionEnd() {
            this.parentEvents.add(this.readListEnd);
        }
    }

    class SetConverter
    extends CollectionConverter {
        final ParquetProtocol readSetEnd;
        private final List<TProtocol> parentEvents;

        public SetConverter(List<TProtocol> parentEvents, GroupType parquetSchema, ThriftField field) {
            super(parentEvents, parquetSchema, ((ThriftType.SetType)field.getType()).getValues());
            this.readSetEnd = new ParquetProtocol("readSetEnd()"){

                @Override
                public void readSetEnd() throws TException {
                }
            };
            this.parentEvents = parentEvents;
        }

        @Override
        void collectionStart(final int count, final byte type) {
            this.parentEvents.add(new ParquetProtocol("readSetBegin()"){

                @Override
                public TSet readSetBegin() throws TException {
                    return new TSet(type, count);
                }
            });
        }

        @Override
        void collectionEnd() {
            this.parentEvents.add(this.readSetEnd);
        }
    }

    class MapKeyValueConverter
    extends GroupConverter {
        private Converter keyConverter;
        private Converter valueConverter;

        public MapKeyValueConverter(List<TProtocol> mapEvents, Type nestedType, ThriftField key, ThriftField value) {
            this.keyConverter = ThriftRecordConverter.this.newConverter(mapEvents, nestedType.asGroupType().getType(0), key);
            this.valueConverter = ThriftRecordConverter.this.newConverter(mapEvents, nestedType.asGroupType().getType(1), value);
        }

        public Converter getConverter(int fieldIndex) {
            switch (fieldIndex) {
                case 0: {
                    return this.keyConverter;
                }
                case 1: {
                    return this.valueConverter;
                }
            }
            throw new IllegalArgumentException("only key (0) and value (1) are supported. got " + fieldIndex);
        }

        public void start() {
        }

        public void end() {
        }
    }

    class MapConverter
    extends GroupConverter {
        private final GroupCounter child;
        private final List<TProtocol> mapEvents = new ArrayList<TProtocol>();
        private final List<TProtocol> parentEvents;
        private final byte keyType;
        private final byte valueType;
        final ParquetProtocol readMapEnd = new ParquetProtocol("readMapEnd()"){

            @Override
            public void readMapEnd() throws TException {
            }
        };

        MapConverter(List<TProtocol> parentEvents, GroupType parquetSchema, ThriftField field) {
            this.parentEvents = parentEvents;
            if (parquetSchema.getFieldCount() != 1) {
                throw new IllegalArgumentException("maps have only one field. " + parquetSchema + " size = " + parquetSchema.getFieldCount());
            }
            Type nestedType = parquetSchema.getType(0);
            ThriftField key = ((ThriftType.MapType)field.getType()).getKey();
            this.keyType = key.getType().getType().getThriftType();
            ThriftField value = ((ThriftType.MapType)field.getType()).getValue();
            this.valueType = value.getType().getType().getThriftType();
            this.child = new GroupCounter(new MapKeyValueConverter(this.mapEvents, nestedType, key, value));
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex != 0) {
                throw new IllegalArgumentException("lists have only one field. can't reach " + fieldIndex);
            }
            return this.child;
        }

        public void start() {
            this.child.startCounting();
        }

        public void end() {
            final int count = this.child.getCount();
            this.parentEvents.add(new ParquetProtocol("readMapBegin()"){

                @Override
                public TMap readMapBegin() throws TException {
                    return new TMap(MapConverter.this.keyType, MapConverter.this.valueType, count);
                }
            });
            this.parentEvents.addAll(this.mapEvents);
            this.mapEvents.clear();
            this.parentEvents.add(this.readMapEnd);
        }
    }

    static class FieldEnumConverter
    extends PrimitiveConverter {
        private final List<TProtocol> events;
        private final Map<Binary, Integer> enumLookup = new HashMap<Binary, Integer>();
        private final ThriftField field;

        public FieldEnumConverter(List<TProtocol> events, ThriftField field) {
            this.events = events;
            this.field = field;
            Iterable<ThriftType.EnumValue> values = ((ThriftType.EnumType)field.getType()).getValues();
            for (ThriftType.EnumValue enumValue : values) {
                this.enumLookup.put(Binary.fromString((String)enumValue.getName()), enumValue.getId());
            }
        }

        public void addBinary(Binary value) {
            final Integer id = this.enumLookup.get(value);
            if (id == null) {
                throw new ParquetDecodingException("Unrecognized enum value: " + value.toStringUsingUTF8() + " known values: " + this.enumLookup + " in " + this.field);
            }
            this.events.add(new ParquetProtocol("readI32() enum"){

                @Override
                public int readI32() throws TException {
                    return id;
                }
            });
        }
    }

    static class FieldStringConverter
    extends PrimitiveConverter {
        private final List<TProtocol> events;

        public FieldStringConverter(List<TProtocol> events, ThriftField field) {
            this.events = events;
        }

        public void addBinary(final Binary value) {
            this.events.add(new ParquetProtocol("readString() binary"){

                @Override
                public String readString() throws TException {
                    return value.toStringUsingUTF8();
                }

                @Override
                public ByteBuffer readBinary() throws TException {
                    return value.toByteBuffer();
                }
            });
        }
    }

    static class FieldPrimitiveConverter
    extends PrimitiveConverter {
        private final List<TProtocol> events;
        private ThriftTypeID type;

        public FieldPrimitiveConverter(List<TProtocol> events, ThriftField field) {
            this.events = events;
            this.type = field.getType().getType();
        }

        public void addBoolean(final boolean value) {
            this.events.add(new ParquetProtocol("readBool()"){

                @Override
                public boolean readBool() throws TException {
                    return value;
                }
            });
        }

        public void addDouble(final double value) {
            this.events.add(new ParquetProtocol("readDouble()"){

                @Override
                public double readDouble() throws TException {
                    return value;
                }
            });
        }

        public void addFloat(final float value) {
            this.events.add(new ParquetProtocol("readDouble() float"){

                @Override
                public double readDouble() throws TException {
                    return value;
                }
            });
        }

        public void addInt(final int value) {
            switch (this.type) {
                case BYTE: {
                    this.events.add(new ParquetProtocol("readByte() int"){

                        @Override
                        public byte readByte() throws TException {
                            return (byte)value;
                        }
                    });
                    break;
                }
                case I16: {
                    this.events.add(new ParquetProtocol("readI16()"){

                        @Override
                        public short readI16() throws TException {
                            return (short)value;
                        }
                    });
                    break;
                }
                case I32: {
                    this.events.add(new ParquetProtocol("readI32()"){

                        @Override
                        public int readI32() throws TException {
                            return value;
                        }
                    });
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not convertible type " + (Object)((Object)this.type));
                }
            }
        }

        public void addLong(final long value) {
            this.events.add(new ParquetProtocol("readI64()"){

                @Override
                public long readI64() throws TException {
                    return value;
                }
            });
        }
    }

    static class PrimitiveCounter
    extends PrimitiveConverter
    implements Counter {
        private final PrimitiveConverter delegate;
        private int count;

        public PrimitiveCounter(PrimitiveConverter delegate) {
            this.delegate = delegate;
        }

        public void addBinary(Binary value) {
            this.delegate.addBinary(value);
            ++this.count;
        }

        public void addBoolean(boolean value) {
            this.delegate.addBoolean(value);
            ++this.count;
        }

        public void addDouble(double value) {
            this.delegate.addDouble(value);
            ++this.count;
        }

        public void addFloat(float value) {
            this.delegate.addFloat(value);
            ++this.count;
        }

        public void addInt(int value) {
            this.delegate.addInt(value);
            ++this.count;
        }

        public void addLong(long value) {
            this.delegate.addLong(value);
            ++this.count;
        }

        @Override
        public void startCounting() {
            this.count = 0;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    static class GroupCounter
    extends GroupConverter
    implements Counter {
        private final GroupConverter delegate;
        private int count;

        public GroupCounter(GroupConverter delegate) {
            this.delegate = delegate;
        }

        public Converter getConverter(int fieldIndex) {
            return this.delegate.getConverter(fieldIndex);
        }

        public void start() {
            this.delegate.start();
        }

        public void end() {
            this.delegate.end();
            ++this.count;
        }

        @Override
        public void startCounting() {
            this.count = 0;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }

    static interface Counter {
        public void startCounting();

        public int getCount();
    }

    static class GroupFieldhandler
    extends GroupConverter {
        private final GroupConverter delegate;
        private final List<TProtocol> events;
        private final ParquetProtocol readFieldBegin;

        public GroupFieldhandler(GroupConverter delegate, final ThriftField field, List<TProtocol> events) {
            this.delegate = delegate;
            this.events = events;
            this.readFieldBegin = new ParquetProtocol("readFieldBegin()"){

                @Override
                public TField readFieldBegin() throws TException {
                    return new TField(field.getName(), field.getType().getType().getThriftType(), field.getFieldId());
                }
            };
        }

        public Converter getConverter(int fieldIndex) {
            return this.delegate.getConverter(fieldIndex);
        }

        public void start() {
            this.events.add(this.readFieldBegin);
            this.delegate.start();
        }

        public void end() {
            this.delegate.end();
            this.events.add(readFieldEnd);
        }
    }

    static class PrimitiveFieldHandler
    extends PrimitiveConverter {
        private final PrimitiveConverter delegate;
        private final List<TProtocol> events;
        private final ParquetProtocol readFieldBegin;

        private void startField() {
            this.events.add(this.readFieldBegin);
        }

        private void endField() {
            this.events.add(readFieldEnd);
        }

        public PrimitiveFieldHandler(PrimitiveConverter delegate, final ThriftField field, List<TProtocol> events) {
            this.delegate = delegate;
            this.events = events;
            final byte thriftType = field.getType().getType() == ThriftTypeID.ENUM ? ThriftTypeID.I32.getThriftType() : field.getType().getType().getThriftType();
            this.readFieldBegin = new ParquetProtocol("readFieldBegin()"){

                @Override
                public TField readFieldBegin() throws TException {
                    return new TField(field.getName(), thriftType, field.getFieldId());
                }
            };
        }

        public void addBinary(Binary value) {
            this.startField();
            this.delegate.addBinary(value);
            this.endField();
        }

        public void addBoolean(boolean value) {
            this.startField();
            this.delegate.addBoolean(value);
            this.endField();
        }

        public void addDouble(double value) {
            this.startField();
            this.delegate.addDouble(value);
            this.endField();
        }

        public void addFloat(float value) {
            this.startField();
            this.delegate.addFloat(value);
            this.endField();
        }

        public void addInt(int value) {
            this.startField();
            this.delegate.addInt(value);
            this.endField();
        }

        public void addLong(long value) {
            this.startField();
            this.delegate.addLong(value);
            this.endField();
        }
    }
}

