/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.struct;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.thrift.struct.JSON;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftTypeID;
import shaded.parquet.com.fasterxml.jackson.annotation.JsonCreator;
import shaded.parquet.com.fasterxml.jackson.annotation.JsonIgnore;
import shaded.parquet.com.fasterxml.jackson.annotation.JsonProperty;
import shaded.parquet.com.fasterxml.jackson.annotation.JsonSubTypes;
import shaded.parquet.com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="id")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BoolType.class, name="BOOL"), @JsonSubTypes.Type(value=ByteType.class, name="BYTE"), @JsonSubTypes.Type(value=DoubleType.class, name="DOUBLE"), @JsonSubTypes.Type(value=EnumType.class, name="ENUM"), @JsonSubTypes.Type(value=I16Type.class, name="I16"), @JsonSubTypes.Type(value=I32Type.class, name="I32"), @JsonSubTypes.Type(value=I64Type.class, name="I64"), @JsonSubTypes.Type(value=ListType.class, name="LIST"), @JsonSubTypes.Type(value=MapType.class, name="MAP"), @JsonSubTypes.Type(value=SetType.class, name="SET"), @JsonSubTypes.Type(value=StringType.class, name="STRING"), @JsonSubTypes.Type(value=StructType.class, name="STRUCT")})
public abstract class ThriftType {
    private LogicalTypeAnnotation logicalTypeAnnotation;
    private final ThriftTypeID type;

    public boolean hasLogicalTypeAnnotation() {
        return this.logicalTypeAnnotation != null;
    }

    public LogicalTypeAnnotation getLogicalTypeAnnotation() {
        return this.logicalTypeAnnotation;
    }

    public void setLogicalTypeAnnotation(LogicalTypeAnnotation logicalTypeAnnotation) {
        this.logicalTypeAnnotation = logicalTypeAnnotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThriftType)) {
            return false;
        }
        ThriftType that = (ThriftType)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public static ThriftType fromJSON(String json) {
        return JSON.fromJSON(json, ThriftType.class);
    }

    public String toJSON() {
        return JSON.toJSON(this);
    }

    public String toString() {
        return this.toJSON();
    }

    private ThriftType(ThriftTypeID type) {
        this.type = type;
    }

    public abstract void accept(TypeVisitor var1);

    public abstract <R, S> R accept(StateVisitor<R, S> var1, S var2);

    @JsonIgnore
    public ThriftTypeID getType() {
        return this.type;
    }

    public static class StringType
    extends ThriftType {
        private boolean binary = false;

        @JsonCreator
        public StringType() {
            super(ThriftTypeID.STRING);
        }

        public boolean isBinary() {
            return this.binary;
        }

        public void setBinary(boolean binary) {
            this.binary = binary;
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class I64Type
    extends ThriftType {
        @JsonCreator
        public I64Type() {
            super(ThriftTypeID.I64);
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class I32Type
    extends ThriftType {
        @JsonCreator
        public I32Type() {
            super(ThriftTypeID.I32);
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class I16Type
    extends ThriftType {
        @JsonCreator
        public I16Type() {
            super(ThriftTypeID.I16);
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class DoubleType
    extends ThriftType {
        @JsonCreator
        public DoubleType() {
            super(ThriftTypeID.DOUBLE);
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ByteType
    extends ThriftType {
        @JsonCreator
        public ByteType() {
            super(ThriftTypeID.BYTE);
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BoolType
    extends ThriftType {
        @JsonCreator
        public BoolType() {
            super(ThriftTypeID.BOOL);
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class EnumType
    extends ThriftType {
        private final List<EnumValue> values;
        private Map<Integer, EnumValue> idEnumLookup;

        @JsonCreator
        public EnumType(@JsonProperty(value="values") List<EnumValue> values) {
            super(ThriftTypeID.ENUM);
            this.values = values;
        }

        public Iterable<EnumValue> getValues() {
            return new Iterable<EnumValue>(){

                @Override
                public Iterator<EnumValue> iterator() {
                    return values.iterator();
                }
            };
        }

        public EnumValue getEnumValueById(int id) {
            this.prepareEnumLookUp();
            return this.idEnumLookup.get(id);
        }

        private void prepareEnumLookUp() {
            if (this.idEnumLookup == null) {
                this.idEnumLookup = new HashMap<Integer, EnumValue>();
                for (EnumValue value : this.values) {
                    this.idEnumLookup.put(value.getId(), value);
                }
            }
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EnumType)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EnumType enumType = (EnumType)o;
            return this.values.equals(enumType.values);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.values.hashCode();
            return result;
        }
    }

    public static class EnumValue {
        private final int id;
        private final String name;

        @JsonCreator
        public EnumValue(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EnumValue)) {
                return false;
            }
            EnumValue enumValue = (EnumValue)o;
            if (this.id != enumValue.id) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(enumValue.name) : enumValue.name != null);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }

    public static class ListType
    extends ThriftType {
        private final ThriftField values;

        @JsonCreator
        public ListType(@JsonProperty(value="values") ThriftField values) {
            super(ThriftTypeID.LIST);
            this.values = values;
        }

        public ThriftField getValues() {
            return this.values;
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListType)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ListType listType = (ListType)o;
            return this.values.equals(listType.values);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.values.hashCode();
            return result;
        }
    }

    public static class SetType
    extends ThriftType {
        private final ThriftField values;

        @JsonCreator
        public SetType(@JsonProperty(value="values") ThriftField values) {
            super(ThriftTypeID.SET);
            this.values = values;
        }

        public ThriftField getValues() {
            return this.values;
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetType)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SetType setType = (SetType)o;
            return this.values.equals(setType.values);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.values.hashCode();
            return result;
        }
    }

    public static class MapType
    extends ThriftType {
        private final ThriftField key;
        private final ThriftField value;

        @JsonCreator
        public MapType(@JsonProperty(value="key") ThriftField key, @JsonProperty(value="value") ThriftField value) {
            super(ThriftTypeID.MAP);
            this.key = key;
            this.value = value;
        }

        public ThriftField getKey() {
            return this.key;
        }

        public ThriftField getValue() {
            return this.value;
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MapType)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MapType mapType = (MapType)o;
            if (!this.key.equals(mapType.key)) {
                return false;
            }
            return this.value.equals(mapType.value);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    public static class StructType
    extends ThriftType {
        private final List<ThriftField> children;
        private final ThriftField[] childById;
        private final StructOrUnionType structOrUnionType;

        @Deprecated
        public StructType(List<ThriftField> children) {
            this(children, null);
        }

        @JsonCreator
        public StructType(@JsonProperty(value="children") List<ThriftField> children, @JsonProperty(value="structOrUnionType") StructOrUnionType structOrUnionType) {
            super(ThriftTypeID.STRUCT);
            this.structOrUnionType = structOrUnionType == null ? StructOrUnionType.STRUCT : structOrUnionType;
            this.children = children;
            int maxId = 0;
            if (children != null) {
                for (ThriftField thriftField : children) {
                    maxId = Math.max(maxId, thriftField.getFieldId());
                }
                this.childById = new ThriftField[maxId + 1];
                Iterator<ThriftField> iterator = children.iterator();
                while (iterator.hasNext()) {
                    ThriftField thriftField;
                    this.childById[thriftField.getFieldId()] = thriftField = iterator.next();
                }
            } else {
                this.childById = null;
            }
        }

        public List<ThriftField> getChildren() {
            return this.children;
        }

        @JsonIgnore
        public ThriftField getChildById(short id) {
            if (id >= this.childById.length) {
                return null;
            }
            return this.childById[id];
        }

        @JsonProperty(value="structOrUnionType")
        public StructOrUnionType getStructOrUnionType() {
            return this.structOrUnionType;
        }

        @Override
        public <R, S> R accept(StateVisitor<R, S> visitor, S state) {
            return visitor.visit(this, state);
        }

        @Override
        public void accept(TypeVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructType that = (StructType)o;
            return Arrays.equals(this.childById, that.childById);
        }

        @Override
        public int hashCode() {
            int result = this.childById != null ? Arrays.hashCode(this.childById) : 0;
            return result;
        }

        public static enum StructOrUnionType {
            STRUCT,
            UNION,
            UNKNOWN;

        }
    }

    @Deprecated
    public static abstract class ComplexTypeVisitor
    implements TypeVisitor {
        @Override
        public final void visit(EnumType enumType) {
            throw new IllegalArgumentException("Expected complex type");
        }

        @Override
        public final void visit(BoolType boolType) {
            throw new IllegalArgumentException("Expected complex type");
        }

        @Override
        public final void visit(ByteType byteType) {
            throw new IllegalArgumentException("Expected complex type");
        }

        @Override
        public final void visit(DoubleType doubleType) {
            throw new IllegalArgumentException("Expected complex type");
        }

        @Override
        public final void visit(I16Type i16Type) {
            throw new IllegalArgumentException("Expected complex type");
        }

        @Override
        public final void visit(I32Type i32Type) {
            throw new IllegalArgumentException("Expected complex type");
        }

        @Override
        public final void visit(I64Type i64Type) {
            throw new IllegalArgumentException("Expected complex type");
        }

        @Override
        public final void visit(StringType stringType) {
            throw new IllegalArgumentException("Expected complex type");
        }
    }

    public static interface TypeVisitor {
        public void visit(MapType var1);

        public void visit(SetType var1);

        public void visit(ListType var1);

        public void visit(StructType var1);

        public void visit(EnumType var1);

        public void visit(BoolType var1);

        public void visit(ByteType var1);

        public void visit(DoubleType var1);

        public void visit(I16Type var1);

        public void visit(I32Type var1);

        public void visit(I64Type var1);

        public void visit(StringType var1);
    }

    public static interface StateVisitor<R, S> {
        public R visit(MapType var1, S var2);

        public R visit(SetType var1, S var2);

        public R visit(ListType var1, S var2);

        public R visit(StructType var1, S var2);

        public R visit(EnumType var1, S var2);

        public R visit(BoolType var1, S var2);

        public R visit(ByteType var1, S var2);

        public R visit(DoubleType var1, S var2);

        public R visit(I16Type var1, S var2);

        public R visit(I32Type var1, S var2);

        public R visit(I64Type var1, S var2);

        public R visit(StringType var1, S var2);
    }
}

