/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.DirectWriterTest;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.thrift.ThriftParquetReader;
import org.apache.parquet.thrift.test.compat.ListOfCounts;
import org.apache.parquet.thrift.test.compat.ListOfInts;
import org.apache.parquet.thrift.test.compat.ListOfLists;
import org.apache.parquet.thrift.test.compat.ListOfLocations;
import org.apache.parquet.thrift.test.compat.ListOfSingleElementGroups;
import org.apache.parquet.thrift.test.compat.Location;
import org.apache.parquet.thrift.test.compat.SingleElementGroup;
import org.apache.thrift.TBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestArrayCompatibility
extends DirectWriterTest {
    @Test
    @Ignore(value="Not yet supported")
    public void testUnannotatedListOfPrimitives() throws Exception {
        Path test = this.writeDirect("message UnannotatedListOfPrimitives {  repeated int32 list_of_ints;}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_ints", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("list_of_ints", 0);
                rc.endMessage();
            }
        });
    }

    @Test
    @Ignore(value="Not yet supported")
    public void testUnannotatedListOfGroups() throws Exception {
        Path test = this.writeDirect("message UnannotatedListOfGroups {  repeated group list_of_points {    required float x;    required float y;  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_points", 0);
                rc.startGroup();
                rc.startField("x", 0);
                rc.addFloat(1.0f);
                rc.endField("x", 0);
                rc.startField("y", 1);
                rc.addFloat(1.0f);
                rc.endField("y", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("x", 0);
                rc.addFloat(2.0f);
                rc.endField("x", 0);
                rc.startField("y", 1);
                rc.addFloat(2.0f);
                rc.endField("y", 1);
                rc.endGroup();
                rc.endField("list_of_points", 0);
                rc.endMessage();
            }
        });
    }

    @Test
    public void testRepeatedPrimitiveInList() throws Exception {
        Path test = this.writeDirect("message RepeatedPrimitiveInList {  required group list_of_ints (LIST) {    repeated int32 array;  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_ints", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("list_of_ints", 0);
                rc.endMessage();
            }
        });
        ListOfInts expected = new ListOfInts(Lists.newArrayList((Object[])new Integer[]{34, 35, 36}));
        ListOfInts actual = (ListOfInts)this.reader(test, ListOfInts.class).read();
        Assert.assertEquals((String)"Should read record correctly", (Object)expected, (Object)actual);
    }

    @Test
    public void testMultiFieldGroupInList() throws Exception {
        Path test = this.writeDirect("message MultiFieldGroupInList {  optional group locations (LIST) {    repeated group element {      required double latitude;      required double longitude;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ListOfLocations expected = new ListOfLocations();
        expected.addToLocations(new Location(0.0, 0.0));
        expected.addToLocations(new Location(0.0, 180.0));
        this.assertReaderContains(this.reader(test, ListOfLocations.class), expected);
    }

    @Test
    public void testSingleFieldGroupInList() throws Exception {
        Path test = this.writeDirect("message SingleFieldGroupInList {  optional group single_element_groups (LIST) {    repeated group single_element_group {      required int64 count;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("single_element_groups", 0);
                rc.startGroup();
                rc.startField("single_element_group", 0);
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(1234L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(2345L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.endField("single_element_group", 0);
                rc.endGroup();
                rc.endField("single_element_groups", 0);
                rc.endMessage();
            }
        });
        ListOfSingleElementGroups expectedOldBehavior = new ListOfSingleElementGroups();
        expectedOldBehavior.addToSingle_element_groups(new SingleElementGroup(1234L));
        expectedOldBehavior.addToSingle_element_groups(new SingleElementGroup(2345L));
        this.assertReaderContains(this.reader(test, ListOfSingleElementGroups.class), expectedOldBehavior);
        ListOfCounts expectedNewBehavior = new ListOfCounts();
        expectedNewBehavior.addToSingle_element_groups(1234L);
        expectedNewBehavior.addToSingle_element_groups(2345L);
        this.assertReaderContains(this.reader(test, ListOfCounts.class), expectedNewBehavior);
    }

    @Test
    public void testNewOptionalGroupInList() throws Exception {
        Path test = this.writeDirect("message NewOptionalGroupInList {  optional group locations (LIST) {    repeated group list {      optional group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ListOfLocations expected = new ListOfLocations();
        expected.addToLocations(new Location(0.0, 0.0));
        expected.addToLocations(new Location(0.0, 180.0));
        try {
            this.assertReaderContains(this.reader(test, ListOfLocations.class), expected);
            Assert.fail((String)"Should fail: locations are optional and not ignored");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getCause().getCause().getMessage().contains("locations"));
        }
        this.assertReaderContains(this.readerIgnoreNulls(test, ListOfLocations.class), expected);
    }

    @Test
    public void testNewRequiredGroupInList() throws Exception {
        Path test = this.writeDirect("message NewRequiredGroupInList {  optional group locations (LIST) {    repeated group list {      required group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ListOfLocations expected = new ListOfLocations();
        expected.addToLocations(new Location(0.0, 180.0));
        expected.addToLocations(new Location(0.0, 0.0));
        this.assertReaderContains(this.reader(test, ListOfLocations.class), expected);
    }

    @Test
    public void testAvroCompatRequiredGroupInList() throws Exception {
        Path test = this.writeDirect("message AvroCompatRequiredGroupInList {  optional group locations (LIST) {    repeated group array {      required group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(90.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(-90.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ListOfLocations expected = new ListOfLocations();
        expected.addToLocations(new Location(90.0, 180.0));
        expected.addToLocations(new Location(-90.0, 0.0));
        this.assertReaderContains(this.reader(test, ListOfLocations.class), expected);
    }

    @Test
    public void testAvroCompatListInList() throws Exception {
        Path test = this.writeDirect("message AvroCompatListInList {  optional group listOfLists (LIST) {    repeated group array (LIST) {      repeated int32 array;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("array", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.startGroup();
                rc.startField("array", 0);
                rc.addInteger(32);
                rc.addInteger(33);
                rc.addInteger(34);
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ListOfLists expected = new ListOfLists();
        expected.addToListOfLists(Arrays.asList(34, 35, 36));
        expected.addToListOfLists(Arrays.asList(new Integer[0]));
        expected.addToListOfLists(Arrays.asList(32, 33, 34));
        this.assertReaderContains(this.reader(test, ListOfLists.class), expected);
    }

    @Test
    public void testThriftCompatListInList() throws Exception {
        Path test = this.writeDirect("message ThriftCompatListInList {  optional group listOfLists (LIST) {    repeated group listOfLists_tuple (LIST) {      repeated int32 listOfLists_tuple_tuple;    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("listOfLists_tuple", 0);
                rc.startGroup();
                rc.startField("listOfLists_tuple_tuple", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("listOfLists_tuple_tuple", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.startGroup();
                rc.startField("listOfLists_tuple_tuple", 0);
                rc.addInteger(32);
                rc.addInteger(33);
                rc.addInteger(34);
                rc.endField("listOfLists_tuple_tuple", 0);
                rc.endGroup();
                rc.endField("listOfLists_tuple", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ListOfLists expected = new ListOfLists();
        expected.addToListOfLists(Arrays.asList(34, 35, 36));
        expected.addToListOfLists(Arrays.asList(new Integer[0]));
        expected.addToListOfLists(Arrays.asList(32, 33, 34));
        this.assertReaderContains(this.reader(test, ListOfLists.class), expected);
    }

    @Test
    public void testOldThriftCompatRequiredGroupInList() throws Exception {
        Path test = this.writeDirect("message OldThriftCompatRequiredGroupInList {  optional group locations (LIST) {    repeated group locations_tuple {      required group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("locations_tuple", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("locations_tuple", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ListOfLocations expected = new ListOfLocations();
        expected.addToLocations(new Location(0.0, 180.0));
        expected.addToLocations(new Location(0.0, 0.0));
        this.assertReaderContains(this.reader(test, ListOfLocations.class), expected);
    }

    @Test
    public void testHiveCompatOptionalGroupInList() throws Exception {
        Path test = this.writeDirect("message HiveCompatOptionalGroupInList {  optional group locations (LIST) {    repeated group bag {      optional group element {        required double latitude;        required double longitude;      }    }  }}", new DirectWriterTest.DirectWriter(){

            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("bag", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("bag", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ListOfLocations expected = new ListOfLocations();
        expected.addToLocations(new Location(0.0, 180.0));
        expected.addToLocations(new Location(0.0, 0.0));
        try {
            this.assertReaderContains(this.reader(test, ListOfLocations.class), expected);
            Assert.fail((String)"Should fail: locations are optional and not ignored");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getCause().getCause().getMessage().contains("locations"));
        }
        this.assertReaderContains(this.readerIgnoreNulls(test, ListOfLocations.class), expected);
    }

    public <T extends TBase<?, ?>> ParquetReader<T> reader(Path file, Class<T> thriftClass) throws IOException {
        return ThriftParquetReader.build((Path)file).withThriftClass(thriftClass).build();
    }

    public <T extends TBase<?, ?>> ParquetReader<T> readerIgnoreNulls(Path file, Class<T> thriftClass) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.thrift.ignore-null-elements", true);
        return ThriftParquetReader.build((Path)file).withThriftClass(thriftClass).withConf(conf).build();
    }

    public <T> void assertReaderContains(ParquetReader<T> reader, T ... expected) throws IOException {
        Object record;
        ArrayList actual = Lists.newArrayList();
        while ((record = reader.read()) != null) {
            actual.add(record);
        }
        Assert.assertEquals((String)"Should match exepected records", (Object)Lists.newArrayList((Object[])expected), (Object)actual);
    }
}

