/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.apache.parquet.thrift.ThriftParquetReader;
import org.apache.parquet.thrift.ThriftParquetWriter;
import org.apache.parquet.thrift.test.binary.StringAndBinary;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestBinary {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();

    @Test
    public void testBinary() throws IOException {
        StringAndBinary expected = new StringAndBinary("test", ByteBuffer.wrap(new byte[]{-123, 20, 33}));
        File temp = this.tempDir.newFile(UUID.randomUUID().toString());
        temp.deleteOnExit();
        temp.delete();
        Path path = new Path(temp.getPath());
        ThriftParquetWriter writer = new ThriftParquetWriter(path, StringAndBinary.class, CompressionCodecName.SNAPPY);
        writer.write((Object)expected);
        writer.close();
        ParquetReader reader = ThriftParquetReader.build((Path)path).withThriftClass(StringAndBinary.class).build();
        StringAndBinary record = (StringAndBinary)reader.read();
        reader.close();
        this.assertSchema(ParquetFileReader.readFooter((Configuration)new Configuration(), (Path)path));
        Assert.assertEquals((String)"Should match after serialization round trip", (Object)expected, (Object)record);
    }

    private void assertSchema(ParquetMetadata parquetMetadata) {
        List fields = parquetMetadata.getFileMetaData().getSchema().getFields();
        Assert.assertEquals((long)2L, (long)fields.size());
        Assert.assertEquals((Object)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).id(1)).named("s"), fields.get(0));
        Assert.assertEquals((Object)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).id(2)).named("b"), fields.get(1));
    }
}

