/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.thrift.ParquetThriftInputFormat;
import org.apache.parquet.hadoop.thrift.TestInputOutputFormat;
import org.apache.parquet.thrift.ThriftParquetWriter;
import org.apache.parquet.thrift.test.compat.ABool;
import org.apache.parquet.thrift.test.compat.ALong;
import org.apache.parquet.thrift.test.compat.AString;
import org.apache.parquet.thrift.test.compat.AStructThatLooksLikeUnionV2;
import org.apache.parquet.thrift.test.compat.StructWithAStructThatLooksLikeUnionV2;
import org.apache.parquet.thrift.test.compat.StructWithUnionV2;
import org.apache.parquet.thrift.test.compat.UnionV2;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestCorruptThriftRecords {
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();

    public static StructWithAStructThatLooksLikeUnionV2 makeValid(int i) {
        AStructThatLooksLikeUnionV2 validUnion = new AStructThatLooksLikeUnionV2();
        switch (i % 3) {
            case 0: {
                validUnion.setALong(new ALong(17L));
                break;
            }
            case 1: {
                validUnion.setANewBool(new ABool(false));
                break;
            }
            case 2: {
                validUnion.setAString(new AString("bar"));
            }
        }
        return new StructWithAStructThatLooksLikeUnionV2("foo" + i, validUnion);
    }

    public static StructWithUnionV2 makeExpectedValid(int i) {
        UnionV2 validUnion = new UnionV2();
        switch (i % 3) {
            case 0: {
                validUnion.setALong(new ALong(17L));
                break;
            }
            case 1: {
                validUnion.setANewBool(new ABool(false));
                break;
            }
            case 2: {
                validUnion.setAString(new AString("bar"));
            }
        }
        return new StructWithUnionV2("foo" + i, validUnion);
    }

    public static StructWithAStructThatLooksLikeUnionV2 makeInvalid(int i) {
        AStructThatLooksLikeUnionV2 invalid = new AStructThatLooksLikeUnionV2();
        if (i % 2 == 0) {
            invalid.setALong(new ALong(18L));
            invalid.setANewBool(new ABool(false));
        }
        return new StructWithAStructThatLooksLikeUnionV2("foo" + i, invalid);
    }

    protected void setupJob(Job job, Path path) throws Exception {
        job.setInputFormatClass(ParquetThriftInputFormat.class);
        ParquetThriftInputFormat.setInputPaths((Job)job, (Path[])new Path[]{path});
        ParquetThriftInputFormat.setThriftClass((Configuration)job.getConfiguration(), StructWithUnionV2.class);
        job.setMapperClass(ReadMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(NullOutputFormat.class);
    }

    protected void assertEqualsExcepted(List<StructWithUnionV2> expected, List<Object> found) throws Exception {
        Assert.assertEquals(expected, found);
    }

    private Path writeFileWithCorruptRecords(int numCorrupt, List<StructWithUnionV2> collectExpectedRecords) throws Exception {
        StructWithUnionV2 expected;
        StructWithAStructThatLooksLikeUnionV2 valid;
        int i;
        Path outputPath = new Path(new File(this.tempDir.getRoot(), "corrupt_out").getAbsolutePath());
        ThriftParquetWriter writer = new ThriftParquetWriter(outputPath, StructWithAStructThatLooksLikeUnionV2.class, CompressionCodecName.UNCOMPRESSED);
        int numRecords = 0;
        for (i = 0; i < 100; ++i) {
            valid = TestCorruptThriftRecords.makeValid(numRecords);
            expected = TestCorruptThriftRecords.makeExpectedValid(numRecords);
            ++numRecords;
            collectExpectedRecords.add(expected);
            writer.write((Object)valid);
        }
        for (i = 0; i < numCorrupt; ++i) {
            writer.write((Object)TestCorruptThriftRecords.makeInvalid(numRecords++));
        }
        for (i = 0; i < 100; ++i) {
            valid = TestCorruptThriftRecords.makeValid(numRecords);
            expected = TestCorruptThriftRecords.makeExpectedValid(numRecords);
            ++numRecords;
            collectExpectedRecords.add(expected);
            writer.write((Object)valid);
        }
        writer.close();
        return outputPath;
    }

    private void readFile(Path path, Configuration conf, String name) throws Exception {
        Job job = new Job(conf, name);
        this.setupJob(job, path);
        TestInputOutputFormat.waitForJob(job);
    }

    @Test
    public void testDefaultsToNoTolerance() throws Exception {
        ArrayList<StructWithUnionV2> expected = new ArrayList<StructWithUnionV2>();
        try {
            this.readFile(this.writeFileWithCorruptRecords(1, expected), new Configuration(), "testDefaultsToNoTolerance");
            Assert.fail((String)"This should throw");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((long)100L, (long)ReadMapper.records.size());
            this.assertEqualsExcepted(expected.subList(0, 100), ReadMapper.records);
        }
    }

    @Test
    public void testCanTolerateBadRecords() throws Exception {
        Configuration conf = new Configuration();
        conf.setFloat("parquet.read.bad.record.threshold", 0.1f);
        ArrayList<StructWithUnionV2> expected = new ArrayList<StructWithUnionV2>();
        this.readFile(this.writeFileWithCorruptRecords(4, expected), conf, "testCanTolerateBadRecords");
        Assert.assertEquals((long)200L, (long)ReadMapper.records.size());
        this.assertEqualsExcepted(expected, ReadMapper.records);
    }

    @Test
    public void testThrowsWhenTooManyBadRecords() throws Exception {
        Configuration conf = new Configuration();
        conf.setFloat("parquet.read.bad.record.threshold", 0.1f);
        ArrayList<StructWithUnionV2> expected = new ArrayList<StructWithUnionV2>();
        try {
            this.readFile(this.writeFileWithCorruptRecords(300, expected), conf, "testThrowsWhenTooManyBadRecords");
            Assert.fail((String)"This should throw");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((long)100L, (long)ReadMapper.records.size());
            this.assertEqualsExcepted(expected.subList(0, 100), ReadMapper.records);
        }
    }

    public static class ReadMapper<T>
    extends Mapper<Void, T, Void, Void> {
        public static List<Object> records;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            records = new ArrayList<Object>();
        }

        protected void map(Void key, T value, Mapper.Context context) throws IOException, InterruptedException {
            records.add(value);
        }
    }
}

