/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.parquet.hadoop.thrift.ParquetThriftInputFormat;
import org.apache.parquet.hadoop.thrift.ThriftToParquetFileWriter;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.thrift.test.RequiredListFixture;
import org.apache.parquet.thrift.test.RequiredMapFixture;
import org.apache.parquet.thrift.test.RequiredPrimitiveFixture;
import org.apache.parquet.thrift.test.RequiredSetFixture;
import org.apache.parquet.thrift.test.StructWithReorderedOptionalFields;
import org.apache.parquet.thrift.test.compat.MapWithPrimMapValue;
import org.apache.parquet.thrift.test.compat.MapWithStructMapValue;
import org.apache.parquet.thrift.test.compat.MapWithStructValue;
import org.apache.parquet.thrift.test.compat.StructV3;
import org.apache.parquet.thrift.test.compat.StructV4WithExtracStructField;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestParquetToThriftReadWriteAndProjection {
    private static final Logger LOG = LoggerFactory.getLogger(TestParquetToThriftReadWriteAndProjection.class);

    @Test
    public void testThriftOptionalFieldsWithReadProjectionUsingParquetSchema() throws Exception {
        Configuration conf = new Configuration();
        String readProjectionSchema = "message AddressBook {\n  optional group persons {\n    repeated group persons_tuple {\n      required group name {\n        optional binary first_name;\n        optional binary last_name;\n      }\n      optional int32 id;\n    }\n  }\n}";
        conf.set("parquet.read.schema", "message AddressBook {\n  optional group persons {\n    repeated group persons_tuple {\n      required group name {\n        optional binary first_name;\n        optional binary last_name;\n      }\n      optional int32 id;\n    }\n  }\n}");
        AddressBook toWrite = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 0, "bob.roberts@example.com", Arrays.asList(new PhoneNumber("1234567890")))));
        AddressBook toRead = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 0, null, null)));
        this.shouldDoProjection(conf, toWrite, toRead, AddressBook.class);
    }

    @Test
    public void testPullingInRequiredStructWithFilter() throws Exception {
        String projectionFilterDesc = "persons/{id};persons/email";
        AddressBook toWrite = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 0, "bob.roberts@example.com", Arrays.asList(new PhoneNumber("1234567890")))));
        AddressBook toRead = new AddressBook(Arrays.asList(new Person(new Name("", ""), 0, "bob.roberts@example.com", null)));
        this.shouldDoProjectionWithThriftColumnFilter("persons/{id};persons/email", (TBase)toWrite, (TBase)toRead, AddressBook.class);
    }

    @Test
    public void testReorderdOptionalFields() throws Exception {
        String projectionFilter = "**";
        StructWithReorderedOptionalFields toWrite = new StructWithReorderedOptionalFields();
        toWrite.setFieldOne(1);
        toWrite.setFieldTwo(2);
        toWrite.setFieldThree(3);
        this.shouldDoProjectionWithThriftColumnFilter("**", toWrite, toWrite, StructWithReorderedOptionalFields.class);
    }

    @Test
    public void testProjectOutOptionalFields() throws Exception {
        String projectionFilterDesc = "persons/name/*";
        AddressBook toWrite = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 0, "bob.roberts@example.com", Arrays.asList(new PhoneNumber("1234567890")))));
        AddressBook toRead = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 0, null, null)));
        this.shouldDoProjectionWithThriftColumnFilter("persons/name/*", (TBase)toWrite, (TBase)toRead, AddressBook.class);
    }

    @Test
    public void testPullInRequiredMaps() throws Exception {
        String filter = "name";
        HashMap<String, String> mapValue = new HashMap<String, String>();
        mapValue.put("a", "1");
        mapValue.put("b", "2");
        RequiredMapFixture toWrite = new RequiredMapFixture(mapValue);
        toWrite.setName("testName");
        RequiredMapFixture toRead = new RequiredMapFixture(new HashMap<String, String>());
        toRead.setName("testName");
        this.shouldDoProjectionWithThriftColumnFilter(filter, toWrite, toRead, RequiredMapFixture.class);
    }

    @Test
    public void testDropMapValuePrimitive() throws Exception {
        String filter = "mavalue/key";
        HashMap<String, String> mapValue = new HashMap<String, String>();
        mapValue.put("a", "1");
        mapValue.put("b", "2");
        RequiredMapFixture toWrite = new RequiredMapFixture(mapValue);
        toWrite.setName("testName");
        HashMap<String, String> readValue = new HashMap<String, String>();
        readValue.put("a", "1");
        readValue.put("b", "2");
        RequiredMapFixture toRead = new RequiredMapFixture(readValue);
        this.shouldDoProjectionWithThriftColumnFilter(filter, toWrite, toRead, RequiredMapFixture.class);
    }

    private StructV4WithExtracStructField makeStructV4WithExtracStructField(String id) {
        StructV4WithExtracStructField sv4 = new StructV4WithExtracStructField();
        StructV3 sv3 = new StructV3();
        sv3.setAge("age " + id);
        sv3.setGender("gender" + id);
        sv3.setName("inner name " + id);
        sv4.setAge("outer age " + id);
        sv4.setAddedStruct(sv3);
        sv4.setGender("outer gender " + id);
        sv4.setName("outer name " + id);
        return sv4;
    }

    @Test
    public void testDropMapValueStruct() throws Exception {
        String filter = "reqMap/key";
        HashMap<String, StructV4WithExtracStructField> mapValue = new HashMap<String, StructV4WithExtracStructField>();
        StructV4WithExtracStructField v1 = this.makeStructV4WithExtracStructField("1");
        StructV4WithExtracStructField v2 = this.makeStructV4WithExtracStructField("2");
        mapValue.put("key 1", v1);
        mapValue.put("key 2", v2);
        MapWithStructValue toWrite = new MapWithStructValue(mapValue);
        HashMap<String, StructV4WithExtracStructField> readValue = new HashMap<String, StructV4WithExtracStructField>();
        readValue.put("key 1", new StructV4WithExtracStructField("outer name 1"));
        readValue.put("key 2", new StructV4WithExtracStructField("outer name 2"));
        MapWithStructValue toRead = new MapWithStructValue(readValue);
        this.shouldDoProjectionWithThriftColumnFilter(filter, toWrite, toRead, MapWithStructValue.class);
    }

    @Test
    public void testDropMapValueNestedPrim() throws Exception {
        String filter = "reqMap/key";
        HashMap<String, Map<String, String>> mapValue = new HashMap<String, Map<String, String>>();
        HashMap<String, String> innerValue1 = new HashMap<String, String>();
        innerValue1.put("inner key (1, 1)", "inner (1, 1)");
        innerValue1.put("inner key (1, 2)", "inner (1, 2)");
        HashMap<String, String> innerValue2 = new HashMap<String, String>();
        innerValue2.put("inner key (2, 1)", "inner (2, 1)");
        innerValue2.put("inner key (2, 2)", "inner (2, 2)");
        mapValue.put("outer key 1", innerValue1);
        mapValue.put("outer key 2", innerValue2);
        MapWithPrimMapValue toWrite = new MapWithPrimMapValue(mapValue);
        HashMap<String, Map<String, String>> expected = new HashMap<String, Map<String, String>>();
        HashMap<String, String> expectedInnerValue1 = new HashMap<String, String>();
        expectedInnerValue1.put("inner key (1, 1)", "inner (1, 1)");
        expectedInnerValue1.put("inner key (1, 2)", "inner (1, 2)");
        HashMap<String, String> expectedInnerValue2 = new HashMap<String, String>();
        expectedInnerValue2.put("inner key (2, 1)", "inner (2, 1)");
        expectedInnerValue2.put("inner key (2, 2)", "inner (2, 2)");
        expected.put("outer key 1", expectedInnerValue1);
        expected.put("outer key 2", expectedInnerValue2);
        MapWithPrimMapValue toRead = new MapWithPrimMapValue(expected);
        this.shouldDoProjectionWithThriftColumnFilter(filter, toWrite, toRead, MapWithPrimMapValue.class);
    }

    @Test
    public void testDropMapValueNestedStruct() throws Exception {
        String filter = "reqMap/key";
        HashMap<String, Map<String, StructV4WithExtracStructField>> mapValue = new HashMap<String, Map<String, StructV4WithExtracStructField>>();
        HashMap<String, StructV4WithExtracStructField> innerValue1 = new HashMap<String, StructV4WithExtracStructField>();
        innerValue1.put("inner key (1, 1)", this.makeStructV4WithExtracStructField("inner (1, 1)"));
        innerValue1.put("inner key (1, 2)", this.makeStructV4WithExtracStructField("inner (1, 2)"));
        HashMap<String, StructV4WithExtracStructField> innerValue2 = new HashMap<String, StructV4WithExtracStructField>();
        innerValue2.put("inner key (2, 1)", this.makeStructV4WithExtracStructField("inner (2, 1)"));
        innerValue2.put("inner key (2, 2)", this.makeStructV4WithExtracStructField("inner (2, 2)"));
        mapValue.put("outer key 1", innerValue1);
        mapValue.put("outer key 2", innerValue2);
        MapWithStructMapValue toWrite = new MapWithStructMapValue(mapValue);
        HashMap<String, Map<String, StructV4WithExtracStructField>> expected = new HashMap<String, Map<String, StructV4WithExtracStructField>>();
        HashMap<String, StructV4WithExtracStructField> expectedInnerValue1 = new HashMap<String, StructV4WithExtracStructField>();
        expectedInnerValue1.put("inner key (1, 1)", new StructV4WithExtracStructField("outer name inner (1, 1)"));
        expectedInnerValue1.put("inner key (1, 2)", new StructV4WithExtracStructField("outer name inner (1, 2)"));
        HashMap<String, StructV4WithExtracStructField> expectedInnerValue2 = new HashMap<String, StructV4WithExtracStructField>();
        expectedInnerValue2.put("inner key (2, 1)", new StructV4WithExtracStructField("outer name inner (2, 1)"));
        expectedInnerValue2.put("inner key (2, 2)", new StructV4WithExtracStructField("outer name inner (2, 2)"));
        expected.put("outer key 1", expectedInnerValue1);
        expected.put("outer key 2", expectedInnerValue2);
        MapWithStructMapValue toRead = new MapWithStructMapValue(expected);
        this.shouldDoProjectionWithThriftColumnFilter(filter, toWrite, toRead, MapWithStructMapValue.class);
    }

    @Test
    public void testPullInRequiredLists() throws Exception {
        String filter = "info";
        RequiredListFixture toWrite = new RequiredListFixture(Arrays.asList(new org.apache.parquet.thrift.test.Name("first_name")));
        toWrite.setInfo("test_info");
        RequiredListFixture toRead = new RequiredListFixture(new ArrayList<org.apache.parquet.thrift.test.Name>());
        toRead.setInfo("test_info");
        this.shouldDoProjectionWithThriftColumnFilter(filter, toWrite, toRead, RequiredListFixture.class);
    }

    @Test
    public void testPullInRequiredSets() throws Exception {
        String filter = "info";
        RequiredSetFixture toWrite = new RequiredSetFixture(new HashSet<org.apache.parquet.thrift.test.Name>(Arrays.asList(new org.apache.parquet.thrift.test.Name("first_name"))));
        toWrite.setInfo("test_info");
        RequiredSetFixture toRead = new RequiredSetFixture(new HashSet<org.apache.parquet.thrift.test.Name>());
        toRead.setInfo("test_info");
        this.shouldDoProjectionWithThriftColumnFilter(filter, toWrite, toRead, RequiredSetFixture.class);
    }

    @Test
    public void testPullInPrimitiveValues() throws Exception {
        String filter = "info_string";
        RequiredPrimitiveFixture toWrite = new RequiredPrimitiveFixture(true, 2, 3, 4, 5L, 6.0, "7");
        toWrite.setInfo_string("it's info");
        RequiredPrimitiveFixture toRead = new RequiredPrimitiveFixture(false, 0, 0, 0, 0L, 0.0, "");
        toRead.setInfo_string("it's info");
        this.shouldDoProjectionWithThriftColumnFilter(filter, toWrite, toRead, RequiredPrimitiveFixture.class);
    }

    private void shouldDoProjectionWithThriftColumnFilter(String filterDesc, TBase toWrite, TBase toRead, Class<? extends TBase<?, ?>> thriftClass) throws Exception {
        Configuration conf = new Configuration();
        conf.set("parquet.thrift.column.filter", filterDesc);
        this.shouldDoProjection(conf, toWrite, toRead, thriftClass);
    }

    private <T extends TBase<?, ?>> void shouldDoProjection(Configuration conf, T recordToWrite, T exptectedReadResult, Class<? extends TBase<?, ?>> thriftClass) throws Exception {
        Path parquetFile = new Path("target/test/TestParquetToThriftReadWriteAndProjection/file.parquet");
        FileSystem fs = parquetFile.getFileSystem(conf);
        if (fs.exists(parquetFile)) {
            fs.delete(parquetFile, true);
        }
        TCompactProtocol.Factory protocolFactory = new TCompactProtocol.Factory();
        TaskAttemptID taskId = new TaskAttemptID("local", 0, true, 0, 0);
        ThriftToParquetFileWriter w = new ThriftToParquetFileWriter(parquetFile, ContextUtil.newTaskAttemptContext((Configuration)conf, (TaskAttemptID)taskId), (TProtocolFactory)protocolFactory, thriftClass);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TProtocol protocol = protocolFactory.getProtocol((TTransport)new TIOStreamTransport((OutputStream)baos));
        recordToWrite.write(protocol);
        w.write(new BytesWritable(baos.toByteArray()));
        w.close();
        ParquetThriftInputFormat parquetThriftInputFormat = new ParquetThriftInputFormat();
        Job job = new Job(conf, "read");
        job.setInputFormatClass(ParquetThriftInputFormat.class);
        ParquetThriftInputFormat.setInputPaths((Job)job, (Path[])new Path[]{parquetFile});
        JobID jobID = new JobID("local", 1);
        List splits = parquetThriftInputFormat.getSplits(ContextUtil.newJobContext((Configuration)ContextUtil.getConfiguration((JobContext)job), (JobID)jobID));
        TBase readValue = null;
        for (InputSplit split : splits) {
            TaskAttemptContext taskAttemptContext = ContextUtil.newTaskAttemptContext((Configuration)ContextUtil.getConfiguration((JobContext)job), (TaskAttemptID)new TaskAttemptID(new TaskID(jobID, true, 1), 0));
            RecordReader reader = parquetThriftInputFormat.createRecordReader(split, taskAttemptContext);
            try {
                reader.initialize(split, taskAttemptContext);
                if (!reader.nextKeyValue()) continue;
                readValue = (TBase)reader.getCurrentValue();
                LOG.info("{}", (Object)readValue);
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        Assert.assertEquals(exptectedReadResult, readValue);
    }
}

