/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import com.twitter.data.proto.tutorial.thrift.PhoneType;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.thrift.test.TestMap;
import com.twitter.elephantbird.thrift.test.TestMapInList;
import com.twitter.elephantbird.thrift.test.TestMapInSet;
import com.twitter.elephantbird.thrift.test.TestName;
import com.twitter.elephantbird.thrift.test.TestNameList;
import com.twitter.elephantbird.thrift.test.TestNameSet;
import com.twitter.elephantbird.thrift.test.TestPerson;
import com.twitter.elephantbird.thrift.test.TestStructInMap;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.ExpectationValidatingRecordConsumer;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordConsumerLoggingWrapper;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.pig.PigSchemaConverter;
import org.apache.parquet.pig.TupleWriteSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.ParquetWriteProtocol;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thrift.test.OneOfEach;

public class TestParquetWriteProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(TestParquetWriteProtocol.class);

    @Test
    public void testMap() throws Exception {
        String[] expectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(map_name)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(key_value, 0)", "startGroup()", "startField(key, 0)", "addBinary(foo)", "endField(key, 0)", "startField(value, 1)", "addBinary(bar)", "endField(value, 1)", "endGroup()", "startGroup()", "startField(key, 0)", "addBinary(foo2)", "endField(key, 0)", "startField(value, 1)", "addBinary(bar2)", "endField(value, 1)", "endGroup()", "endField(key_value, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        String[] expectationsAlt = new String[]{"startMessage()", "startField(name, 0)", "addBinary(map_name)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(key_value, 0)", "startGroup()", "startField(key, 0)", "addBinary(foo2)", "endField(key, 0)", "startField(value, 1)", "addBinary(bar2)", "endField(value, 1)", "endGroup()", "startGroup()", "startField(key, 0)", "addBinary(foo)", "endField(key, 0)", "startField(value, 1)", "addBinary(bar)", "endField(value, 1)", "endGroup()", "endField(key_value, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("foo", "bar");
        map.put("foo2", "bar2");
        TestMap testMap = new TestMap("map_name", map);
        try {
            this.validatePig(expectations, (TBase<?, ?>)testMap);
        }
        catch (ComparisonFailure e) {
            this.validatePig(expectationsAlt, (TBase<?, ?>)testMap);
        }
        this.validateThrift(expectations, (TBase<?, ?>)testMap);
    }

    @Test
    public void testMapInSet() throws Exception {
        String[] pigExpectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(top)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(t, 0)", "startGroup()", "startField(names_tuple, 0)", "startGroup()", "startField(key_value, 0)", "startGroup()", "startField(key, 0)", "addBinary(foo)", "endField(key, 0)", "startField(value, 1)", "addBinary(bar)", "endField(value, 1)", "endGroup()", "endField(key_value, 0)", "endGroup()", "endField(names_tuple, 0)", "endGroup()", "endField(t, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        HashSet set = new HashSet();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        set.add(map);
        TestMapInSet o = new TestMapInSet("top", set);
        this.validatePig(pigExpectations, (TBase<?, ?>)o);
        String[] expectationsThrift = new String[]{"startMessage()", "startField(name, 0)", "addBinary(top)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(names_tuple, 0)", "startGroup()", "startField(key_value, 0)", "startGroup()", "startField(key, 0)", "addBinary(foo)", "endField(key, 0)", "startField(value, 1)", "addBinary(bar)", "endField(value, 1)", "endGroup()", "endField(key_value, 0)", "endGroup()", "endField(names_tuple, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        this.validateThrift(expectationsThrift, (TBase<?, ?>)o);
    }

    @Test
    public void testNameList() throws TException {
        ArrayList<String> names = new ArrayList<String>();
        names.add("John");
        names.add("Jack");
        TestNameList o = new TestNameList("name", names);
        String[] pigExpectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(name)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(t, 0)", "startGroup()", "startField(names_tuple, 0)", "addBinary(John)", "endField(names_tuple, 0)", "endGroup()", "startGroup()", "startField(names_tuple, 0)", "addBinary(Jack)", "endField(names_tuple, 0)", "endGroup()", "endField(t, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        this.validatePig(pigExpectations, (TBase<?, ?>)o);
        String[] expectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(name)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(names_tuple, 0)", "addBinary(John)", "addBinary(Jack)", "endField(names_tuple, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        this.validateThrift(expectations, (TBase<?, ?>)o);
    }

    @Test
    public void testStructInMap() throws Exception {
        String[] expectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(map_name)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(key_value, 0)", "startGroup()", "startField(key, 0)", "addBinary(foo)", "endField(key, 0)", "startField(value, 1)", "startGroup()", "startField(name, 0)", "startGroup()", "startField(first_name, 0)", "addBinary(john)", "endField(first_name, 0)", "startField(last_name, 1)", "addBinary(johnson)", "endField(last_name, 1)", "endGroup()", "endField(name, 0)", "startField(phones, 1)", "startGroup()", "endGroup()", "endField(phones, 1)", "endGroup()", "endField(value, 1)", "endGroup()", "endField(key_value, 0)", "endGroup()", "endField(names, 1)", "startField(name_to_id, 2)", "startGroup()", "startField(key_value, 0)", "startGroup()", "startField(key, 0)", "addBinary(bar)", "endField(key, 0)", "startField(value, 1)", "addInt(10)", "endField(value, 1)", "endGroup()", "endField(key_value, 0)", "endGroup()", "endField(name_to_id, 2)", "endMessage()"};
        HashMap<String, TestPerson> map = new HashMap<String, TestPerson>();
        map.put("foo", new TestPerson(new TestName("john", "johnson"), new HashMap()));
        Map<String, Integer> stringToIntMap = Collections.singletonMap("bar", 10);
        TestStructInMap testMap = new TestStructInMap("map_name", map, stringToIntMap);
        this.validatePig(expectations, (TBase<?, ?>)testMap);
        this.validateThrift(expectations, (TBase<?, ?>)testMap);
    }

    @Test
    public void testProtocolEmptyAdressBook() throws Exception {
        String[] expectations = new String[]{"startMessage()", "startField(persons, 0)", "startGroup()", "endGroup()", "endField(persons, 0)", "endMessage()"};
        AddressBook a = new AddressBook(new ArrayList());
        this.validatePig(expectations, (TBase<?, ?>)a);
        this.validateThrift(expectations, (TBase<?, ?>)a);
    }

    @Test
    public void testProtocolAddressBook() throws Exception {
        String[] expectations = new String[]{"startMessage()", "startField(persons, 0)", "startGroup()", "startField(t, 0)", "startGroup()", "startField(name, 0)", "startGroup()", "startField(first_name, 0)", "addBinary(Bob)", "endField(first_name, 0)", "startField(last_name, 1)", "addBinary(Roberts)", "endField(last_name, 1)", "endGroup()", "endField(name, 0)", "startField(id, 1)", "addInt(1)", "endField(id, 1)", "startField(email, 2)", "addBinary(bob@roberts.com)", "endField(email, 2)", "startField(phones, 3)", "startGroup()", "startField(t, 0)", "startGroup()", "startField(number, 0)", "addBinary(555 999 9999)", "endField(number, 0)", "endGroup()", "startGroup()", "startField(number, 0)", "addBinary(555 999 9998)", "endField(number, 0)", "startField(type, 1)", "addBinary(HOME)", "endField(type, 1)", "endGroup()", "endField(t, 0)", "endGroup()", "endField(phones, 3)", "endGroup()", "startGroup()", "startField(name, 0)", "startGroup()", "startField(first_name, 0)", "addBinary(Dick)", "endField(first_name, 0)", "startField(last_name, 1)", "addBinary(Richardson)", "endField(last_name, 1)", "endGroup()", "endField(name, 0)", "startField(id, 1)", "addInt(2)", "endField(id, 1)", "startField(email, 2)", "addBinary(dick@richardson.com)", "endField(email, 2)", "startField(phones, 3)", "startGroup()", "startField(t, 0)", "startGroup()", "startField(number, 0)", "addBinary(555 999 9997)", "endField(number, 0)", "endGroup()", "startGroup()", "startField(number, 0)", "addBinary(555 999 9996)", "endField(number, 0)", "endGroup()", "endField(t, 0)", "endGroup()", "endField(phones, 3)", "endGroup()", "endField(t, 0)", "endGroup()", "endField(persons, 0)", "endMessage()"};
        ArrayList<Person> persons = new ArrayList<Person>();
        PhoneNumber phoneNumber = new PhoneNumber("555 999 9998");
        phoneNumber.type = PhoneType.HOME;
        persons.add(new Person(new Name("Bob", "Roberts"), 1, "bob@roberts.com", Arrays.asList(new PhoneNumber("555 999 9999"), phoneNumber)));
        persons.add(new Person(new Name("Dick", "Richardson"), 2, "dick@richardson.com", Arrays.asList(new PhoneNumber("555 999 9997"), new PhoneNumber("555 999 9996"))));
        AddressBook a = new AddressBook(persons);
        this.validatePig(expectations, (TBase<?, ?>)a);
        String[] expectationsThrift = (String[])Arrays.copyOf(expectations, expectations.length, String[].class);
        expectationsThrift[3] = "startField(persons_tuple, 0)";
        expectationsThrift[23] = "startField(phones_tuple, 0)";
        expectationsThrift[37] = "endField(phones_tuple, 0)";
        expectationsThrift[60] = "startField(phones_tuple, 0)";
        expectationsThrift[71] = "endField(phones_tuple, 0)";
        expectationsThrift[75] = "endField(persons_tuple, 0)";
        this.validateThrift(expectationsThrift, (TBase<?, ?>)a);
    }

    @Test
    public void testOneOfEach() throws TException {
        String[] expectations = new String[]{"startMessage()", "startField(im_true, 0)", "addInt(1)", "endField(im_true, 0)", "startField(im_false, 1)", "addInt(0)", "endField(im_false, 1)", "startField(a_bite, 2)", "addInt(8)", "endField(a_bite, 2)", "startField(integer16, 3)", "addInt(16)", "endField(integer16, 3)", "startField(integer32, 4)", "addInt(32)", "endField(integer32, 4)", "startField(integer64, 5)", "addLong(64)", "endField(integer64, 5)", "startField(double_precision, 6)", "addDouble(1234.0)", "endField(double_precision, 6)", "startField(some_characters, 7)", "addBinary(string)", "endField(some_characters, 7)", "startField(zomg_unicode, 8)", "addBinary(\u00e5)", "endField(zomg_unicode, 8)", "startField(what_who, 9)", "addInt(0)", "endField(what_who, 9)", "startField(base64, 10)", "addBinary(a)", "endField(base64, 10)", "startField(byte_list, 11)", "startGroup()", "endGroup()", "endField(byte_list, 11)", "startField(i16_list, 12)", "startGroup()", "endGroup()", "endField(i16_list, 12)", "startField(i64_list, 13)", "startGroup()", "endGroup()", "endField(i64_list, 13)", "endMessage()"};
        OneOfEach a = new OneOfEach(true, false, 8, 16, 32, 64L, 1234.0, "string", "\u00e5", false, ByteBuffer.wrap("a".getBytes()), new ArrayList(), new ArrayList(), new ArrayList());
        this.validatePig(expectations, (TBase<?, ?>)a);
        String[] thriftExpectations = (String[])Arrays.copyOf(expectations, expectations.length, String[].class);
        thriftExpectations[2] = "addBoolean(true)";
        thriftExpectations[5] = "addBoolean(false)";
        thriftExpectations[29] = "addBoolean(false)";
        this.validateThrift(thriftExpectations, (TBase<?, ?>)a);
    }

    @Test
    public void testSetWithTwoLevelList() throws TException {
        HashSet<String> names = new HashSet<String>();
        names.add("John");
        names.add("Jack");
        TestNameSet o = new TestNameSet("name", names);
        String[] expectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(name)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(names_tuple, 0)", "addBinary(John)", "addBinary(Jack)", "endField(names_tuple, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        Configuration conf = new Configuration();
        conf.set("parquet.thrift.write-three-level-lists", "false");
        this.validateThrift(conf, expectations, (TBase<?, ?>)o);
    }

    @Test
    public void testSetWithThreeLevelList() throws TException {
        HashSet<String> names = new HashSet<String>();
        names.add("John");
        names.add("Jack");
        TestNameSet o = new TestNameSet("name", names);
        String[] expectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(name)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(list, 0)", "startGroup()", "startField(element, 0)", "addBinary(John)", "endField(element, 0)", "endGroup()", "startGroup()", "startField(element, 0)", "addBinary(Jack)", "endField(element, 0)", "endGroup()", "endField(list, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        Configuration conf = new Configuration();
        conf.set("parquet.thrift.write-three-level-lists", "true");
        this.validateThrift(conf, expectations, (TBase<?, ?>)o);
    }

    @Test
    public void testNameThreeLevelList() throws TException {
        ArrayList<String> names = new ArrayList<String>();
        names.add("John");
        names.add("Jack");
        TestNameList o = new TestNameList("name", names);
        String[] expectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(name)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(list, 0)", "startGroup()", "startField(element, 0)", "addBinary(John)", "endField(element, 0)", "endGroup()", "startGroup()", "startField(element, 0)", "addBinary(Jack)", "endField(element, 0)", "endGroup()", "endField(list, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        Configuration conf = new Configuration();
        conf.set("parquet.thrift.write-three-level-lists", "true");
        this.validateThrift(conf, expectations, (TBase<?, ?>)o);
    }

    @Test
    public void testListOfMapThreeLevelList() throws TException {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("key11", "value11");
        map1.put("key12", "value12");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("key21", "value21");
        TestMapInList listMap = new TestMapInList("listmap", Arrays.asList(map1, map2));
        String[] expectations = new String[]{"startMessage()", "startField(name, 0)", "addBinary(listmap)", "endField(name, 0)", "startField(names, 1)", "startGroup()", "startField(list, 0)", "startGroup()", "startField(element, 0)", "startGroup()", "startField(key_value, 0)", "startGroup()", "startField(key, 0)", "addBinary(key12)", "endField(key, 0)", "startField(value, 1)", "addBinary(value12)", "endField(value, 1)", "endGroup()", "startGroup()", "startField(key, 0)", "addBinary(key11)", "endField(key, 0)", "startField(value, 1)", "addBinary(value11)", "endField(value, 1)", "endGroup()", "endField(key_value, 0)", "endGroup()", "endField(element, 0)", "endGroup()", "startGroup()", "startField(element, 0)", "startGroup()", "startField(key_value, 0)", "startGroup()", "startField(key, 0)", "addBinary(key21)", "endField(key, 0)", "startField(value, 1)", "addBinary(value21)", "endField(value, 1)", "endGroup()", "endField(key_value, 0)", "endGroup()", "endField(element, 0)", "endGroup()", "endField(list, 0)", "endGroup()", "endField(names, 1)", "endMessage()"};
        Configuration conf = new Configuration();
        conf.set("parquet.thrift.write-three-level-lists", "true");
        this.validateThrift(conf, expectations, (TBase<?, ?>)listMap);
    }

    private void validateThrift(String[] expectations, TBase<?, ?> a) throws TException {
        this.validateThrift(new Configuration(), expectations, a);
    }

    private void validateThrift(Configuration configuration, String[] expectations, TBase<?, ?> a) throws TException {
        ThriftSchemaConverter thriftSchemaConverter = new ThriftSchemaConverter(configuration);
        Class<?> class1 = a.getClass();
        MessageType schema = thriftSchemaConverter.convert(class1);
        LOG.info("{}", (Object)schema);
        ThriftType.StructType structType = ThriftSchemaConverter.toStructType(class1);
        ExpectationValidatingRecordConsumer recordConsumer = new ExpectationValidatingRecordConsumer(new ArrayDeque<String>(Arrays.asList(expectations)));
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
        ParquetWriteProtocol p = new ParquetWriteProtocol(configuration, (RecordConsumer)new RecordConsumerLoggingWrapper((RecordConsumer)recordConsumer), columnIO, structType);
        a.write((TProtocol)p);
    }

    private MessageType validatePig(String[] expectations, TBase<?, ?> a) {
        ThriftToPig thriftToPig = new ThriftToPig(a.getClass());
        ExpectationValidatingRecordConsumer recordConsumer = new ExpectationValidatingRecordConsumer(new ArrayDeque<String>(Arrays.asList(expectations)));
        Schema pigSchema = thriftToPig.toSchema();
        LOG.info("{}", (Object)pigSchema);
        MessageType schema = new PigSchemaConverter().convert(pigSchema);
        LOG.info("{}", (Object)schema);
        TupleWriteSupport tupleWriteSupport = new TupleWriteSupport(pigSchema);
        tupleWriteSupport.init(null);
        tupleWriteSupport.prepareForWrite((RecordConsumer)recordConsumer);
        Tuple pigTuple = thriftToPig.getPigTuple(a);
        LOG.info("{}", (Object)pigTuple);
        tupleWriteSupport.write(pigTuple);
        return schema;
    }
}

