/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import com.twitter.data.proto.tutorial.thrift.PhoneType;
import com.twitter.elephantbird.thrift.test.TestMapInSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.parquet.thrift.BufferedProtocolReadToWrite;
import org.apache.parquet.thrift.DecodingSchemaMismatchException;
import org.apache.parquet.thrift.FieldIgnoredHandler;
import org.apache.parquet.thrift.ProtocolPipe;
import org.apache.parquet.thrift.ProtocolReadToWrite;
import org.apache.parquet.thrift.SkippableException;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.test.Phone;
import org.apache.parquet.thrift.test.StructWithExtraField;
import org.apache.parquet.thrift.test.StructWithIndexStartsFrom4;
import org.apache.parquet.thrift.test.compat.ABool;
import org.apache.parquet.thrift.test.compat.ALong;
import org.apache.parquet.thrift.test.compat.AStructThatLooksLikeUnionV2;
import org.apache.parquet.thrift.test.compat.NumberEnumWithMoreValue;
import org.apache.parquet.thrift.test.compat.StructV1;
import org.apache.parquet.thrift.test.compat.StructV2;
import org.apache.parquet.thrift.test.compat.StructV3;
import org.apache.parquet.thrift.test.compat.StructV4WithExtracStructField;
import org.apache.parquet.thrift.test.compat.StructWithAStructThatLooksLikeUnionV2;
import org.apache.parquet.thrift.test.compat.StructWithEnum;
import org.apache.parquet.thrift.test.compat.StructWithMoreEnum;
import org.apache.parquet.thrift.test.compat.StructWithUnionV1;
import org.apache.parquet.thrift.test.compat.StructWithUnionV2;
import org.apache.parquet.thrift.test.compat.UnionThatLooksLikeUnionV3;
import org.apache.parquet.thrift.test.compat.UnionV1;
import org.apache.parquet.thrift.test.compat.UnionV2;
import org.apache.parquet.thrift.test.compat.UnionV3;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.Test;
import thrift.test.OneOfEach;

public class TestProtocolReadToWrite {
    @Test
    public void testOneOfEach() throws Exception {
        OneOfEach a = new OneOfEach(true, false, 8, 16, 32, 64L, 1234.0, "string", "\u00e5", false, ByteBuffer.wrap("a".getBytes()), new ArrayList(), new ArrayList(), new ArrayList());
        this.writeReadCompare((TBase<?, ?>)a);
    }

    @Test
    public void testWriteRead() throws Exception {
        ArrayList<Person> persons = new ArrayList<Person>();
        PhoneNumber phoneNumber = new PhoneNumber("555 999 9998");
        phoneNumber.type = PhoneType.HOME;
        persons.add(new Person(new Name("Bob", "Roberts"), 1, "bob@roberts.com", Arrays.asList(new PhoneNumber("555 999 9999"), phoneNumber)));
        persons.add(new Person(new Name("Dick", "Richardson"), 2, "dick@richardson.com", Arrays.asList(new PhoneNumber("555 999 9997"), new PhoneNumber("555 999 9996"))));
        AddressBook a = new AddressBook(persons);
        this.writeReadCompare((TBase<?, ?>)a);
    }

    @Test
    public void testEmptyStruct() throws Exception {
        AddressBook a = new AddressBook();
        this.writeReadCompare((TBase<?, ?>)a);
    }

    @Test
    public void testMapSet() throws Exception {
        HashSet set = new HashSet();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        set.add(map);
        TestMapInSet a = new TestMapInSet("top", set);
        this.writeReadCompare((TBase<?, ?>)a);
    }

    private void writeReadCompare(TBase<?, ?> a) throws TException, InstantiationException, IllegalAccessException {
        ProtocolPipe[] pipes;
        for (ProtocolPipe p : pipes = new ProtocolPipe[]{new ProtocolReadToWrite(), new BufferedProtocolReadToWrite(ThriftSchemaConverter.toStructType(a.getClass()))}) {
            ByteArrayOutputStream in = new ByteArrayOutputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            a.write((TProtocol)this.protocol(in));
            p.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
            TBase b = (TBase)a.getClass().newInstance();
            b.read((TProtocol)this.protocol(new ByteArrayInputStream(out.toByteArray())));
            Assert.assertEquals((String)p.getClass().getSimpleName(), a, (Object)b);
        }
    }

    @Test
    public void testIncompatibleSchemaRecord() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler();
        BufferedProtocolReadToWrite p = new BufferedProtocolReadToWrite(ThriftSchemaConverter.toStructType(AddressBook.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OneOfEach a = new OneOfEach(true, false, 8, 16, 32, 64L, 1234.0, "string", "\u00e5", false, ByteBuffer.wrap("a".getBytes()), new ArrayList(), new ArrayList(), new ArrayList());
        a.write((TProtocol)this.protocol(in));
        try {
            p.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
            Assert.fail((String)"this should throw");
        }
        catch (SkippableException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof DecodingSchemaMismatchException));
            Assert.assertTrue((boolean)cause.getMessage().contains("the data type does not match the expected thrift structure"));
            Assert.assertTrue((boolean)cause.getMessage().contains("got BOOL"));
        }
        Assert.assertEquals((long)0L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)0L, (long)countingHandler.fieldIgnoredCount);
    }

    @Test
    public void testUnrecognizedUnionMemberSchema() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler();
        BufferedProtocolReadToWrite p = new BufferedProtocolReadToWrite(ThriftSchemaConverter.toStructType(StructWithUnionV1.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StructWithUnionV1 validUnion = new StructWithUnionV1("a valid struct", UnionV1.aLong(new ALong(17L)));
        StructWithUnionV2 invalidUnion = new StructWithUnionV2("a struct with new union member", UnionV2.aNewBool(new ABool(true)));
        validUnion.write((TProtocol)this.protocol(in));
        invalidUnion.write((TProtocol)this.protocol(in));
        ByteArrayInputStream baos = new ByteArrayInputStream(in.toByteArray());
        p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
        try {
            p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
            Assert.fail((String)"this should throw");
        }
        catch (SkippableException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(DecodingSchemaMismatchException.class, cause.getClass());
            Assert.assertTrue((boolean)cause.getMessage().startsWith("Unrecognized union member with id: 3 for struct:"));
        }
        Assert.assertEquals((long)0L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)0L, (long)countingHandler.fieldIgnoredCount);
    }

    @Test
    public void testUnionWithExtraOrNoValues() throws Exception {
        Throwable cause;
        CountingErrorHandler countingHandler = new CountingErrorHandler();
        BufferedProtocolReadToWrite p = new BufferedProtocolReadToWrite(ThriftSchemaConverter.toStructType(StructWithUnionV2.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StructWithUnionV2 validUnion = new StructWithUnionV2("a valid struct", UnionV2.aLong(new ALong(17L)));
        StructWithAStructThatLooksLikeUnionV2 allMissing = new StructWithAStructThatLooksLikeUnionV2("all missing", new AStructThatLooksLikeUnionV2());
        AStructThatLooksLikeUnionV2 extra = new AStructThatLooksLikeUnionV2();
        extra.setALong(new ALong(18L));
        extra.setANewBool(new ABool(false));
        StructWithAStructThatLooksLikeUnionV2 hasExtra = new StructWithAStructThatLooksLikeUnionV2("has extra", new AStructThatLooksLikeUnionV2(extra));
        validUnion.write((TProtocol)this.protocol(in));
        allMissing.write((TProtocol)this.protocol(in));
        ByteArrayInputStream baos = new ByteArrayInputStream(in.toByteArray());
        p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
        try {
            p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
            Assert.fail((String)"this should throw");
        }
        catch (SkippableException e) {
            cause = e.getCause();
            Assert.assertEquals(DecodingSchemaMismatchException.class, cause.getClass());
            Assert.assertTrue((boolean)cause.getMessage().startsWith("Cannot write a TUnion with no set value in"));
        }
        Assert.assertEquals((long)0L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)0L, (long)countingHandler.fieldIgnoredCount);
        in = new ByteArrayOutputStream();
        validUnion.write((TProtocol)this.protocol(in));
        hasExtra.write((TProtocol)this.protocol(in));
        baos = new ByteArrayInputStream(in.toByteArray());
        p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
        try {
            p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
            Assert.fail((String)"this should throw");
        }
        catch (SkippableException e) {
            cause = e.getCause();
            Assert.assertEquals(DecodingSchemaMismatchException.class, cause.getClass());
            Assert.assertTrue((boolean)cause.getMessage().startsWith("Cannot write a TUnion with more than 1 set value in"));
        }
        Assert.assertEquals((long)0L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)0L, (long)countingHandler.fieldIgnoredCount);
    }

    @Test
    public void testUnionWithStructWithUnknownField() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler();
        BufferedProtocolReadToWrite p = new BufferedProtocolReadToWrite(ThriftSchemaConverter.toStructType(UnionV3.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        UnionV3 validUnion = UnionV3.aStruct(new StructV1("a valid struct"));
        StructV2 structV2 = new StructV2("a valid struct");
        structV2.setAge("a valid age");
        UnionThatLooksLikeUnionV3 unionWithUnknownStructField = UnionThatLooksLikeUnionV3.aStruct(structV2);
        validUnion.write((TProtocol)this.protocol(in));
        unionWithUnknownStructField.write((TProtocol)this.protocol(in));
        ByteArrayInputStream baos = new ByteArrayInputStream(in.toByteArray());
        p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
        p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
        Assert.assertEquals((long)1L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)1L, (long)countingHandler.fieldIgnoredCount);
        in = new ByteArrayOutputStream();
        validUnion.write((TProtocol)this.protocol(in));
        unionWithUnknownStructField.write((TProtocol)this.protocol(in));
        baos = new ByteArrayInputStream(in.toByteArray());
        p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
        p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
        Assert.assertEquals((long)2L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)2L, (long)countingHandler.fieldIgnoredCount);
    }

    @Test
    public void testEnumMissingSchema() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler();
        BufferedProtocolReadToWrite p = new BufferedProtocolReadToWrite(ThriftSchemaConverter.toStructType(StructWithEnum.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StructWithMoreEnum enumDefinedInOldDefinition = new StructWithMoreEnum(NumberEnumWithMoreValue.THREE);
        StructWithMoreEnum extraEnumDefinedInNewDefinition = new StructWithMoreEnum(NumberEnumWithMoreValue.FOUR);
        enumDefinedInOldDefinition.write((TProtocol)this.protocol(in));
        extraEnumDefinedInNewDefinition.write((TProtocol)this.protocol(in));
        ByteArrayInputStream baos = new ByteArrayInputStream(in.toByteArray());
        p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
        try {
            p.readOne((TProtocol)this.protocol(baos), (TProtocol)this.protocol(out));
            Assert.fail((String)"this should throw");
        }
        catch (SkippableException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(DecodingSchemaMismatchException.class, cause.getClass());
            Assert.assertTrue((boolean)cause.getMessage().contains("can not find index 4 in enum"));
        }
        Assert.assertEquals((long)0L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)0L, (long)countingHandler.fieldIgnoredCount);
    }

    @Test
    public void testMissingFieldHandling() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler(){

            @Override
            public void handleFieldIgnored(TField field) {
                Assert.assertEquals((long)field.id, (long)4L);
                ++this.fieldIgnoredCount;
            }
        };
        BufferedProtocolReadToWrite structForRead = new BufferedProtocolReadToWrite(ThriftSchemaConverter.toStructType(StructV3.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        StructV4WithExtracStructField dataWithNewSchema = new StructV4WithExtracStructField("name");
        dataWithNewSchema.setAge("10");
        dataWithNewSchema.setGender("male");
        StructV3 structV3 = new StructV3("name");
        structV3.setAge("10");
        dataWithNewSchema.setAddedStruct(structV3);
        dataWithNewSchema.write((TProtocol)this.protocol(in));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        structForRead.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
        Assert.assertEquals((long)1L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)1L, (long)countingHandler.fieldIgnoredCount);
        StructV4WithExtracStructField b = (StructV4WithExtracStructField)StructV4WithExtracStructField.class.newInstance();
        b.read((TProtocol)this.protocol(new ByteArrayInputStream(out.toByteArray())));
        Assert.assertEquals((Object)dataWithNewSchema.getName(), (Object)b.getName());
        Assert.assertEquals((Object)dataWithNewSchema.getAge(), (Object)b.getAge());
        Assert.assertEquals((Object)dataWithNewSchema.getGender(), (Object)b.getGender());
        Assert.assertEquals(null, (Object)b.getAddedStruct());
    }

    @Test
    public void TestExtraFieldWhenFieldIndexIsNotStartFromZero() throws Exception {
        CountingErrorHandler countingHandler = new CountingErrorHandler(){

            @Override
            public void handleFieldIgnored(TField field) {
                Assert.assertEquals((long)3L, (long)field.id);
                ++this.fieldIgnoredCount;
            }
        };
        BufferedProtocolReadToWrite structForRead = new BufferedProtocolReadToWrite(ThriftSchemaConverter.toStructType(StructWithIndexStartsFrom4.class), (FieldIgnoredHandler)countingHandler);
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        StructWithExtraField dataWithNewExtraField = new StructWithExtraField(new Phone("111", "222"), new Phone("333", "444"));
        dataWithNewExtraField.write((TProtocol)this.protocol(in));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        structForRead.readOne((TProtocol)this.protocol(new ByteArrayInputStream(in.toByteArray())), (TProtocol)this.protocol(out));
        Assert.assertEquals((long)1L, (long)countingHandler.recordCountOfMissingFields);
        Assert.assertEquals((long)1L, (long)countingHandler.fieldIgnoredCount);
    }

    private TCompactProtocol protocol(OutputStream to) throws TTransportException {
        return new TCompactProtocol((TTransport)new TIOStreamTransport(to));
    }

    private TCompactProtocol protocol(InputStream from) throws TTransportException {
        return new TCompactProtocol((TTransport)new TIOStreamTransport(from));
    }

    class CountingErrorHandler
    extends FieldIgnoredHandler {
        int fieldIgnoredCount = 0;
        int recordCountOfMissingFields = 0;

        CountingErrorHandler() {
        }

        public void handleRecordHasFieldIgnored() {
            ++this.recordCountOfMissingFields;
        }

        public void handleFieldIgnored(TField field) {
            ++this.fieldIgnoredCount;
        }
    }
}

