/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Name;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.data.proto.tutorial.thrift.PhoneNumber;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.thrift.ThriftParquetReader;
import org.apache.parquet.thrift.ThriftParquetWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestThriftParquetReaderWriter {
    @Test
    public void testWriteRead() throws IOException {
        this.readWriteTest(true);
    }

    @Test
    public void testWriteReadTwoLevelList() throws IOException {
        this.readWriteTest(false);
    }

    private void readWriteTest(Boolean useThreeLevelLists) throws IOException {
        Configuration configuration = new Configuration();
        configuration.set("parquet.thrift.write-three-level-lists", useThreeLevelLists.toString());
        Path f = new Path("target/test/TestThriftParquetReaderWriter");
        FileSystem fs = f.getFileSystem(configuration);
        if (fs.exists(f)) {
            fs.delete(f, true);
        }
        AddressBook original = new AddressBook(Arrays.asList(new Person(new Name("Bob", "Roberts"), 1, "bob@roberts.com", Arrays.asList(new PhoneNumber("5555555555")))));
        ThriftParquetWriter thriftParquetWriter = new ThriftParquetWriter(f, AddressBook.class, CompressionCodecName.UNCOMPRESSED);
        thriftParquetWriter.write((Object)original);
        thriftParquetWriter.close();
        ThriftParquetReader thriftParquetReader = new ThriftParquetReader(f, AddressBook.class);
        AddressBook read = (AddressBook)thriftParquetReader.read();
        Assert.assertEquals((Object)original, (Object)read);
        thriftParquetReader.close();
        thriftParquetReader = new ThriftParquetReader(f);
        read = (AddressBook)thriftParquetReader.read();
        Assert.assertEquals((Object)original, (Object)read);
        thriftParquetReader.close();
    }
}

