/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.thrift.ThriftReader;
import org.apache.parquet.thrift.ThriftRecordConverter;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.test.compat.StructWithUnionV1;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.junit.Assert;
import org.junit.Test;

public class TestThriftRecordConverter {
    @Test
    public void testUnknownEnumThrowsGoodException() throws Exception {
        ThriftType.EnumType et = new ThriftType.EnumType(Arrays.asList(new ThriftType.EnumValue(77, "hello")));
        ThriftField field = new ThriftField("name", 1, ThriftField.Requirement.REQUIRED, (ThriftType)et);
        ArrayList events = new ArrayList();
        ThriftRecordConverter.FieldEnumConverter conv = new ThriftRecordConverter.FieldEnumConverter(events, field);
        conv.addBinary(Binary.fromString((String)"hello"));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((long)77L, (long)((TProtocol)events.get(0)).readI32());
        try {
            conv.addBinary(Binary.fromString((String)"FAKE_ENUM_VALUE"));
            Assert.fail((String)"this should throw");
        }
        catch (ParquetDecodingException e) {
            Assert.assertEquals((Object)"Unrecognized enum value: FAKE_ENUM_VALUE known values: {Binary{\"hello\"}=77} in {\n  \"name\" : \"name\",\n  \"fieldId\" : 1,\n  \"requirement\" : \"REQUIRED\",\n  \"type\" : {\n    \"id\" : \"ENUM\",\n    \"values\" : [ {\n      \"id\" : 77,\n      \"name\" : \"hello\"\n    } ],\n    \"logicalTypeAnnotation\" : null\n  }\n}".replace("\n", System.lineSeparator()), (Object)e.getMessage());
        }
    }

    @Test
    public void constructorDoesNotRequireStructOrUnionTypeMeta() throws Exception {
        String jsonWithNoStructOrUnionMeta = String.join((CharSequence)"\n", Files.readAllLines(new File("src/test/resources/org/apache/parquet/thrift/StructWithUnionV1NoStructOrUnionMeta.json").toPath(), StandardCharsets.UTF_8));
        ThriftType.StructType noStructOrUnionMeta = (ThriftType.StructType)ThriftType.fromJSON((String)jsonWithNoStructOrUnionMeta);
        new ThriftRecordConverter((ThriftReader)new ThriftReader<StructWithUnionV1>(){

            public StructWithUnionV1 readOneRecord(TProtocol protocol) throws TException {
                return null;
            }
        }, "name", new ThriftSchemaConverter().convert(StructWithUnionV1.class), noStructOrUnionMeta);
    }
}

