/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.util.ArrayList;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.parquet.thrift.ThriftSchemaConvertVisitor;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.junit.Assert;
import org.junit.Test;

public class TestThriftSchemaConvertVisitor {
    private MessageType buildOneFieldParquetMessage(Type expectedParquetField) {
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(new Type[]{expectedParquetField})).named("ParquetSchema");
    }

    private ThriftType.StructType buildOneFieldThriftStructType(String fieldName, Short fieldId, ThriftType thriftType) {
        ThriftField inputThriftField = new ThriftField(fieldName, fieldId.shortValue(), ThriftField.Requirement.REQUIRED, thriftType);
        ArrayList<ThriftField> fields = new ArrayList<ThriftField>(1);
        fields.add(inputThriftField);
        return new ThriftType.StructType(fields, ThriftType.StructType.StructOrUnionType.STRUCT);
    }

    @Test
    public void testConvertBasicI32Type() {
        String fieldName = "i32Type";
        Short fieldId = 0;
        ThriftType.I32Type i32Type = new ThriftType.I32Type();
        ThriftType.StructType thriftStruct = this.buildOneFieldThriftStructType(fieldName, fieldId, (ThriftType)i32Type);
        MessageType actual = ThriftSchemaConvertVisitor.convert((ThriftType.StructType)thriftStruct, (FieldProjectionFilter)FieldProjectionFilter.ALL_COLUMNS);
        PrimitiveType expectedParquetField = ((PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named(fieldName)).withId((int)fieldId.shortValue());
        MessageType expected = this.buildOneFieldParquetMessage((Type)expectedParquetField);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertLogicalI32Type() {
        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType = LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
        String fieldName = "timeI32Type";
        Short fieldId = 0;
        ThriftType.I32Type timeI32Type = new ThriftType.I32Type();
        timeI32Type.setLogicalTypeAnnotation((LogicalTypeAnnotation)timeLogicalType);
        ThriftType.StructType thriftStruct = this.buildOneFieldThriftStructType(fieldName, fieldId, (ThriftType)timeI32Type);
        MessageType actual = ThriftSchemaConvertVisitor.convert((ThriftType.StructType)thriftStruct, (FieldProjectionFilter)FieldProjectionFilter.ALL_COLUMNS);
        PrimitiveType expectedParquetField = ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)timeLogicalType)).named(fieldName)).withId((int)fieldId.shortValue());
        MessageType expected = this.buildOneFieldParquetMessage((Type)expectedParquetField);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertBasicI64Type() {
        String fieldName = "i64Type";
        Short fieldId = 0;
        ThriftType.I64Type i64Type = new ThriftType.I64Type();
        ThriftType.StructType thriftStruct = this.buildOneFieldThriftStructType(fieldName, fieldId, (ThriftType)i64Type);
        MessageType actual = ThriftSchemaConvertVisitor.convert((ThriftType.StructType)thriftStruct, (FieldProjectionFilter)FieldProjectionFilter.ALL_COLUMNS);
        PrimitiveType expectedParquetField = ((PrimitiveType)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named(fieldName)).withId((int)fieldId.shortValue());
        MessageType expected = this.buildOneFieldParquetMessage((Type)expectedParquetField);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertLogicalI64Type() {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType = LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
        String fieldName = "logicalI64Type";
        Short fieldId = 0;
        ThriftType.I64Type timestampI64Type = new ThriftType.I64Type();
        timestampI64Type.setLogicalTypeAnnotation((LogicalTypeAnnotation)timestampLogicalType);
        ThriftType.StructType thriftStruct = this.buildOneFieldThriftStructType(fieldName, fieldId, (ThriftType)timestampI64Type);
        MessageType actual = ThriftSchemaConvertVisitor.convert((ThriftType.StructType)thriftStruct, (FieldProjectionFilter)FieldProjectionFilter.ALL_COLUMNS);
        PrimitiveType expectedParquetField = ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)timestampLogicalType)).named(fieldName)).withId((int)fieldId.shortValue());
        MessageType expected = this.buildOneFieldParquetMessage((Type)expectedParquetField);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertStringType() {
        LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType = LogicalTypeAnnotation.stringType();
        String fieldName = "stringType";
        Short fieldId = 0;
        ThriftType.StringType stringType = new ThriftType.StringType();
        ThriftType.StructType thriftStruct = this.buildOneFieldThriftStructType(fieldName, fieldId, (ThriftType)stringType);
        MessageType actual = ThriftSchemaConvertVisitor.convert((ThriftType.StructType)thriftStruct, (FieldProjectionFilter)FieldProjectionFilter.ALL_COLUMNS);
        PrimitiveType expectedParquetField = ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)stringLogicalType)).named(fieldName)).withId((int)fieldId.shortValue());
        MessageType expected = this.buildOneFieldParquetMessage((Type)expectedParquetField);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testConvertLogicalBinaryType() {
        LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType = LogicalTypeAnnotation.jsonType();
        String fieldName = "logicalBinaryType";
        Short fieldId = 0;
        ThriftType.StringType jsonBinaryType = new ThriftType.StringType();
        jsonBinaryType.setBinary(true);
        jsonBinaryType.setLogicalTypeAnnotation((LogicalTypeAnnotation)jsonLogicalType);
        ThriftType.StructType thriftStruct = this.buildOneFieldThriftStructType(fieldName, fieldId, (ThriftType)jsonBinaryType);
        MessageType actual = ThriftSchemaConvertVisitor.convert((ThriftType.StructType)thriftStruct, (FieldProjectionFilter)FieldProjectionFilter.ALL_COLUMNS);
        PrimitiveType expectedParquetField = ((PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)jsonLogicalType)).named(fieldName)).withId((int)fieldId.shortValue());
        MessageType expected = this.buildOneFieldParquetMessage((Type)expectedParquetField);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

