/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import com.twitter.data.proto.tutorial.thrift.AddressBook;
import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.elephantbird.thrift.test.TestStructInMap;
import java.util.Arrays;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.projection.StrictFieldProjectionFilter;
import org.apache.parquet.thrift.projection.ThriftProjectionException;
import org.apache.parquet.thrift.projection.deprecated.DeprecatedFieldProjectionFilter;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.test.TestLogicalType;
import org.apache.parquet.thrift.test.compat.MapStructV2;
import org.apache.parquet.thrift.test.compat.SetStructV2;
import org.apache.thrift.TBase;
import org.junit.Assert;
import org.junit.Test;

public class TestThriftSchemaConverter {
    @Test
    public void testToMessageType() throws Exception {
        String expected = "message ParquetSchema {\n  optional group persons (LIST) = 1 {\n    repeated group persons_tuple {\n      required group name = 1 {\n        optional binary first_name (UTF8) = 1;\n        optional binary last_name (UTF8) = 2;\n      }\n      optional int32 id = 2;\n      optional binary email (UTF8) = 3;\n      optional group phones (LIST) = 4 {\n        repeated group phones_tuple {\n          optional binary number (UTF8) = 1;\n          optional binary type (ENUM) = 2;\n        }\n      }\n    }\n  }\n}";
        ThriftSchemaConverter schemaConverter = new ThriftSchemaConverter();
        MessageType converted = schemaConverter.convert(AddressBook.class);
        Assert.assertEquals((Object)MessageTypeParser.parseMessageType((String)expected), (Object)converted);
    }

    @Test
    public void testToProjectedThriftType() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("name/first_name", "name.first_name", "message ParquetSchema {  required group name = 1 {    optional binary first_name (UTF8) = 1;  }}", Person.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("name/first_name;name/last_name", "name.first_name;name.last_name", "message ParquetSchema {  required group name = 1 {    optional binary first_name (UTF8) = 1;    optional binary last_name (UTF8) = 2;  }}", Person.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("name/{first,last}_name;", "name.{first,last}_name;", "message ParquetSchema {  required group name = 1 {    optional binary first_name (UTF8) = 1;    optional binary last_name (UTF8) = 2;  }}", Person.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("name/*", "name", "message ParquetSchema {  required group name = 1 {    optional binary first_name (UTF8) = 1;    optional binary last_name (UTF8) = 2;  }}", Person.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("*/*_name", "*.*_name", "message ParquetSchema {  required group name = 1 {    optional binary first_name (UTF8) = 1;    optional binary last_name (UTF8) = 2;  }}", Person.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("name/first_*", "name.first_*", "message ParquetSchema {  required group name = 1 {    optional binary first_name (UTF8) = 1;  }}", Person.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("*/*", "*.*", "message ParquetSchema {  required group name = 1 {  optional binary first_name (UTF8) = 1;  optional binary last_name (UTF8) = 2;}   optional group phones (LIST) = 4 {    repeated group phones_tuple {      optional binary number (UTF8) = 1;      optional binary type (ENUM) = 2;    }}}", Person.class);
    }

    @Test
    public void testProjectMapThriftType() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("name;names/key*;names/value/**", "name;names.key*;names.value", "message ParquetSchema {\n  optional binary name (UTF8) = 1;\n  optional group names (MAP) = 2 {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional group value {\n        optional group name = 1 {\n          optional binary first_name (UTF8) = 1;\n          optional binary last_name (UTF8) = 2;\n        }\n        optional group phones (MAP) = 2 {\n          repeated group key_value (MAP_KEY_VALUE) {\n            required binary key (ENUM);\n            optional binary value (UTF8);\n          }\n        }\n      }\n    }\n  }\n}", TestStructInMap.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("name;names/key;names/value/name/*", "name;names.key;names.value.name", "message ParquetSchema {\n  optional binary name (UTF8) = 1;\n  optional group names (MAP) = 2 {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional group value {\n        optional group name = 1 {\n          optional binary first_name (UTF8) = 1;\n          optional binary last_name (UTF8) = 2;\n        }\n      }\n    }\n  }\n}", TestStructInMap.class);
    }

    @Test
    public void testProjectOnlyKeyInMap() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("name;names/key", "name;names.key", "message ParquetSchema {\n  optional binary name (UTF8) = 1;\n  optional group names (MAP) = 2 {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      optional group value {\n        optional group name = 1 {\n          optional binary first_name (UTF8) = 1;\n        }\n      }    }\n  }\n}", TestStructInMap.class);
    }

    private void shouldThrowWhenProjectionFilterMatchesNothing(String filters, String unmatchedFilter, Class<? extends TBase<?, ?>> thriftClass) {
        try {
            TestThriftSchemaConverter.getDeprecatedFilteredSchema(filters, thriftClass);
            Assert.fail((String)"should throw projection exception when filter matches nothing");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)("The following projection patterns did not match any columns in this schema:\n" + unmatchedFilter + "\n"), (Object)e.getMessage());
        }
    }

    private void shouldThrowWhenNoColumnsAreSelected(String filters, Class<? extends TBase<?, ?>> thriftClass) {
        try {
            TestThriftSchemaConverter.getDeprecatedFilteredSchema(filters, thriftClass);
            Assert.fail((String)"should throw projection exception when no columns are selected");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)"No columns have been selected", (Object)e.getMessage());
        }
    }

    @Test
    public void testThrowWhenNoColumnsAreSelected() {
        this.shouldThrowWhenNoColumnsAreSelected("non_existing", TestStructInMap.class);
    }

    @Test
    public void testThrowWhenProjectionFilterMatchesNothing() {
        this.shouldThrowWhenProjectionFilterMatchesNothing("name;non_existing", "non_existing", TestStructInMap.class);
        this.shouldThrowWhenProjectionFilterMatchesNothing("**;non_existing", "non_existing", TestStructInMap.class);
        this.shouldThrowWhenProjectionFilterMatchesNothing("**;names/non_existing", "names/non_existing", TestStructInMap.class);
        this.shouldThrowWhenProjectionFilterMatchesNothing("**;names/non_existing;non_existing", "names/non_existing\nnon_existing", TestStructInMap.class);
    }

    @Test
    public void testProjectOnlyValueInMap() {
        try {
            TestThriftSchemaConverter.getDeprecatedFilteredSchema("name;names/value/**", TestStructInMap.class);
            Assert.fail((String)"this should throw");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)"Cannot select only the values of a map, you must keep the keys as well: names", (Object)e.getMessage());
        }
        try {
            TestThriftSchemaConverter.getStrictFilteredSchema("name;names.value", TestStructInMap.class);
            Assert.fail((String)"this should throw");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)"Cannot select only the values of a map, you must keep the keys as well: names", (Object)e.getMessage());
        }
    }

    private void doTestPartialKeyProjection(String deprecated, String strict) {
        try {
            TestThriftSchemaConverter.getDeprecatedFilteredSchema(deprecated, MapStructV2.class);
            Assert.fail((String)"this should throw");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)"Cannot select only a subset of the fields in a map key, for path map1", (Object)e.getMessage());
        }
        try {
            TestThriftSchemaConverter.getStrictFilteredSchema(strict, MapStructV2.class);
            Assert.fail((String)"this should throw");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)"Cannot select only a subset of the fields in a map key, for path map1", (Object)e.getMessage());
        }
    }

    @Test
    public void testPartialKeyProjection() {
        this.doTestPartialKeyProjection("map1/key/age", "map1.key.age");
        this.doTestPartialKeyProjection("map1/key/age;map1/value/**", "map1.{key.age,value}");
    }

    @Test
    public void testSetPartialProjection() {
        try {
            TestThriftSchemaConverter.getDeprecatedFilteredSchema("set1/age", SetStructV2.class);
            Assert.fail((String)"this should throw");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)"Cannot select only a subset of the fields in a set, for path set1", (Object)e.getMessage());
        }
        try {
            TestThriftSchemaConverter.getStrictFilteredSchema("set1.age", SetStructV2.class);
            Assert.fail((String)"this should throw");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)"Cannot select only a subset of the fields in a set, for path set1", (Object)e.getMessage());
        }
    }

    @Test
    public void testConvertStructCreatedViaDeprecatedConstructor() {
        String expected = "message ParquetSchema {\n  required binary a (UTF8) = 1;\n  required binary b (UTF8) = 2;\n}\n";
        ThriftSchemaConverter converter = new ThriftSchemaConverter();
        ThriftType.StructType structType = new ThriftType.StructType(Arrays.asList(new ThriftField("a", 1, ThriftField.Requirement.REQUIRED, (ThriftType)new ThriftType.StringType()), new ThriftField("b", 2, ThriftField.Requirement.REQUIRED, (ThriftType)new ThriftType.StringType())));
        MessageType converted = converter.convert(structType);
        Assert.assertEquals((Object)MessageTypeParser.parseMessageType((String)expected), (Object)converted);
    }

    public static void shouldGetProjectedSchema(String deprecatedFilterDesc, String strictFilterDesc, String expectedSchemaStr, Class<? extends TBase<?, ?>> thriftClass) {
        MessageType depRequestedSchema = TestThriftSchemaConverter.getDeprecatedFilteredSchema(deprecatedFilterDesc, thriftClass);
        MessageType strictRequestedSchema = TestThriftSchemaConverter.getStrictFilteredSchema(strictFilterDesc, thriftClass);
        MessageType expectedSchema = MessageTypeParser.parseMessageType((String)expectedSchemaStr);
        Assert.assertEquals((Object)expectedSchema, (Object)depRequestedSchema);
        Assert.assertEquals((Object)expectedSchema, (Object)strictRequestedSchema);
    }

    private static MessageType getDeprecatedFilteredSchema(String filterDesc, Class<? extends TBase<?, ?>> thriftClass) {
        DeprecatedFieldProjectionFilter fieldProjectionFilter = new DeprecatedFieldProjectionFilter(filterDesc);
        return new ThriftSchemaConverter((FieldProjectionFilter)fieldProjectionFilter).convert(thriftClass);
    }

    private static MessageType getStrictFilteredSchema(String semicolonDelimitedString, Class<? extends TBase<?, ?>> thriftClass) {
        StrictFieldProjectionFilter fieldProjectionFilter = StrictFieldProjectionFilter.fromSemicolonDelimitedString((String)semicolonDelimitedString);
        return new ThriftSchemaConverter((FieldProjectionFilter)fieldProjectionFilter).convert(thriftClass);
    }

    @Test
    public void testToThriftType() throws Exception {
        ThriftType.StructType converted = ThriftSchemaConverter.toStructType(AddressBook.class);
        String json = converted.toJSON();
        ThriftType fromJSON = ThriftType.StructType.fromJSON((String)json);
        Assert.assertEquals((Object)json, (Object)fromJSON.toJSON());
    }

    @Test
    public void testLogicalTypeConvertion() throws Exception {
        String expected = "message ParquetSchema {\n  required int32 test_i16 (INTEGER(16,true)) = 1;}";
        ThriftSchemaConverter schemaConverter = new ThriftSchemaConverter();
        MessageType converted = schemaConverter.convert(TestLogicalType.class);
        Assert.assertEquals((Object)MessageTypeParser.parseMessageType((String)expected), (Object)converted);
    }
}

