/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import org.apache.parquet.thrift.TestThriftSchemaConverter;
import org.apache.parquet.thrift.test.compat.ListOfUnions;
import org.apache.parquet.thrift.test.compat.MapWithUnionKey;
import org.apache.parquet.thrift.test.compat.MapWithUnionValue;
import org.apache.parquet.thrift.test.compat.NestedNestedUnion;
import org.apache.parquet.thrift.test.compat.NestedUnion;
import org.apache.parquet.thrift.test.compat.OptionalInsideRequired;
import org.apache.parquet.thrift.test.compat.RequiredInsideOptional;
import org.apache.parquet.thrift.test.compat.StructWithNestedUnion;
import org.apache.parquet.thrift.test.compat.StructWithOptionalUnionOfStructs;
import org.apache.parquet.thrift.test.compat.UnionOfStructs;
import org.apache.parquet.thrift.test.compat.UnionV2;
import org.junit.Test;

public class TestThriftSchemaConverterProjectUnion {
    @Test
    public void testTopLevelUnions() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("aLong/**", "aLong", "message ParquetSchema {\n  optional group aString = 1 {\n    required binary s (UTF8) = 1;\n  }\n  optional group aLong = 2 {\n    required int64 l = 1;\n  }\n  optional group aNewBool = 3 {\n    required boolean b = 1;\n  }\n}", UnionV2.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("aNewBool/**", "aNewBool", "message ParquetSchema {\n  optional group structV3 = 1 {\n    required binary name (UTF8) = 1;\n  }\n  optional group structV4 = 2 {\n    required binary name (UTF8) = 1;\n  }\n  optional group aNewBool = 3 {\n    required boolean b = 1;\n  }\n}", UnionOfStructs.class);
    }

    @Test
    public void optionalUnionShouldBeDropped() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("name", "name", "message ParquetSchema {\n  required binary name (UTF8) = 1;\n}", StructWithOptionalUnionOfStructs.class);
    }

    @Test
    public void optionalUnionInRequiredStructShouldBeDropped() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("name", "name", "message ParquetSchema {\n  required binary name (UTF8) = 1;\n}", OptionalInsideRequired.class);
    }

    @Test
    public void requiredUnionInsideOptionalStructShouldBeDropped() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("name", "name", "message ParquetSchema {\n  required binary name (UTF8) = 1;\n}", RequiredInsideOptional.class);
    }

    @Test
    public void requiredUnionInsideOptionalStructShouldBeKeptIfParentSelected() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("aStruct/name", "aStruct.name", "message ParquetSchema {\n  optional group aStruct = 2 {\n    required binary name (UTF8) = 1;\n    required group aUnion = 2 {\n      optional group structV3 = 1 {\n        required binary name (UTF8) = 1;\n      }\n      optional group structV4 = 2 {\n        required binary name (UTF8) = 1;\n      }\n      optional group aNewBool = 3 {\n        required boolean b = 1;\n      }\n    }\n  }\n}", RequiredInsideOptional.class);
    }

    @Test
    public void selectingOneUnionMemberKeepsSentinels() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("aUnion/structV4/addedStruct/gender", "aUnion.structV4.addedStruct.gender", "message ParquetSchema {\n  optional group aUnion = 2 {\n    optional group structV3 = 1 {\n      required binary name (UTF8) = 1;\n    }\n    optional group structV4 = 2 {\n      optional group addedStruct = 4 {\n        optional binary gender (UTF8) = 3;\n      }\n    }\n    optional group aNewBool = 3 {\n      required boolean b = 1;\n    }\n  }\n}", StructWithOptionalUnionOfStructs.class);
    }

    @Test
    public void testUnionInsideUnion() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("structV3/age", "structV3.age", "message ParquetSchema {\n  optional group structV3 = 1 {\n    optional binary age (UTF8) = 2;\n  }\n  optional group unionOfStructs = 2 {\n    optional group structV3 = 1 {\n      required binary name (UTF8) = 1;\n    }\n    optional group structV4 = 2 {\n      required binary name (UTF8) = 1;\n    }\n    optional group aNewBool = 3 {\n      required boolean b = 1;\n    }\n  }\n  optional group aLong = 3 {\n    required int64 l = 1;\n  }\n}", NestedUnion.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("unionOfStructs/structV4/addedStruct/gender", "unionOfStructs.structV4.addedStruct.gender", "message ParquetSchema {\n  optional group structV3 = 1 {\n    required binary name (UTF8) = 1;\n  }\n  optional group unionOfStructs = 2 {\n    optional group structV3 = 1 {\n      required binary name (UTF8) = 1;\n    }\n    optional group structV4 = 2 {\n      optional group addedStruct = 4 {\n        optional binary gender (UTF8) = 3;\n      }\n    }\n    optional group aNewBool = 3 {\n      required boolean b = 1;\n    }\n  }\n  optional group aLong = 3 {\n    required int64 l = 1;\n  }\n}\n", NestedUnion.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("unionV2/aLong/**", "unionV2.aLong", "message ParquetSchema {\n  optional group nestedUnion = 1 {\n    optional group structV3 = 1 {\n      required binary name (UTF8) = 1;\n    }\n    optional group unionOfStructs = 2 {\n      optional group structV3 = 1 {\n        required binary name (UTF8) = 1;\n      }\n      optional group structV4 = 2 {\n        required binary name (UTF8) = 1;\n      }\n      optional group aNewBool = 3 {\n        required boolean b = 1;\n      }\n    }\n    optional group aLong = 3 {\n      required int64 l = 1;\n    }\n  }\n  optional group unionV2 = 2 {\n    optional group aString = 1 {\n      required binary s (UTF8) = 1;\n    }\n    optional group aLong = 2 {\n      required int64 l = 1;\n    }\n    optional group aNewBool = 3 {\n      required boolean b = 1;\n    }\n  }\n}", NestedNestedUnion.class);
    }

    @Test
    public void testListOfUnions() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("optListUnion/structV3/age", "optListUnion.structV3.age", "message ParquetSchema {\n  optional group optListUnion (LIST) = 1 {\n    repeated group optListUnion_tuple {\n      optional group structV3 = 1 {\n        optional binary age (UTF8) = 2;\n      }\n      optional group structV4 = 2 {\n        required binary name (UTF8) = 1;\n      }\n      optional group aNewBool = 3 {\n        required boolean b = 1;\n      }\n    }\n  }\n}", ListOfUnions.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("reqListUnion/structV3/age", "reqListUnion.structV3.age", "message ParquetSchema {\n  required group reqListUnion (LIST) = 2 {\n    repeated group reqListUnion_tuple {\n      optional group structV3 = 1 {\n        optional binary age (UTF8) = 2;\n      }\n      optional group structV4 = 2 {\n        required binary name (UTF8) = 1;\n      }\n      optional group aNewBool = 3 {\n        required boolean b = 1;\n      }\n    }\n  }\n}", ListOfUnions.class);
    }

    @Test
    public void testMapWithUnionKey() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("optMapWithUnionKey/key/**", "optMapWithUnionKey.key", "message ParquetSchema {\n  optional group optMapWithUnionKey (MAP) = 1 {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required group key {\n        optional group structV3 = 1 {\n          required binary name (UTF8) = 1;\n          optional binary age (UTF8) = 2;\n          optional binary gender (UTF8) = 3;\n        }\n        optional group structV4 = 2 {\n          required binary name (UTF8) = 1;\n          optional binary age (UTF8) = 2;\n          optional binary gender (UTF8) = 3;\n          optional group addedStruct = 4 {\n            required binary name (UTF8) = 1;\n            optional binary age (UTF8) = 2;\n            optional binary gender (UTF8) = 3;\n          }\n        }\n        optional group aNewBool = 3 {\n          required boolean b = 1;\n        }\n      }\n      optional group value {\n        required binary name (UTF8) = 1;\n      }     }\n  }\n}", MapWithUnionKey.class);
        TestThriftSchemaConverter.shouldGetProjectedSchema("optMapWithUnionKey/key/**;optMapWithUnionKey/value/gender", "optMapWithUnionKey.{key,value.gender}", "message ParquetSchema {\n  optional group optMapWithUnionKey (MAP) = 1 {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required group key {\n        optional group structV3 = 1 {\n          required binary name (UTF8) = 1;\n          optional binary age (UTF8) = 2;\n          optional binary gender (UTF8) = 3;\n        }\n        optional group structV4 = 2 {\n          required binary name (UTF8) = 1;\n          optional binary age (UTF8) = 2;\n          optional binary gender (UTF8) = 3;\n          optional group addedStruct = 4 {\n            required binary name (UTF8) = 1;\n            optional binary age (UTF8) = 2;\n            optional binary gender (UTF8) = 3;\n          }\n        }\n        optional group aNewBool = 3 {\n          required boolean b = 1;\n        }\n      }\n      optional group value {\n        optional binary gender (UTF8) = 3;\n      }\n    }\n  }\n}", MapWithUnionKey.class);
    }

    @Test
    public void testMapWithUnionValue() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("optMapWithUnionValue/key/**;optMapWithUnionValue/value/structV4/addedStruct/gender", "optMapWithUnionValue.{key,value.structV4.addedStruct.gender}", "message ParquetSchema {\n  optional group optMapWithUnionValue (MAP) = 1 {\n    repeated group key_value (MAP_KEY_VALUE) {\n      required group key {\n        required binary name (UTF8) = 1;\n        optional binary age (UTF8) = 2;\n        optional binary gender (UTF8) = 3;\n      }\n      optional group value {\n        optional group structV3 = 1 {\n          required binary name (UTF8) = 1;\n        }\n        optional group structV4 = 2 {\n          optional group addedStruct = 4 {\n            optional binary gender (UTF8) = 3;\n          }\n        }\n        optional group aNewBool = 3 {\n          required boolean b = 1;\n        }\n      }\n    }\n  }\n}", MapWithUnionValue.class);
    }

    @Test
    public void testMessyNestedUnions() {
        TestThriftSchemaConverter.shouldGetProjectedSchema("reqStructWithUnionV2/name", "reqStructWithUnionV2.name", "message ParquetSchema {\n  required group reqUnionOfStructs = 2 {\n    optional group structV3 = 1 {\n      required binary name (UTF8) = 1;\n    }\n    optional group structV4 = 2 {\n      required binary name (UTF8) = 1;\n    }\n    optional group aNewBool = 3 {\n      required boolean b = 1;\n    }\n  }\n  required group reqNestedUnion = 5 {\n    optional group structV3 = 1 {\n      required binary name (UTF8) = 1;\n    }\n    optional group unionOfStructs = 2 {\n      optional group structV3 = 1 {\n        required binary name (UTF8) = 1;\n      }\n      optional group structV4 = 2 {\n        required binary name (UTF8) = 1;\n      }\n      optional group aNewBool = 3 {\n        required boolean b = 1;\n      }\n    }\n    optional group aLong = 3 {\n      required int64 l = 1;\n    }\n  }\n  required group reqStructWithUnionV2 = 8 {\n    required binary name (UTF8) = 1;\n    required group aUnion = 2 {\n      optional group aString = 1 {\n        required binary s (UTF8) = 1;\n      }\n      optional group aLong = 2 {\n        required int64 l = 1;\n      }\n      optional group aNewBool = 3 {\n        required boolean b = 1;\n      }\n    }\n  }\n  required group reqUnionStructUnion = 11 {\n    optional group structV3 = 1 {\n      required binary name (UTF8) = 1;\n    }\n    optional group structWithUnionOfStructs = 2 {\n      required binary name (UTF8) = 1;\n      required group aUnion = 2 {\n        optional group structV3 = 1 {\n          required binary name (UTF8) = 1;\n        }\n        optional group structV4 = 2 {\n          required binary name (UTF8) = 1;\n        }\n        optional group aNewBool = 3 {\n          required boolean b = 1;\n        }\n      }\n    }\n    optional group aLong = 3 {\n      required int64 l = 1;\n    }\n  }\n}", StructWithNestedUnion.class);
    }
}

