/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.pig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.parquet.pig.ParquetLoader;
import org.apache.parquet.thrift.pig.ParquetThriftStorer;
import org.apache.parquet.thrift.test.Name;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.builtin.mock.Storage;
import org.apache.pig.data.Tuple;
import org.junit.Assert;
import org.junit.Test;

public class TestParquetThriftStorer {
    @Test
    public void testStorer() throws ExecException, Exception {
        String out = "target/out";
        int rows = 1000;
        Properties props = new Properties();
        props.setProperty("parquet.compression", "uncompressed");
        props.setProperty("parquet.page.size", "1000");
        PigServer pigServer = new PigServer(ExecType.LOCAL, props);
        Storage.Data data = Storage.resetData((PigServer)pigServer);
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        for (int i = 0; i < rows; ++i) {
            list.add(Storage.tuple((Object[])new Object[]{"bob", "roberts" + i}));
        }
        data.set("in", "fn:chararray, ln:chararray", list);
        pigServer.deleteFile(out);
        pigServer.setBatchOn();
        pigServer.registerQuery("A = LOAD 'in' USING mock.Storage();");
        pigServer.registerQuery("Store A into '" + out + "' using " + ParquetThriftStorer.class.getName() + "('" + Name.class.getName() + "');");
        this.execBatch(pigServer);
        pigServer.registerQuery("B = LOAD '" + out + "' USING " + ParquetLoader.class.getName() + "();");
        pigServer.registerQuery("Store B into 'out' using mock.Storage();");
        this.execBatch(pigServer);
        List result = data.get("out");
        Assert.assertEquals((long)rows, (long)result.size());
        int i = 0;
        for (Tuple tuple : result) {
            Assert.assertEquals((Object)Storage.tuple((Object[])new Object[]{"bob", "roberts" + i}), (Object)tuple);
            ++i;
        }
    }

    private void execBatch(PigServer pigServer) throws IOException {
        if (((ExecJob)pigServer.executeBatch().get(0)).getStatus() != ExecJob.JOB_STATUS.COMPLETED) {
            throw new RuntimeException("Job failed", ((ExecJob)pigServer.executeBatch().get(0)).getException());
        }
    }
}

