/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection;

import com.twitter.data.proto.tutorial.thrift.Person;
import com.twitter.elephantbird.thrift.test.TestStructInMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.projection.FieldsPath;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.junit.Assert;
import org.junit.Test;

public class TestFieldsPath {
    @Test
    public void testFieldsPath() {
        ThriftType.StructType person = ThriftSchemaConverter.toStructType(Person.class);
        List<String> paths = PrimitivePathVisitor.visit(person, ".");
        Assert.assertEquals(Arrays.asList("name.first_name", "name.last_name", "id", "email", "phones.number", "phones.type"), paths);
        paths = PrimitivePathVisitor.visit(person, "/");
        Assert.assertEquals(Arrays.asList("name/first_name", "name/last_name", "id", "email", "phones/number", "phones/type"), paths);
        ThriftType.StructType structInMap = ThriftSchemaConverter.toStructType(TestStructInMap.class);
        paths = PrimitivePathVisitor.visit(structInMap, ".");
        Assert.assertEquals(Arrays.asList("name", "names.key", "names.value.name.first_name", "names.value.name.last_name", "names.value.phones.key", "names.value.phones.value", "name_to_id.key", "name_to_id.value"), paths);
        paths = PrimitivePathVisitor.visit(structInMap, "/");
        Assert.assertEquals(Arrays.asList("name", "names/key", "names/value/name/first_name", "names/value/name/last_name", "names/value/phones/key", "names/value/phones/value", "name_to_id/key", "name_to_id/value"), paths);
    }

    private static class PrimitivePathVisitor
    implements ThriftType.StateVisitor<List<String>, FieldsPath> {
        private String delim;

        private PrimitivePathVisitor(String delim) {
            this.delim = delim;
        }

        public static List<String> visit(ThriftType.StructType s, String delim) {
            PrimitivePathVisitor v = new PrimitivePathVisitor(delim);
            return (List)s.accept((ThriftType.StateVisitor)v, (Object)new FieldsPath());
        }

        public List<String> visit(ThriftType.MapType mapType, FieldsPath path) {
            ArrayList<String> ret = new ArrayList<String>();
            ThriftField key = mapType.getKey();
            ThriftField value = mapType.getValue();
            ret.addAll((Collection)key.getType().accept((ThriftType.StateVisitor)this, (Object)path.push(key)));
            ret.addAll((Collection)value.getType().accept((ThriftType.StateVisitor)this, (Object)path.push(value)));
            return ret;
        }

        public List<String> visit(ThriftType.SetType setType, FieldsPath path) {
            return (List)setType.getValues().getType().accept((ThriftType.StateVisitor)this, (Object)path);
        }

        public List<String> visit(ThriftType.ListType listType, FieldsPath path) {
            return (List)listType.getValues().getType().accept((ThriftType.StateVisitor)this, (Object)path);
        }

        public List<String> visit(ThriftType.StructType structType, FieldsPath path) {
            ArrayList<String> ret = new ArrayList<String>();
            for (ThriftField child : structType.getChildren()) {
                ret.addAll((Collection)child.getType().accept((ThriftType.StateVisitor)this, (Object)path.push(child)));
            }
            return ret;
        }

        private List<String> visitPrimitive(FieldsPath path) {
            return Arrays.asList(path.toDelimitedString(this.delim));
        }

        public List<String> visit(ThriftType.EnumType enumType, FieldsPath path) {
            return this.visitPrimitive(path);
        }

        public List<String> visit(ThriftType.BoolType boolType, FieldsPath path) {
            return this.visitPrimitive(path);
        }

        public List<String> visit(ThriftType.ByteType byteType, FieldsPath path) {
            return this.visitPrimitive(path);
        }

        public List<String> visit(ThriftType.DoubleType doubleType, FieldsPath path) {
            return this.visitPrimitive(path);
        }

        public List<String> visit(ThriftType.I16Type i16Type, FieldsPath path) {
            return this.visitPrimitive(path);
        }

        public List<String> visit(ThriftType.I32Type i32Type, FieldsPath path) {
            return this.visitPrimitive(path);
        }

        public List<String> visit(ThriftType.I64Type i64Type, FieldsPath path) {
            return this.visitPrimitive(path);
        }

        public List<String> visit(ThriftType.StringType stringType, FieldsPath path) {
            return this.visitPrimitive(path);
        }
    }
}

