/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection;

import java.util.Arrays;
import java.util.List;
import org.apache.parquet.thrift.projection.StrictFieldProjectionFilter;
import org.apache.parquet.thrift.projection.ThriftProjectionException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestStrictFieldProjectionFilter {
    @Test
    public void testFromSemicolonDelimitedString() {
        List globs = StrictFieldProjectionFilter.parseSemicolonDelimitedString((String)";x.y.z;*.a.b.c*;;foo;;;;bar;");
        Assert.assertEquals(Arrays.asList("x.y.z", "*.a.b.c*", "foo", "bar"), (Object)globs);
        try {
            StrictFieldProjectionFilter.parseSemicolonDelimitedString((String)";;");
            Assert.fail((String)"this should throw");
        }
        catch (ThriftProjectionException e) {
            Assert.assertEquals((Object)"Semicolon delimited string ';;' contains 0 glob strings", (Object)e.getMessage());
        }
    }

    private static void assertMatches(StrictFieldProjectionFilter filter, String ... strings) {
        for (String s : strings) {
            if (filter.keep(s)) continue;
            Assert.fail((String)String.format("String '%s' was expected to match", s));
        }
    }

    private static void assertDoesNotMatch(StrictFieldProjectionFilter filter, String ... strings) {
        for (String s : strings) {
            if (!filter.keep(s)) continue;
            Assert.fail((String)String.format("String '%s' was not expected to match", s));
        }
    }

    @Test
    public void testProjection() {
        StrictFieldProjectionFilter filter = StrictFieldProjectionFilter.fromSemicolonDelimitedString((String)"home.phone_number;home.address;work.address.zip;base_info;*.average;a.b.c.pre{x,y,z{a,b,c}}post");
        TestStrictFieldProjectionFilter.assertMatches(filter, "home.phone_number", "home.address", "work.address.zip", "base_info", "foo.average", "bar.x.y.z.average", "base_info.nested.field", "a.b.c.prexpost", "a.b.c.prezapost");
        TestStrictFieldProjectionFilter.assertDoesNotMatch(filter, "home2.phone_number", "home2.address", "work.address", "base_info2", "foo_average", "bar.x.y.z_average", "base_info_nested.field", "hi", "average", "a.b.c.pre{x,y,z{a,b,c}}post", "");
    }

    @Test
    public void testIsStrict() {
        StrictFieldProjectionFilter filter = StrictFieldProjectionFilter.fromSemicolonDelimitedString((String)"home.phone_number;a.b.c.pre{x,y,z{a,b,c}}post;bar.*.average");
        TestStrictFieldProjectionFilter.assertMatches(filter, "home.phone_number", "bar.foo.average", "a.b.c.prexpost", "a.b.c.prezcpost");
        TestStrictFieldProjectionFilter.assertDoesNotMatch(filter, "hello");
        try {
            filter.assertNoUnmatchedPatterns();
            Assert.fail((String)"this should throw");
        }
        catch (ThriftProjectionException e) {
            String expectedMessage = "The following projection patterns did not match any columns in this schema:\nPattern: 'a.b.c.pre{x,y,z{a,b,c}}post' (when expanded to 'a.b.c.preypost')\nPattern: 'a.b.c.pre{x,y,z{a,b,c}}post' (when expanded to 'a.b.c.prezapost')\nPattern: 'a.b.c.pre{x,y,z{a,b,c}}post' (when expanded to 'a.b.c.prezbpost')\n";
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testWarnWhenMultiplePatternsMatch() {
        StrictFieldProjectionFilter filter = (StrictFieldProjectionFilter)EasyMock.createMockBuilder(StrictFieldProjectionFilter.class).withConstructor(new Object[]{Arrays.asList("a.b.c.{x_average,z_average}", "a.*_average")}).addMockedMethod("warn").createMock();
        filter.warn("Field path: 'a.b.c.x_average' matched more than one glob path pattern. First match: 'a.b.c.{x_average,z_average}' (when expanded to 'a.b.c.x_average') second match:'a.*_average' (when expanded to 'a.*_average')");
        filter.warn("Field path: 'a.b.c.z_average' matched more than one glob path pattern. First match: 'a.b.c.{x_average,z_average}' (when expanded to 'a.b.c.z_average') second match:'a.*_average' (when expanded to 'a.*_average')");
        EasyMock.replay((Object[])new Object[]{filter});
        TestStrictFieldProjectionFilter.assertMatches(filter, "a.b.c.x_average", "a.b.c.z_average", "a.other.w_average");
        TestStrictFieldProjectionFilter.assertDoesNotMatch(filter, "hello");
        EasyMock.verify((Object[])new Object[]{filter});
    }
}

