/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.struct;

import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.struct.CompatibilityChecker;
import org.apache.parquet.thrift.struct.CompatibilityReport;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.test.compat.AddRequiredStructV1;
import org.apache.parquet.thrift.test.compat.DefaultStructV1;
import org.apache.parquet.thrift.test.compat.ListStructV1;
import org.apache.parquet.thrift.test.compat.ListStructV2;
import org.apache.parquet.thrift.test.compat.MapAddRequiredStructV1;
import org.apache.parquet.thrift.test.compat.MapStructV1;
import org.apache.parquet.thrift.test.compat.MapStructV2;
import org.apache.parquet.thrift.test.compat.MapValueStructV1;
import org.apache.parquet.thrift.test.compat.MapValueStructV2;
import org.apache.parquet.thrift.test.compat.NestedEmptyStruct;
import org.apache.parquet.thrift.test.compat.OptionalStructV1;
import org.apache.parquet.thrift.test.compat.RenameStructV1;
import org.apache.parquet.thrift.test.compat.SetStructV1;
import org.apache.parquet.thrift.test.compat.SetStructV2;
import org.apache.parquet.thrift.test.compat.StructV1;
import org.apache.parquet.thrift.test.compat.StructV2;
import org.apache.parquet.thrift.test.compat.TypeChangeStructV1;
import org.junit.Assert;
import org.junit.Test;

public class CompatibilityCheckerTest {
    @Test
    public void testAddOptionalField() {
        this.verifyCompatible(StructV1.class, StructV2.class, true);
    }

    @Test
    public void testRemoveOptionalField() {
        this.verifyCompatible(StructV2.class, StructV1.class, false);
    }

    @Test
    public void testRenameField() {
        this.verifyCompatible(StructV1.class, RenameStructV1.class, false);
    }

    @Test
    public void testTypeChange() {
        this.verifyCompatible(StructV1.class, TypeChangeStructV1.class, false);
    }

    @Test
    public void testReuirementChange() {
        this.verifyCompatible(StructV1.class, OptionalStructV1.class, true);
        this.verifyCompatible(StructV1.class, DefaultStructV1.class, true);
        this.verifyCompatible(OptionalStructV1.class, StructV1.class, false);
        this.verifyCompatible(DefaultStructV1.class, StructV1.class, false);
    }

    @Test
    public void testAddRequiredField() {
        this.verifyCompatible(StructV1.class, AddRequiredStructV1.class, false);
    }

    @Test
    public void testMap() {
        this.verifyCompatible(MapStructV1.class, MapStructV2.class, true);
        this.verifyCompatible(MapValueStructV1.class, MapValueStructV2.class, true);
        this.verifyCompatible(MapStructV2.class, MapStructV1.class, false);
        this.verifyCompatible(MapValueStructV2.class, MapValueStructV1.class, false);
        this.verifyCompatible(MapStructV2.class, MapAddRequiredStructV1.class, false);
    }

    @Test
    public void testSet() {
        this.verifyCompatible(SetStructV2.class, SetStructV1.class, false);
        this.verifyCompatible(SetStructV1.class, SetStructV2.class, true);
    }

    @Test
    public void testList() {
        this.verifyCompatible(ListStructV2.class, ListStructV1.class, false);
        this.verifyCompatible(ListStructV1.class, ListStructV2.class, true);
    }

    @Test
    public void testEmptyStruct() {
        CompatibilityReport report = this.getCompatibilityReport(NestedEmptyStruct.class, NestedEmptyStruct.class);
        Assert.assertEquals((Object)"encountered an empty struct: required_empty\nencountered an empty struct: optional_empty", (Object)report.prettyMessages());
        Assert.assertTrue((boolean)report.hasEmptyStruct());
    }

    private ThriftType.StructType struct(Class thriftClass) {
        return ThriftSchemaConverter.toStructType((Class)thriftClass);
    }

    private CompatibilityReport getCompatibilityReport(Class oldClass, Class newClass) {
        CompatibilityChecker checker = new CompatibilityChecker();
        CompatibilityReport report = checker.checkCompatibility(this.struct(oldClass), this.struct(newClass));
        return report;
    }

    private void verifyCompatible(Class oldClass, Class newClass, boolean expectCompatible) {
        CompatibilityReport report = this.getCompatibilityReport(oldClass, newClass);
        Assert.assertEquals((Object)expectCompatible, (Object)report.isCompatible());
    }
}

