/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import com.twitter.elephantbird.thrift.TStructDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.thrift.ThriftSchemaConvertVisitor;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.struct.ThriftTypeID;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftSchemaConverter {
    private final FieldProjectionFilter fieldProjectionFilter;
    private ParquetConfiguration conf;

    public ThriftSchemaConverter() {
        this(FieldProjectionFilter.ALL_COLUMNS);
    }

    public ThriftSchemaConverter(Configuration configuration) {
        this((ParquetConfiguration)new HadoopParquetConfiguration(configuration));
    }

    public ThriftSchemaConverter(ParquetConfiguration configuration) {
        this();
        this.conf = configuration;
    }

    public ThriftSchemaConverter(Configuration configuration, FieldProjectionFilter fieldProjectionFilter) {
        this((ParquetConfiguration)new HadoopParquetConfiguration(configuration), fieldProjectionFilter);
    }

    public ThriftSchemaConverter(ParquetConfiguration configuration, FieldProjectionFilter fieldProjectionFilter) {
        this(fieldProjectionFilter);
        this.conf = configuration;
    }

    public ThriftSchemaConverter(FieldProjectionFilter fieldProjectionFilter) {
        this.fieldProjectionFilter = fieldProjectionFilter;
    }

    public MessageType convert(Class<? extends TBase<?, ?>> thriftClass) {
        return this.convert(ThriftSchemaConverter.toStructType(thriftClass));
    }

    public MessageType convert(ThriftType.StructType struct) {
        MessageType messageType = ThriftSchemaConvertVisitor.convert(struct, this.fieldProjectionFilter, true, this.conf);
        this.fieldProjectionFilter.assertNoUnmatchedPatterns();
        return messageType;
    }

    public static MessageType convertWithoutProjection(ThriftType.StructType struct) {
        return ThriftSchemaConvertVisitor.convert(struct, FieldProjectionFilter.ALL_COLUMNS, false, new Configuration());
    }

    public static <T extends TBase<?, ?>> ThriftType.StructType.StructOrUnionType structOrUnionType(Class<T> klass) {
        return TUnion.class.isAssignableFrom(klass) ? ThriftType.StructType.StructOrUnionType.UNION : ThriftType.StructType.StructOrUnionType.STRUCT;
    }

    public static ThriftType.StructType toStructType(Class<? extends TBase<?, ?>> thriftClass) {
        TStructDescriptor struct = TStructDescriptor.getInstance(thriftClass);
        return ThriftSchemaConverter.toStructType(struct);
    }

    private static ThriftType.StructType toStructType(TStructDescriptor struct) {
        List fields = struct.getFields();
        ArrayList<ThriftField> children = new ArrayList<ThriftField>(fields.size());
        for (TStructDescriptor.Field field : fields) {
            ThriftField.Requirement req = field.getFieldMetaData() == null ? ThriftField.Requirement.OPTIONAL : ThriftField.Requirement.fromType(field.getFieldMetaData().requirementType);
            children.add(ThriftSchemaConverter.toThriftField(field.getName(), field, req));
        }
        return new ThriftType.StructType(children, ThriftSchemaConverter.structOrUnionType(struct.getThriftClass()));
    }

    static boolean isListElementType(Type repeatedType, ThriftField thriftElement) {
        if (repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() != 1 || repeatedType.asGroupType().getType(0).isRepetition(Type.Repetition.REPEATED)) {
            return true;
        }
        if (thriftElement != null && thriftElement.getType() instanceof ThriftType.StructType) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (ThriftField field : ((ThriftType.StructType)thriftElement.getType()).getChildren()) {
                fieldNames.add(field.getName());
            }
            return fieldNames.contains(repeatedType.asGroupType().getFieldName(0));
        }
        return false;
    }

    private static ThriftField toThriftField(String name, TStructDescriptor.Field field, ThriftField.Requirement requirement) {
        ThriftType type;
        switch (ThriftTypeID.fromByte(field.getType())) {
            default: {
                throw new UnsupportedOperationException("can't convert type of " + field);
            }
            case BOOL: {
                type = new ThriftType.BoolType();
                break;
            }
            case BYTE: {
                type = new ThriftType.ByteType();
                break;
            }
            case DOUBLE: {
                type = new ThriftType.DoubleType();
                break;
            }
            case I16: {
                type = new ThriftType.I16Type();
                break;
            }
            case I32: {
                type = new ThriftType.I32Type();
                break;
            }
            case I64: {
                type = new ThriftType.I64Type();
                break;
            }
            case STRING: {
                ThriftType.StringType stringType = new ThriftType.StringType();
                FieldMetaData fieldMetaData = field.getFieldMetaData();
                if (fieldMetaData != null && fieldMetaData.valueMetaData.isBinary()) {
                    stringType.setBinary(true);
                }
                type = stringType;
                break;
            }
            case STRUCT: {
                type = ThriftSchemaConverter.toStructType(field.gettStructDescriptor());
                break;
            }
            case MAP: {
                TStructDescriptor.Field mapKeyField = field.getMapKeyField();
                TStructDescriptor.Field mapValueField = field.getMapValueField();
                type = new ThriftType.MapType(ThriftSchemaConverter.toThriftField(mapKeyField.getName(), mapKeyField, requirement), ThriftSchemaConverter.toThriftField(mapValueField.getName(), mapValueField, requirement));
                break;
            }
            case SET: {
                TStructDescriptor.Field setElemField = field.getSetElemField();
                type = new ThriftType.SetType(ThriftSchemaConverter.toThriftField(setElemField.getName(), setElemField, requirement));
                break;
            }
            case LIST: {
                TStructDescriptor.Field listElemField = field.getListElemField();
                type = new ThriftType.ListType(ThriftSchemaConverter.toThriftField(listElemField.getName(), listElemField, requirement));
                break;
            }
            case UUID: 
            case ENUM: {
                if (field.isEnum()) {
                    Collection enumValues = field.getEnumValues();
                    ArrayList<ThriftType.EnumValue> values = new ArrayList<ThriftType.EnumValue>();
                    for (TEnum tEnum : enumValues) {
                        values.add(new ThriftType.EnumValue(tEnum.getValue(), tEnum.toString()));
                    }
                    type = new ThriftType.EnumType(values);
                    break;
                }
                type = new ThriftType.UUIDType();
            }
        }
        return new ThriftField(name, field.getId(), requirement, type);
    }
}

